/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.geometry;

import eu.hansolo.fx.geometry.BezierCurve;
import eu.hansolo.fx.geometry.FlatteningPathIterator;
import eu.hansolo.fx.geometry.Line;
import eu.hansolo.fx.geometry.PathIterator;
import eu.hansolo.fx.geometry.QuadIterator;
import eu.hansolo.fx.geometry.RectBounds;
import eu.hansolo.fx.geometry.Shape;
import eu.hansolo.fx.geometry.tools.Point;
import eu.hansolo.fx.geometry.transform.BaseTransform;

public class QuadCurve
extends Shape {
    public double x1;
    public double y1;
    public double ctrlx;
    public double ctrly;
    public double x2;
    public double y2;
    private static final int BELOW = -2;
    private static final int LOW_EDGE = -1;
    private static final int INSIDE = 0;
    private static final int HIGH_EDGE = 1;
    private static final int ABOVE = 2;

    public QuadCurve() {
    }

    public QuadCurve(double X1, double Y1, double CTRL_X, double CTRL_Y, double X2, double Y2) {
        this.setCurve(X1, Y1, CTRL_X, CTRL_Y, X2, Y2);
    }

    public void setCurve(double X1, double Y1, double CTRL_X, double CTRL_Y, double X2, double Y2) {
        this.x1 = X1;
        this.y1 = Y1;
        this.ctrlx = CTRL_X;
        this.ctrly = CTRL_Y;
        this.x2 = X2;
        this.y2 = Y2;
    }

    @Override
    public RectBounds getBounds() {
        double left = Math.min(Math.min(this.x1, this.x2), this.ctrlx);
        double top = Math.min(Math.min(this.y1, this.y2), this.ctrly);
        double right = Math.max(Math.max(this.x1, this.x2), this.ctrlx);
        double bottom = Math.max(Math.max(this.y1, this.y2), this.ctrly);
        return new RectBounds(left, top, right, bottom);
    }

    public BezierCurve toCubic() {
        return new BezierCurve(this.x1, this.y1, (this.x1 + 2.0 * this.ctrlx) / 3.0, (this.y1 + 2.0 * this.ctrly) / 3.0, (2.0 * this.ctrlx + this.x2) / 3.0, (2.0 * this.ctrly + this.y2) / 3.0, this.x2, this.y2);
    }

    public void setCurve(double[] COORDS, int OFFSET) {
        this.setCurve(COORDS[OFFSET + 0], COORDS[OFFSET + 1], COORDS[OFFSET + 2], COORDS[OFFSET + 3], COORDS[OFFSET + 4], COORDS[OFFSET + 5]);
    }

    public void setCurve(Point P1, Point CP, Point P2) {
        this.setCurve(P1.x, P1.y, CP.x, CP.y, P2.x, P2.y);
    }

    public void setCurve(Point[] POINTS, int OFFSET) {
        this.setCurve(POINTS[OFFSET + 0].x, POINTS[OFFSET + 0].y, POINTS[OFFSET + 1].x, POINTS[OFFSET + 1].y, POINTS[OFFSET + 2].x, POINTS[OFFSET + 2].y);
    }

    public void setCurve(QuadCurve QUAD_CURVE) {
        this.setCurve(QUAD_CURVE.x1, QUAD_CURVE.y1, QUAD_CURVE.ctrlx, QUAD_CURVE.ctrly, QUAD_CURVE.x2, QUAD_CURVE.y2);
    }

    public double getFlatnessSq() {
        return Line.ptSegDistSq(this.x1, this.y1, this.x2, this.y2, this.ctrlx, this.ctrly);
    }

    public static double getFlatnessSq(double[] COORDS, int OFFSET) {
        return Line.ptSegDistSq(COORDS[OFFSET + 0], COORDS[OFFSET + 1], COORDS[OFFSET + 4], COORDS[OFFSET + 5], COORDS[OFFSET + 2], COORDS[OFFSET + 3]);
    }

    public static double getFlatnessSq(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        return Line.ptSegDistSq(x1, y1, x2, y2, ctrlx, ctrly);
    }

    public double getFlatness() {
        return Line.ptSegDist(this.x1, this.y1, this.x2, this.y2, this.ctrlx, this.ctrly);
    }

    public static double getFlatness(double[] COORDS, int OFFSET) {
        return Line.ptSegDist(COORDS[OFFSET + 0], COORDS[OFFSET + 1], COORDS[OFFSET + 4], COORDS[OFFSET + 5], COORDS[OFFSET + 2], COORDS[OFFSET + 3]);
    }

    public static double getFlatness(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        return Line.ptSegDist(x1, y1, x2, y2, ctrlx, ctrly);
    }

    public void subdivide(QuadCurve LEFT, QuadCurve RIGHT) {
        QuadCurve.subdivide(this, LEFT, RIGHT);
    }

    public static void subdivide(QuadCurve SOURCE, QuadCurve LEFT, QuadCurve RIGHT) {
        double x1 = SOURCE.x1;
        double y1 = SOURCE.y1;
        double ctrlx = SOURCE.ctrlx;
        double ctrly = SOURCE.ctrly;
        double x2 = SOURCE.x2;
        double y2 = SOURCE.y2;
        double ctrlx1 = (x1 + ctrlx) / 2.0;
        double ctrly1 = (y1 + ctrly) / 2.0;
        double ctrlx2 = (x2 + ctrlx) / 2.0;
        double ctrly2 = (y2 + ctrly) / 2.0;
        ctrlx = (ctrlx1 + ctrlx2) / 2.0;
        ctrly = (ctrly1 + ctrly2) / 2.0;
        if (LEFT != null) {
            LEFT.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx, ctrly);
        }
        if (RIGHT != null) {
            RIGHT.setCurve(ctrlx, ctrly, ctrlx2, ctrly2, x2, y2);
        }
    }

    public static void subdivide(double[] SOURCE, int SOURCE_OFFSET, double[] LEFT, int LEFT_OFFSET, double[] RIGHT, int RIGHT_OFFSET) {
        double x1 = SOURCE[SOURCE_OFFSET + 0];
        double y1 = SOURCE[SOURCE_OFFSET + 1];
        double ctrlx = SOURCE[SOURCE_OFFSET + 2];
        double ctrly = SOURCE[SOURCE_OFFSET + 3];
        double x2 = SOURCE[SOURCE_OFFSET + 4];
        double y2 = SOURCE[SOURCE_OFFSET + 5];
        if (LEFT != null) {
            LEFT[LEFT_OFFSET + 0] = x1;
            LEFT[LEFT_OFFSET + 1] = y1;
        }
        if (RIGHT != null) {
            RIGHT[RIGHT_OFFSET + 4] = x2;
            RIGHT[RIGHT_OFFSET + 5] = y2;
        }
        x1 = (x1 + ctrlx) / 2.0;
        y1 = (y1 + ctrly) / 2.0;
        x2 = (x2 + ctrlx) / 2.0;
        y2 = (y2 + ctrly) / 2.0;
        ctrlx = (x1 + x2) / 2.0;
        ctrly = (y1 + y2) / 2.0;
        if (LEFT != null) {
            LEFT[LEFT_OFFSET + 2] = x1;
            LEFT[LEFT_OFFSET + 3] = y1;
            LEFT[LEFT_OFFSET + 4] = ctrlx;
            LEFT[LEFT_OFFSET + 5] = ctrly;
        }
        if (RIGHT != null) {
            RIGHT[RIGHT_OFFSET + 0] = ctrlx;
            RIGHT[RIGHT_OFFSET + 1] = ctrly;
            RIGHT[RIGHT_OFFSET + 2] = x2;
            RIGHT[RIGHT_OFFSET + 3] = y2;
        }
    }

    public static int solveQuadratic(double[] EQN) {
        return QuadCurve.solveQuadratic(EQN, EQN);
    }

    public static int solveQuadratic(double[] EQN, double[] RES) {
        double a = EQN[2];
        double b = EQN[1];
        double c = EQN[0];
        int roots = 0;
        if (Double.compare(a, 0.0) == 0) {
            if (Double.compare(b, 0.0) == 0) {
                return -1;
            }
            RES[roots++] = -c / b;
        } else {
            double d = b * b - 4.0 * a * c;
            if (d < 0.0) {
                return 0;
            }
            d = Math.sqrt(d);
            if (b < 0.0) {
                d = -d;
            }
            double q = (b + d) / -2.0;
            RES[roots++] = q / a;
            if (q != 0.0) {
                RES[roots++] = c / q;
            }
        }
        return roots;
    }

    @Override
    public boolean contains(Point POINT) {
        return this.contains(POINT.x, POINT.y);
    }

    @Override
    public boolean contains(double X, double Y) {
        double x1 = this.x1;
        double dx = X - x1;
        double y1 = this.y1;
        double yc = this.ctrly;
        double y2 = this.y2;
        double ky = y1 - 2.0 * yc + y2;
        double dy = Y - y1;
        double xc = this.ctrlx;
        double x2 = this.x2;
        double kx = x1 - 2.0 * xc + x2;
        double dxl = x2 - x1;
        double dyl = y2 - y1;
        double t0 = (dx * ky - dy * kx) / (dxl * ky - dyl * kx);
        if (t0 < 0.0 || t0 > 1.0 || t0 != t0) {
            return false;
        }
        double xb = kx * t0 * t0 + 2.0 * (xc - x1) * t0 + x1;
        double yb = ky * t0 * t0 + 2.0 * (yc - y1) * t0 + y1;
        double xl = dxl * t0 + x1;
        double yl = dyl * t0 + y1;
        return X >= xb && X < xl || X >= xl && X < xb || Y >= yb && Y < yl || Y >= yl && Y < yb;
    }

    private static void fillEqn(double[] EQN, double VAL, double C1, double CP, double C2) {
        EQN[0] = C1 - VAL;
        EQN[1] = CP + CP - C1 - C1;
        EQN[2] = C1 - CP - CP + C2;
    }

    private static int evalQuadratic(double[] VALUES, int NUM, boolean INCLUDE_0, boolean INCLUDE_1, double[] INFLECT, double C1, double CTRL, double C2) {
        int j = 0;
        int i = 0;
        while (i < NUM) {
            double t = VALUES[i];
            if ((INCLUDE_0 ? t >= 0.0 : t > 0.0) && (INCLUDE_1 ? t <= 1.0 : t < 1.0) && (INFLECT == null || INFLECT[1] + 2.0 * INFLECT[2] * t != 0.0)) {
                double u = 1.0 - t;
                VALUES[j++] = C1 * u * u + 2.0 * CTRL * t * u + C2 * t * t;
            }
            ++i;
        }
        return j;
    }

    private static int getTag(double COORD, double LOW, double HIGH) {
        if (COORD <= LOW) {
            return COORD < LOW ? -2 : -1;
        }
        if (COORD >= HIGH) {
            return COORD > HIGH ? 2 : 1;
        }
        return 0;
    }

    private static boolean inwards(int PT_TAG, int OPT_1_TAG, int OPT_2_TAG) {
        switch (PT_TAG) {
            default: {
                return false;
            }
            case -1: {
                return OPT_1_TAG >= 0 || OPT_2_TAG >= 0;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return OPT_1_TAG <= 0 || OPT_2_TAG <= 0;
    }

    @Override
    public boolean intersects(double X, double Y, double WIDTH, double HEIGHT) {
        int c2tag;
        boolean yoverlap;
        if (WIDTH <= 0.0 || HEIGHT <= 0.0) {
            return false;
        }
        double x1 = this.x1;
        double y1 = this.y1;
        int x1tag = QuadCurve.getTag(x1, X, X + WIDTH);
        int y1tag = QuadCurve.getTag(y1, Y, Y + HEIGHT);
        if (x1tag == 0 && y1tag == 0) {
            return true;
        }
        double x2 = this.x2;
        double y2 = this.y2;
        int x2tag = QuadCurve.getTag(x2, X, X + WIDTH);
        int y2tag = QuadCurve.getTag(y2, Y, Y + HEIGHT);
        if (x2tag == 0 && y2tag == 0) {
            return true;
        }
        double ctrlx = this.ctrlx;
        double ctrly = this.ctrly;
        int ctrlxtag = QuadCurve.getTag(ctrlx, X, X + WIDTH);
        int ctrlytag = QuadCurve.getTag(ctrly, Y, Y + HEIGHT);
        if (x1tag < 0 && x2tag < 0 && ctrlxtag < 0) {
            return false;
        }
        if (y1tag < 0 && y2tag < 0 && ctrlytag < 0) {
            return false;
        }
        if (x1tag > 0 && x2tag > 0 && ctrlxtag > 0) {
            return false;
        }
        if (y1tag > 0 && y2tag > 0 && ctrlytag > 0) {
            return false;
        }
        if (QuadCurve.inwards(x1tag, x2tag, ctrlxtag) && QuadCurve.inwards(y1tag, y2tag, ctrlytag)) {
            return true;
        }
        if (QuadCurve.inwards(x2tag, x1tag, ctrlxtag) && QuadCurve.inwards(y2tag, y1tag, ctrlytag)) {
            return true;
        }
        boolean xoverlap = x1tag * x2tag <= 0;
        boolean bl = yoverlap = y1tag * y2tag <= 0;
        if (x1tag == 0 && x2tag == 0 && yoverlap) {
            return true;
        }
        if (y1tag == 0 && y2tag == 0 && xoverlap) {
            return true;
        }
        double[] eqn = new double[3];
        double[] res = new double[3];
        if (!yoverlap) {
            QuadCurve.fillEqn(eqn, y1tag < 0 ? Y : Y + HEIGHT, y1, ctrly, y2);
            return QuadCurve.solveQuadratic(eqn, res) == 2 && QuadCurve.evalQuadratic(res, 2, true, true, null, x1, ctrlx, x2) == 2 && QuadCurve.getTag(res[0], X, X + WIDTH) * QuadCurve.getTag(res[1], X, X + WIDTH) <= 0;
        }
        if (!xoverlap) {
            QuadCurve.fillEqn(eqn, x1tag < 0 ? X : X + WIDTH, x1, ctrlx, x2);
            return QuadCurve.solveQuadratic(eqn, res) == 2 && QuadCurve.evalQuadratic(res, 2, true, true, null, y1, ctrly, y2) == 2 && QuadCurve.getTag(res[0], Y, Y + HEIGHT) * QuadCurve.getTag(res[1], Y, Y + HEIGHT) <= 0;
        }
        double dx = x2 - x1;
        double dy = y2 - y1;
        double k = y2 * x1 - x2 * y1;
        int c1tag = y1tag == 0 ? x1tag : QuadCurve.getTag((k + dx * (y1tag < 0 ? Y : Y + HEIGHT)) / dy, X, X + WIDTH);
        if (c1tag * (c2tag = y2tag == 0 ? x2tag : QuadCurve.getTag((k + dx * (y2tag < 0 ? Y : Y + HEIGHT)) / dy, X, X + WIDTH)) <= 0) {
            return true;
        }
        c1tag = c1tag * x1tag <= 0 ? y1tag : y2tag;
        QuadCurve.fillEqn(eqn, c2tag < 0 ? X : X + WIDTH, x1, ctrlx, x2);
        int num = QuadCurve.solveQuadratic(eqn, res);
        QuadCurve.evalQuadratic(res, num, true, true, null, y1, ctrly, y2);
        c2tag = QuadCurve.getTag(res[0], Y, Y + HEIGHT);
        return c1tag * c2tag <= 0;
    }

    @Override
    public boolean contains(double X, double Y, double WIDTH, double HEIGHT) {
        if (WIDTH <= 0.0 || HEIGHT <= 0.0) {
            return false;
        }
        return this.contains(X, Y) && this.contains(X + WIDTH, Y) && this.contains(X + WIDTH, Y + HEIGHT) && this.contains(X, Y + HEIGHT);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform TRANSFORM) {
        return new QuadIterator(this, TRANSFORM);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform TRANSFORM, double FLATNESS) {
        return new FlatteningPathIterator(this.getPathIterator(TRANSFORM), FLATNESS);
    }

    @Override
    public QuadCurve copy() {
        return new QuadCurve(this.x1, this.y1, this.ctrlx, this.ctrly, this.x2, this.y2);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QuadCurve) {
            QuadCurve curve = (QuadCurve)obj;
            return this.x1 == curve.x1 && this.y1 == curve.y1 && this.x2 == curve.x2 && this.y2 == curve.y2 && this.ctrlx == curve.ctrlx && this.ctrly == curve.ctrly;
        }
        return false;
    }
}

