/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum ArchiveType implements Api
{
    APK("apk", "apk", ".apk"),
    BIN("bin", "bin", ".bin"),
    CAB("cab", "cab", ".cab"),
    DEB("deb", "deb", ".deb"),
    DMG("dmg", "dmg", ".dmg"),
    MSI("msi", "msi", ".msi"),
    PKG("pkg", "pkg", ".pkg"),
    RPM("rpm", "rpm", ".rpm"),
    SRC_TAR("src.tar.gz", "src_tar", ".src.tar.gz", ".source.tar.gz", ".source.tar.gz"),
    TAR("tar", "tar", ".tar"),
    TAR_GZ("tar.gz", "tar.gz", ".tar.gz"),
    TAR_XZ("tar.xz", "tar.xz", ".tar.xz"),
    TGZ("tgz", "tgz", ".tgz"),
    TAR_Z("tar.Z", "tar.z", ".tar.Z"),
    ZIP("zip", "zip", ".zip"),
    EXE("exe", "exe", ".exe"),
    NONE("-", "", "-"),
    NOT_FOUND("", "", "");

    private final String uiString;
    private final String apiString;
    private final List<String> fileEndings;

    private ArchiveType(String uiString, String apiString, String ... fileEndings) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.fileEndings = List.of(fileEndings);
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public ArchiveType getDefault() {
        return NONE;
    }

    @Override
    public ArchiveType getNotFound() {
        return NOT_FOUND;
    }

    public ArchiveType[] getAll() {
        return ArchiveType.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static ArchiveType fromText(String text) {
        if (text == null) {
            return NOT_FOUND;
        }
        switch (text) {
            case "APK": 
            case "apk": 
            case ".apk": {
                return APK;
            }
            case "BIN": 
            case "bin": 
            case ".bin": {
                return BIN;
            }
            case "CAB": 
            case "cab": 
            case ".cab": {
                return CAB;
            }
            case "DEB": 
            case "deb": 
            case ".deb": {
                return DEB;
            }
            case "DMG": 
            case "dmg": 
            case ".dmg": {
                return DMG;
            }
            case "EXE": 
            case "exe": 
            case ".exe": {
                return EXE;
            }
            case "MSI": 
            case "msi": 
            case ".msi": {
                return MSI;
            }
            case "PKG": 
            case "pkg": 
            case ".pkg": {
                return PKG;
            }
            case "RPM": 
            case "rpm": 
            case ".rpm": {
                return RPM;
            }
            case "src_tar": 
            case "SRC_TAR": 
            case "source.tar.gz": 
            case "SRC.TAR.GZ": 
            case ".src.tar.gz": 
            case "src.tar.gz": {
                return SRC_TAR;
            }
            case "TAR.Z": 
            case "tar.Z": 
            case "tar.z": 
            case ".tar.Z": {
                return TAR_Z;
            }
            case "TAR.GZ": 
            case "tar.gz": 
            case ".tar.gz": {
                return TAR_GZ;
            }
            case "TAR.XZ": 
            case "tar.xz": 
            case ".tar.xz": {
                return TAR_XZ;
            }
            case "TGZ": 
            case "tgz": 
            case ".tgz": {
                return TGZ;
            }
            case "TAR": 
            case "tar": 
            case ".tar": {
                return TAR;
            }
            case "ZIP": 
            case "zip": 
            case ".zip": {
                return ZIP;
            }
        }
        return NOT_FOUND;
    }

    public List<String> getFileEndings() {
        return this.fileEndings;
    }

    public static ArchiveType getFromFileName(String filename) {
        if (filename == null || filename.isEmpty()) {
            return NONE;
        }
        ArchiveType[] archiveTypeArray = ArchiveType.values();
        int n = archiveTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArchiveType archiveType = archiveTypeArray[n2];
            for (String ending : archiveType.getFileEndings()) {
                if (!filename.toLowerCase().endsWith(ending)) continue;
                return archiveType;
            }
            ++n2;
        }
        return NONE;
    }

    public static List<ArchiveType> getAsList() {
        return Arrays.asList(ArchiveType.values());
    }
}

