/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.ArchiveType;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum BinaryType implements Api
{
    PACKAGE("Package", "package", ArchiveType.APK, ArchiveType.CAB, ArchiveType.SRC_TAR, ArchiveType.TAR, ArchiveType.TAR_GZ, ArchiveType.TAR_Z, ArchiveType.TAR_XZ, ArchiveType.TGZ, ArchiveType.ZIP),
    INSTALLER("Installer", "installer", ArchiveType.BIN, ArchiveType.PKG, ArchiveType.DMG, ArchiveType.EXE, ArchiveType.MSI, ArchiveType.DEB, ArchiveType.RPM),
    NONE("-", "", ArchiveType.NONE),
    NOT_FOUND("", "", ArchiveType.NOT_FOUND);

    private final String uiString;
    private final String apiString;
    private final List<ArchiveType> archiveTypes;

    private BinaryType(String uiString, String apiString, ArchiveType ... archiveTypes) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.archiveTypes = List.of(archiveTypes);
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public BinaryType getDefault() {
        return NONE;
    }

    @Override
    public BinaryType getNotFound() {
        return NOT_FOUND;
    }

    public BinaryType[] getAll() {
        return BinaryType.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static BinaryType fromText(String text) {
        if (text == null) {
            return NOT_FOUND;
        }
        switch (text) {
            case "package": 
            case "PACKAGE": 
            case "Package": {
                return PACKAGE;
            }
            case "INSTALLER": 
            case "installer": 
            case "Installer": {
                return INSTALLER;
            }
        }
        return NOT_FOUND;
    }

    public List<ArchiveType> getArchiveTypes() {
        return this.archiveTypes;
    }

    public static BinaryType getFromFileName(String filename) {
        if (filename == null || filename.isEmpty()) {
            return NONE;
        }
        BinaryType[] binaryTypeArray = BinaryType.values();
        int n = binaryTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryType binaryType = binaryTypeArray[n2];
            for (ArchiveType archiveType : binaryType.getArchiveTypes()) {
                for (String ending : archiveType.getFileEndings()) {
                    if (!filename.toLowerCase().endsWith(ending)) continue;
                    return binaryType;
                }
            }
            ++n2;
        }
        return NONE;
    }

    public static BinaryType getFromArchiveType(ArchiveType archiveType) {
        BinaryType[] binaryTypeArray = BinaryType.values();
        int n = binaryTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryType binaryType = binaryTypeArray[n2];
            if (binaryType.getArchiveTypes().contains(archiveType)) {
                return binaryType;
            }
            ++n2;
        }
        return NONE;
    }

    public static List<BinaryType> getAsList() {
        return Arrays.asList(BinaryType.values());
    }
}

