/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum Bitness implements Api
{
    BIT_32("32 Bit", "32", 32),
    BIT_64("64 Bit", "64", 64),
    NONE("-", "", 0),
    NOT_FOUND("", "", 0);

    private final String uiString;
    private final String apiString;
    private final int bits;

    private Bitness(String uiString, String apiString, int bits) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.bits = bits;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public Bitness getDefault() {
        return NONE;
    }

    @Override
    public Bitness getNotFound() {
        return NOT_FOUND;
    }

    public Bitness[] getAll() {
        return Bitness.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append(",\n").append("  \"").append("bits").append("\"").append(":").append(this.bits).append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append(",").append("\"").append("bits").append("\"").append(":").append(this.bits).append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public int getAsInt() {
        return this.bits;
    }

    public String getAsString() {
        return Integer.toString(this.bits);
    }

    public static Bitness fromText(String text) {
        if (text == null) {
            return NOT_FOUND;
        }
        switch (text) {
            case "32": 
            case "32BIT": 
            case "32Bit": 
            case "32bit": {
                return BIT_32;
            }
            case "64": 
            case "64BIT": 
            case "64Bit": 
            case "64bit": {
                return BIT_64;
            }
        }
        return NOT_FOUND;
    }

    public static Bitness fromInt(Integer bits) {
        switch (bits) {
            case 32: {
                return BIT_32;
            }
            case 64: {
                return BIT_64;
            }
        }
        return NOT_FOUND;
    }

    public static List<Bitness> getAsList() {
        return Arrays.asList(Bitness.values());
    }
}

