/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum FPU implements Api
{
    HARD_FLOAT("hardfloat", "hard_float"),
    SOFT_FLOAT("softfloat", "soft_float"),
    UNKNOWN("unknown", "unknown"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private FPU(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public FPU getDefault() {
        return UNKNOWN;
    }

    @Override
    public FPU getNotFound() {
        return NOT_FOUND;
    }

    public FPU[] getAll() {
        return FPU.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static FPU fromText(String text) {
        if (text == null) {
            return NOT_FOUND;
        }
        switch (text) {
            case "hard-float": 
            case "hardfloat": 
            case "HARD-FLOAT": 
            case "hard_float": 
            case "hfl": 
            case "HFLT": 
            case "hflt": 
            case "HARD_FLOAT": 
            case "HARDFLOAT": {
                return HARD_FLOAT;
            }
            case "softfloat": 
            case "soft-float": 
            case "sfl": 
            case "SFLT": 
            case "sflt": 
            case "SOFT-FLOAT": 
            case "soft_float": 
            case "SOFTFLOAT": 
            case "SOFT_FLOAT": {
                return SOFT_FLOAT;
            }
            case "unknown": 
            case "UNKNOWN": {
                return UNKNOWN;
            }
        }
        return NOT_FOUND;
    }

    public static List<FPU> getAsList() {
        return Arrays.asList(FPU.values());
    }
}

