/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.LibCType;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OperatingSystem implements Api
{
    ALPINE_LINUX("Alpine Linux", "linux", LibCType.MUSL){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of(LINUX, LINUX_MUSL);
        }
    }
    ,
    LINUX("Linux", "linux", LibCType.GLIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    LINUX_MUSL("Linux Musl", "linux", LibCType.MUSL){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of(LINUX, ALPINE_LINUX);
        }
    }
    ,
    MACOS("Mac OS", "macos", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    WINDOWS("Windows", "windows", LibCType.C_STD_LIB){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    SOLARIS("Solaris", "solaris", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    QNX("QNX", "qnx", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    AIX("AIX", "aix", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    NONE("-", "", LibCType.NONE){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    NOT_FOUND("", "", LibCType.NOT_FOUND){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    };

    private final String uiString;
    private final String apiString;
    private final LibCType libCType;

    private OperatingSystem(String uiString, String apiString, LibCType libCType) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.libCType = libCType;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public OperatingSystem getDefault() {
        return NONE;
    }

    @Override
    public OperatingSystem getNotFound() {
        return NOT_FOUND;
    }

    public OperatingSystem[] getAll() {
        return OperatingSystem.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append(",\n").append("  \"").append("lib_c_type").append("\"").append(":").append("\"").append(this.libCType.getApiString()).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append(",").append("\"").append("lib_c_type").append("\"").append(":").append("\"").append(this.libCType.getApiString()).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static OperatingSystem fromText(String text) {
        if (text == null) {
            return NOT_FOUND;
        }
        switch (text) {
            case "UNIX": 
            case "Unix": 
            case "unix": 
            case "-unix": 
            case "LINUX": 
            case "Linux": 
            case "linux": 
            case "-linux": {
                return LINUX;
            }
            case "linux_musl": 
            case "alpine_linux": 
            case "Alpine_Linux": 
            case "LINUX_MUSL": 
            case "-linux-musl": 
            case "alpine": 
            case "-linux_musl": 
            case "ALPINE LINUX": 
            case "Linux-Musl": 
            case "Linux_Musl": 
            case "ALPINE-LINUX": 
            case "alpine linux": 
            case "Alpine Linux": 
            case "alpine-linux": 
            case "ALPINE_LINUX": 
            case "ALPINE": 
            case "Alpine": 
            case "linux-musl": {
                return ALPINE_LINUX;
            }
            case "solaris": 
            case "SOLARIS": 
            case "-solaris": 
            case "Solaris": {
                return SOLARIS;
            }
            case "QNX": 
            case "qnx": 
            case "-qnx": {
                return QNX;
            }
            case "AIX": 
            case "aix": 
            case "-aix": {
                return AIX;
            }
            case "MACOSX": 
            case "Mac OS": 
            case "Mac-OS": 
            case "Mac_OS": 
            case "Mac OSX": 
            case "darwin": 
            case "mac-os": 
            case "mac_os": 
            case "macosx": 
            case "-MACOSX": 
            case "-darwin": 
            case "MAC": 
            case "OSX": 
            case "mac": 
            case "osx": 
            case "MACOS": 
            case "MacOS": 
            case "macos": 
            case "-macosx": 
            case "mac osx": {
                return MACOS;
            }
            case "Windows": 
            case "WIN": 
            case "Win": 
            case "win": 
            case "-win": 
            case "windows": 
            case "WINDOWS": {
                return WINDOWS;
            }
        }
        return NOT_FOUND;
    }

    public LibCType getLibCType() {
        return this.libCType;
    }

    public static List<OperatingSystem> getAsList() {
        return Arrays.asList(OperatingSystem.values());
    }

    public abstract List<OperatingSystem> getSynonyms();
}

