/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools.scopes;

import eu.hansolo.jdktools.scopes.Scope;
import java.util.Arrays;
import java.util.List;

public enum QualityScope implements Scope
{
    TCK_TESTED("TCK tested", "tck_tested"),
    AQAVIT_CERTIFIED("AQAVIT certified", "aqavit_certified");

    private final String uiString;
    private final String apiString;

    private QualityScope(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    public static Scope fromText(String text) {
        if (text == null) {
            return NOT_FOUND;
        }
        switch (text) {
            case "TCK_TESTED": 
            case "tck_tested": 
            case "tckTested": {
                return TCK_TESTED;
            }
            case "aqavitCertified": 
            case "aqavit_certified": 
            case "AQAVIT_CERTIFIED": {
                return AQAVIT_CERTIFIED;
            }
        }
        return NOT_FOUND;
    }

    public static List<QualityScope> getAsList() {
        return Arrays.asList(QualityScope.values());
    }
}

