/*
 * Decompiled with CFR 0.152.
 */
package insidefx.undecorator;

import insidefx.undecorator.UndecoratorController;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import org.eclipse.fx.osgi.util.OSGiFXMLLoader;

public class Undecorator
extends StackPane {
    public int SHADOW_WIDTH = 15;
    public int SAVED_SHADOW_WIDTH = 15;
    public static int RESIZE_PADDING = 7;
    public static int FEEDBACK_STROKE = 4;
    public static double ROUNDED_DELTA = 5.0;
    public static final Logger LOGGER = Logger.getLogger("Undecorator");
    public static ResourceBundle LOC;
    StageStyle stageStyle;
    @FXML
    private Button menu;
    @FXML
    private Button close;
    @FXML
    private Button maximize;
    @FXML
    private Button iconify;
    @FXML
    private Button resize;
    @FXML
    private Button fullscreen;
    @FXML
    private Label title;
    @FXML
    private Pane decorationRoot;
    @FXML
    private ContextMenu contextMenu;
    MenuItem maximizeMenuItem;
    CheckMenuItem fullScreenMenuItem;
    Region clientArea;
    Pane stageDecoration = null;
    Rectangle shadowRectangle;
    Pane glassPane;
    Rectangle dockFeedback;
    FadeTransition dockFadeTransition;
    Stage dockFeedbackPopup;
    ParallelTransition parallelTransition;
    Effect dsFocused;
    Effect dsNotFocused;
    UndecoratorController undecoratorController;
    Stage stage;
    Rectangle backgroundRect;
    String shadowBackgroundStyleClass = "decoration-shadow";
    String decorationBackgroundStyle = "decoration-background";
    TranslateTransition fullscreenButtonTransition;
    final Rectangle internal = new Rectangle();
    final Rectangle external = new Rectangle();
    BooleanProperty customMaximize = new SimpleBooleanProperty(false);
    BooleanProperty maximized = new SimpleBooleanProperty(false);
    BoundingBox originalBox;
    BoundingBox maximizedBox;

    public Undecorator(Stage stage, Region root, BoundingBox originalBox) {
        this(stage, root, "stagedecoration.fxml", StageStyle.UNDECORATED, originalBox);
    }

    public Undecorator(Stage stag, Region clientArea, String stageDecorationFxml, StageStyle st, BoundingBox originalBox) {
        this.create(stag, clientArea, ((Object)((Object)this)).getClass().getResource(stageDecorationFxml), st, originalBox);
    }

    public Undecorator(Stage stag, Region clientArea, URL stageDecorationFxmlAsURL, StageStyle st, BoundingBox originalBox) {
        this.create(stag, clientArea, stageDecorationFxmlAsURL, st, originalBox);
    }

    public void create(Stage stag, Region clientArea, URL stageDecorationFxmlAsURL, StageStyle st, BoundingBox originalBox) {
        this.originalBox = originalBox;
        this.stage = stag;
        this.clientArea = clientArea;
        this.setStageStyle(st);
        this.loadConfig();
        this.undecoratorController = new UndecoratorController(this);
        this.undecoratorController.setAsStageDraggable(this.stage, (Node)clientArea);
        this.dsFocused = new DropShadow(BlurType.TWO_PASS_BOX, Color.BLACK, (double)this.SHADOW_WIDTH, 0.0, 0.0, 0.0);
        this.dsNotFocused = new DropShadow(BlurType.TWO_PASS_BOX, Color.DARKGREY, (double)this.SHADOW_WIDTH, 0.0, 0.0, 0.0);
        this.shadowRectangle = new Rectangle();
        this.shadowRectangle.layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldBounds, Bounds newBounds) {
                if (Undecorator.this.SHADOW_WIDTH != 0) {
                    Undecorator.this.shadowRectangle.setVisible(true);
                    Undecorator.this.setShadowClip(newBounds);
                } else {
                    Undecorator.this.shadowRectangle.setVisible(false);
                }
            }
        });
        try {
            this.stageDecoration = (Pane)OSGiFXMLLoader.load((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (URL)stageDecorationFxmlAsURL, null, null, c -> this);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Decorations not found", ex);
        }
        this.initDecoration();
        this.undecoratorController.setStageResizableWith(this.stage, (Node)this.decorationRoot, RESIZE_PADDING, this.SHADOW_WIDTH);
        if (this.fullscreen != null) {
            this.fullscreen.setVisible(this.stage.isResizable());
        }
        if (this.resize != null) {
            this.resize.setVisible(this.stage.isResizable());
        }
        if (this.maximize != null) {
            this.maximize.setVisible(this.stage.isResizable());
        }
        if (this.iconify != null && !this.stage.isResizable()) {
            AnchorPane.setRightAnchor((Node)this.iconify, (Double)34.0);
        }
        this.glassPane = new Pane();
        this.glassPane.setMouseTransparent(true);
        this.buildDockFeedbackStage();
        this.title.getStyleClass().add((Object)"undecorator-label-titlebar");
        this.shadowRectangle.getStyleClass().add((Object)this.shadowBackgroundStyleClass);
        this.shadowRectangle.setMouseTransparent(true);
        super.setStyle("-fx-background-color:transparent;");
        this.backgroundRect = new Rectangle();
        this.backgroundRect.getStyleClass().add((Object)this.decorationBackgroundStyle);
        this.backgroundRect.setMouseTransparent(true);
        super.getChildren().addAll((Object[])new Node[]{clientArea, this.shadowRectangle, this.stageDecoration, this.glassPane});
        this.stage.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                Undecorator.this.updateShadow();
            }
        });
        if (this.fullscreen != null) {
            this.stage.fullScreenProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean fullscreenState) {
                    Undecorator.this.fullScreenMenuItem.setSelected(fullscreenState.booleanValue());
                    Undecorator.this.maximize.setVisible(fullscreenState == false);
                    Undecorator.this.iconify.setVisible(fullscreenState == false);
                    if (Undecorator.this.resize != null) {
                        Undecorator.this.resize.setVisible(fullscreenState == false);
                    }
                    if (fullscreenState.booleanValue()) {
                        Undecorator.this.fullscreen.getStyleClass().add((Object)"decoration-button-unfullscreen");
                        Undecorator.this.fullscreen.setTooltip(new Tooltip(LOC.getString("Restore")));
                        if (Undecorator.this.fullscreenButtonTransition != null) {
                            Undecorator.this.fullscreenButtonTransition.stop();
                        }
                        Undecorator.this.fullscreenButtonTransition = new TranslateTransition();
                        Undecorator.this.fullscreenButtonTransition.setDuration(Duration.millis((double)2000.0));
                        Undecorator.this.fullscreenButtonTransition.setToX(80.0);
                        Undecorator.this.fullscreenButtonTransition.setNode((Node)Undecorator.this.fullscreen);
                        Undecorator.this.fullscreenButtonTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent t) {
                                (this).Undecorator.this.fullscreenButtonTransition = null;
                            }
                        });
                        Undecorator.this.fullscreenButtonTransition.play();
                    } else {
                        Undecorator.this.fullscreen.getStyleClass().remove((Object)"decoration-button-unfullscreen");
                        Undecorator.this.fullscreen.setTooltip(new Tooltip(LOC.getString("FullScreen")));
                        if (Undecorator.this.fullscreenButtonTransition != null) {
                            Undecorator.this.fullscreenButtonTransition.stop();
                        }
                        Undecorator.this.fullscreenButtonTransition = new TranslateTransition();
                        Undecorator.this.fullscreenButtonTransition.setDuration(Duration.millis((double)1000.0));
                        Undecorator.this.fullscreenButtonTransition.setToX(0.0);
                        Undecorator.this.fullscreenButtonTransition.setNode((Node)Undecorator.this.fullscreen);
                        Undecorator.this.fullscreenButtonTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent t) {
                                (this).Undecorator.this.fullscreenButtonTransition = null;
                            }
                        });
                        Undecorator.this.fullscreenButtonTransition.play();
                    }
                }
            });
        }
        this.computeAllSizes();
    }

    void setShadowClip(Bounds newBounds) {
        this.external.relocate(newBounds.getMinX() - (double)this.SHADOW_WIDTH, newBounds.getMinY() - (double)this.SHADOW_WIDTH);
        this.internal.setX((double)this.SHADOW_WIDTH);
        this.internal.setY((double)this.SHADOW_WIDTH);
        this.internal.setWidth(newBounds.getWidth());
        this.internal.setHeight(newBounds.getHeight());
        this.internal.setArcWidth(this.shadowRectangle.getArcWidth());
        this.internal.setArcHeight(this.shadowRectangle.getArcHeight());
        this.external.setWidth(newBounds.getWidth() + (double)(this.SHADOW_WIDTH * 2));
        this.external.setHeight(newBounds.getHeight() + (double)(this.SHADOW_WIDTH * 2));
        Shape clip = Shape.subtract((Shape)this.external, (Shape)this.internal);
        this.shadowRectangle.setClip((Node)clip);
    }

    public void installAccelerators(Scene scene) {
        if (this.stage.isResizable()) {
            scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHORTCUT_DOWN}), (Object)new Runnable(){

                @Override
                public void run() {
                    Undecorator.this.setFullscreen(Undecorator.this.stage.isFullScreen());
                }
            });
        }
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), (Object)new Runnable(){

            @Override
            public void run() {
                Undecorator.this.stage.setIconified(!Undecorator.this.stage.isIconified());
            }
        });
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), (Object)new Runnable(){

            @Override
            public void run() {
                Undecorator.this.stage.close();
            }
        });
    }

    private void computeAllSizes() {
        double maxHeight;
        double minWidth = this.minWidth(this.getWidth());
        this.setMinWidth(minWidth);
        double minHeight = this.minHeight(this.getHeight());
        this.setMinHeight(minHeight);
        double prefWidth = this.prefWidth(this.getWidth());
        this.setPrefWidth(prefWidth);
        this.setWidth(prefWidth);
        double prefHeight = this.prefHeight(this.getHeight());
        this.setPrefHeight(prefHeight);
        this.setHeight(prefHeight);
        double maxWidth = this.maxWidth(this.getWidth());
        if (maxWidth > minWidth) {
            this.setMaxWidth(maxWidth);
        }
        if ((maxHeight = this.maxHeight(this.getHeight())) > minHeight) {
            this.setMaxHeight(maxHeight);
        }
    }

    protected double computePrefWidth(double d) {
        return this.clientArea.getPrefWidth() + (double)(this.SHADOW_WIDTH * 2) + (double)(RESIZE_PADDING * 2);
    }

    protected double computePrefHeight(double d) {
        return this.clientArea.getPrefHeight() + (double)(this.SHADOW_WIDTH * 2) + (double)(RESIZE_PADDING * 2);
    }

    protected double computeMaxHeight(double d) {
        double maxHeight = this.clientArea.getMaxHeight();
        if (maxHeight > 0.0) {
            return maxHeight + (double)(this.SHADOW_WIDTH * 2) + (double)(RESIZE_PADDING * 2);
        }
        return maxHeight;
    }

    protected double computeMinHeight(double d) {
        double d2 = super.computeMinHeight(d);
        return d2 += (double)(this.SHADOW_WIDTH * 2 + RESIZE_PADDING * 2);
    }

    protected double computeMaxWidth(double d) {
        double maxWidth = this.clientArea.getMaxWidth();
        if (maxWidth > 0.0) {
            return maxWidth + (double)(this.SHADOW_WIDTH * 2) + (double)(RESIZE_PADDING * 2);
        }
        return maxWidth;
    }

    protected double computeMinWidth(double d) {
        double d2 = super.computeMinWidth(d);
        return d2 += (double)(this.SHADOW_WIDTH * 2 + RESIZE_PADDING * 2);
    }

    public void setStageStyle(StageStyle st) {
        this.stageStyle = st;
    }

    public StageStyle getStageStyle() {
        return this.stageStyle;
    }

    public void setFadeInTransition() {
        super.setOpacity(0.0);
        this.stage.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                if (t1.booleanValue()) {
                    FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)2.0), (Node)Undecorator.this);
                    fadeTransition.setToValue(1.0);
                    fadeTransition.play();
                }
            }
        });
    }

    public void setFadeOutTransition() {
        FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)1.0), (Node)this);
        fadeTransition.setToValue(0.0);
        fadeTransition.play();
        fadeTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Undecorator.this.stage.hide();
                if (Undecorator.this.dockFeedbackPopup != null && Undecorator.this.dockFeedbackPopup.isShowing()) {
                    Undecorator.this.dockFeedbackPopup.hide();
                }
            }
        });
    }

    public void removeDefaultBackgroundStyleClass() {
        this.shadowRectangle.getStyleClass().remove((Object)this.shadowBackgroundStyleClass);
    }

    public Rectangle getShadowNode() {
        return this.shadowRectangle;
    }

    public Rectangle getBackgroundRectangle() {
        return this.backgroundRect;
    }

    public void setBackgroundOpacity(double opacity) {
        this.shadowRectangle.setOpacity(opacity);
    }

    public final BooleanProperty customMaximizeProperty() {
        return this.customMaximize;
    }

    public final boolean isCustomMaximize() {
        return this.customMaximizeProperty().get();
    }

    public final void setCustomMaximize(boolean customMaximize) {
        this.customMaximizeProperty().set(customMaximize);
    }

    public void initDecoration() {
        MenuItem minimizeMenuItem = null;
        this.contextMenu.setAutoHide(true);
        if (this.iconify != null) {
            minimizeMenuItem = new MenuItem(LOC.getString("Minimize"));
            minimizeMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            minimizeMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    Undecorator.this.stage.setIconified(true);
                }
            });
            this.contextMenu.getItems().add((Object)minimizeMenuItem);
        }
        if (this.maximize != null && this.stage.isResizable()) {
            this.maximizeMenuItem = new MenuItem(LOC.getString("Maximize"));
            this.maximizeMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    Undecorator.this.maximize(!Undecorator.this.isEffectivelyMaximized());
                    Undecorator.this.contextMenu.hide();
                }
            });
            this.contextMenu.getItems().addAll((Object[])new MenuItem[]{this.maximizeMenuItem, new SeparatorMenuItem()});
        }
        if (this.stageStyle != StageStyle.UTILITY && this.stage.isResizable()) {
            this.fullScreenMenuItem = new CheckMenuItem(LOC.getString("FullScreen"));
            this.fullScreenMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    Undecorator.this.setFullscreen(Undecorator.this.stage.isFocused());
                }
            });
            this.fullScreenMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHORTCUT_DOWN}));
            this.contextMenu.getItems().addAll((Object[])new MenuItem[]{this.fullScreenMenuItem, new SeparatorMenuItem()});
        }
        MenuItem closeMenuItem = new MenuItem(LOC.getString("Close"));
        closeMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Undecorator.this.stage.close();
            }
        });
        closeMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        this.contextMenu.getItems().add((Object)closeMenuItem);
        this.menu.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (Undecorator.this.contextMenu.isShowing()) {
                    Undecorator.this.contextMenu.hide();
                } else {
                    Undecorator.this.contextMenu.show((Node)Undecorator.this.menu, Side.BOTTOM, 0.0, 0.0);
                }
            }
        });
        this.close.setTooltip(new Tooltip(LOC.getString("Close")));
        this.close.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Undecorator.this.stage.close();
            }
        });
        this.maximized.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                if (!Undecorator.this.stage.isResizable()) {
                    return;
                }
                Tooltip tooltip = Undecorator.this.maximize.getTooltip();
                if (t1.booleanValue()) {
                    tooltip.setText(LOC.getString("Restore"));
                    Undecorator.this.maximizeMenuItem.setText(LOC.getString("Restore"));
                    Undecorator.this.maximize.getStyleClass().add((Object)"decoration-button-restore");
                    if (Undecorator.this.resize != null) {
                        Undecorator.this.resize.setVisible(false);
                    }
                } else {
                    tooltip.setText(LOC.getString("Maximize"));
                    Undecorator.this.maximizeMenuItem.setText(LOC.getString("Maximize"));
                    Undecorator.this.maximize.getStyleClass().remove((Object)"decoration-button-restore");
                    if (Undecorator.this.resize != null) {
                        Undecorator.this.resize.setVisible(true);
                    }
                }
            }
        });
        if (this.maximize != null) {
            this.maximize.setTooltip(new Tooltip(LOC.getString("Maximize")));
            this.maximize.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    Undecorator.this.maximize(!Undecorator.this.isEffectivelyMaximized());
                }
            });
        }
        if (this.fullscreen != null) {
            this.fullscreen.setTooltip(new Tooltip(LOC.getString("FullScreen")));
            this.fullscreen.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    Undecorator.this.setFullscreen(!Undecorator.this.stage.isFullScreen());
                }
            });
        }
        if (this.iconify != null) {
            this.iconify.setTooltip(new Tooltip(LOC.getString("Minimize")));
            this.iconify.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    Undecorator.this.stage.setIconified(true);
                }
            });
        }
        this.title.setText(this.stage.getTitle());
    }

    public void setFullscreen(final boolean fullscreen) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Undecorator.this.stage.setFullScreen(fullscreen);
                if (fullscreen) {
                    Undecorator.this.maximized.set(false);
                }
                Undecorator.this.updateShadow();
            }
        });
    }

    public void setAsStageDraggable(Stage stage, Node node) {
        this.undecoratorController.setAsStageDraggable(stage, node);
    }

    protected void updateShadow() {
        if (this.isFullScreen() || this.isEffectivelyMaximized()) {
            this.shadowRectangle.setEffect(null);
            super.getChildren().remove((Object)this.shadowRectangle);
            return;
        }
        this.addShadow();
    }

    protected void addShadow() {
        if (this.stage.isFocused()) {
            if (this.shadowRectangle.getEffect() != this.dsFocused) {
                this.shadowRectangle.setEffect(this.dsFocused);
            }
        } else if (this.shadowRectangle.getEffect() != this.dsNotFocused) {
            this.shadowRectangle.setEffect(this.dsNotFocused);
        }
        if (!super.getChildren().contains((Object)this.shadowRectangle)) {
            super.getChildren().add(1, (Object)this.shadowRectangle);
        }
    }

    public boolean isMaximized() {
        return this.maximized.get();
    }

    public boolean isEffectivelyMaximized() {
        if (this.isMaximized()) {
            return true;
        }
        ObservableList screens = Screen.getScreensForRectangle((double)this.stage.getX(), (double)this.stage.getY(), (double)this.stage.getWidth(), (double)this.stage.getHeight());
        if (screens.isEmpty()) {
            return false;
        }
        Screen screen = (Screen)screens.get(0);
        Rectangle2D bounds = screen.getVisualBounds();
        this.maximized.set(this.stage.getWidth() == bounds.getWidth() && this.stage.getHeight() == bounds.getHeight() && this.stage.getX() == bounds.getMinX() && this.stage.getY() == bounds.getMinY());
        return this.maximized.get();
    }

    public boolean isFullScreen() {
        return this.stage.isFullScreen();
    }

    public void layoutChildren() {
        Bounds b = super.getLayoutBounds();
        double w = b.getWidth();
        double h = b.getHeight();
        ObservableList list = super.getChildren();
        ROUNDED_DELTA = 0.0;
        int shadowWidth = this.isFullScreen() || this.isEffectivelyMaximized() ? 0 : this.SHADOW_WIDTH;
        this.updateShadow();
        for (Node node : list) {
            if (node == this.shadowRectangle) {
                this.shadowRectangle.setWidth(w - (double)(shadowWidth * 2));
                this.shadowRectangle.setHeight(h - (double)(shadowWidth * 2));
                this.shadowRectangle.setX((double)shadowWidth);
                this.shadowRectangle.setY((double)shadowWidth);
                continue;
            }
            if (node == this.backgroundRect) {
                this.backgroundRect.setWidth(w - (double)(shadowWidth * 2));
                this.backgroundRect.setHeight(h - (double)(shadowWidth * 2));
                this.backgroundRect.setX((double)shadowWidth);
                this.backgroundRect.setY((double)shadowWidth);
                continue;
            }
            if (node == this.stageDecoration) {
                this.stageDecoration.resize(w - (double)(shadowWidth * 2) - ROUNDED_DELTA * 2.0, h - (double)(shadowWidth * 2) - ROUNDED_DELTA * 2.0);
                this.stageDecoration.setLayoutX((double)shadowWidth + ROUNDED_DELTA);
                this.stageDecoration.setLayoutY((double)shadowWidth + ROUNDED_DELTA);
                continue;
            }
            node.resize(w - (double)(shadowWidth * 2) - ROUNDED_DELTA * 2.0, h - (double)(shadowWidth * 2) - ROUNDED_DELTA * 2.0);
            node.setLayoutX((double)shadowWidth + ROUNDED_DELTA);
            node.setLayoutY((double)shadowWidth + ROUNDED_DELTA);
        }
    }

    public int getShadowBorderSize() {
        return this.SHADOW_WIDTH * 2 + RESIZE_PADDING * 2;
    }

    public UndecoratorController getController() {
        return this.undecoratorController;
    }

    public Stage getStage() {
        return this.stage;
    }

    protected Pane getGlassPane() {
        return this.glassPane;
    }

    public void addGlassPane(Node node) {
        this.glassPane.getChildren().add((Object)node);
    }

    public void removeGlassPane(Node node) {
        this.glassPane.getChildren().remove((Object)node);
    }

    public Pane getStageDecorationNode() {
        return this.stageDecoration;
    }

    void buildDockFeedbackStage() {
        this.dockFeedbackPopup = new Stage(StageStyle.TRANSPARENT);
        this.dockFeedback = new Rectangle(0.0, 0.0, 100.0, 100.0);
        this.dockFeedback.setArcHeight(10.0);
        this.dockFeedback.setArcWidth(10.0);
        this.dockFeedback.setFill((Paint)Color.TRANSPARENT);
        this.dockFeedback.setStroke((Paint)Color.BLACK);
        this.dockFeedback.setStrokeWidth(2.0);
        this.dockFeedback.setCache(true);
        this.dockFeedback.setCacheHint(CacheHint.SPEED);
        this.dockFeedback.setEffect((Effect)new DropShadow(BlurType.TWO_PASS_BOX, Color.BLACK, 10.0, 0.2, 3.0, 3.0));
        this.dockFeedback.setMouseTransparent(true);
        BorderPane borderpane = new BorderPane();
        borderpane.setStyle("-fx-background-color:transparent");
        borderpane.setCenter((Node)this.dockFeedback);
        Scene scene = new Scene((Parent)borderpane);
        scene.setFill((Paint)Color.TRANSPARENT);
        this.dockFeedbackPopup.setScene(scene);
        this.dockFeedbackPopup.sizeToScene();
    }

    public void setDockFeedbackVisible(double x, double y, double width, double height) {
        this.dockFeedbackPopup.setX(x);
        this.dockFeedbackPopup.setY(y);
        this.dockFeedback.setX((double)this.SHADOW_WIDTH);
        this.dockFeedback.setY((double)this.SHADOW_WIDTH);
        this.dockFeedback.setHeight(height - (double)(this.SHADOW_WIDTH * 2));
        this.dockFeedback.setWidth(width - (double)(this.SHADOW_WIDTH * 2));
        this.dockFeedbackPopup.setWidth(width);
        this.dockFeedbackPopup.setHeight(height);
        this.dockFeedback.setOpacity(1.0);
        this.dockFeedbackPopup.show();
        this.dockFadeTransition = new FadeTransition();
        this.dockFadeTransition.setDuration(Duration.millis((double)200.0));
        this.dockFadeTransition.setNode((Node)this.dockFeedback);
        this.dockFadeTransition.setFromValue(0.0);
        this.dockFadeTransition.setToValue(1.0);
        this.dockFadeTransition.setAutoReverse(true);
        this.dockFadeTransition.setCycleCount(3);
        this.dockFadeTransition.play();
    }

    public void setDockFeedbackInvisible() {
        if (this.dockFeedbackPopup.isShowing()) {
            this.dockFeedbackPopup.hide();
            if (this.dockFadeTransition != null) {
                this.dockFadeTransition.stop();
            }
        }
    }

    void loadConfig() {
        Properties prop = new Properties();
        try {
            prop.load(Undecorator.class.getClassLoader().getResourceAsStream("skin/undecorator.properties"));
            this.SHADOW_WIDTH = Integer.parseInt(prop.getProperty("window-shadow-width"));
            RESIZE_PADDING = Integer.parseInt(prop.getProperty("window-resize-padding"));
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Error while loading confguration flie", ex);
        }
        LOC = ResourceBundle.getBundle("insidefx/undecorator/resources/localization", Locale.getDefault());
    }

    public void maximize(boolean maximize) {
        if (!this.isCustomMaximize()) {
            this.stage.setMaximized(!this.stage.isMaximized());
            this.maximized.set(this.stage.isMaximized());
        } else {
            if (maximize) {
                this.originalBox = new BoundingBox(this.stage.getX(), this.stage.getY(), this.stage.getWidth(), this.stage.getHeight());
                ObservableList screens = Screen.getScreensForRectangle((double)this.stage.getX(), (double)this.stage.getY(), (double)this.stage.getWidth(), (double)this.stage.getHeight());
                Screen screen = screens.isEmpty() ? Screen.getPrimary() : (Screen)screens.get(0);
                Rectangle2D bounds = screen.getVisualBounds();
                this.maximizedBox = new BoundingBox(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
                this.stage.setX(this.maximizedBox.getMinX());
                this.stage.setY(this.maximizedBox.getMinY());
                this.stage.setWidth(this.maximizedBox.getWidth());
                this.stage.setHeight(this.maximizedBox.getHeight());
            } else {
                this.stage.setX(this.originalBox.getMinX());
                this.stage.setY(this.originalBox.getMinY());
                this.stage.setWidth(this.originalBox.getWidth());
                this.stage.setHeight(this.originalBox.getHeight());
                this.shadowRectangle.setVisible(true);
            }
            this.maximized.set(maximize);
        }
        this.updateShadow();
    }

    public BoundingBox getOriginalBox() {
        return this.originalBox;
    }
}

