/*
 * Decompiled with CFR 0.152.
 */
package insidefx.undecorator;

import insidefx.undecorator.Undecorator;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class UndecoratorController {
    static final int DOCK_NONE = 0;
    static final int DOCK_LEFT = 1;
    static final int DOCK_RIGHT = 2;
    static final int DOCK_TOP = 4;
    int lastDocked = 0;
    private static double initX = -1.0;
    private static double initY = -1.0;
    private static double newX;
    private static double newY;
    private static int RESIZE_PADDING;
    private static int SHADOW_WIDTH;
    Undecorator undecorator;
    static boolean isMacOS;
    static final int MAXIMIZE_BORDER = 20;
    private boolean offsetLeftAllignment;
    private double xOffsetRatio;
    private double yOffset;

    static {
        isMacOS = false;
    }

    public UndecoratorController(Undecorator ud) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("mac") != -1) {
            isMacOS = true;
        }
        this.offsetLeftAllignment = false;
        this.xOffsetRatio = -1.0;
        this.yOffset = -1.0;
        this.undecorator = ud;
    }

    public void close() {
        final Stage stage = this.undecorator.getStage();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                stage.fireEvent((Event)new WindowEvent((Window)stage, WindowEvent.WINDOW_CLOSE_REQUEST));
            }
        });
    }

    public void minimize() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UndecoratorController.this._minimize();
                }
            });
        } else {
            this._minimize();
        }
    }

    private void _minimize() {
        Stage stage = this.undecorator.getStage();
        stage.setIconified(true);
    }

    public void setStageResizableWith(final Stage stage, final Node node, int PADDING, int SHADOW) {
        RESIZE_PADDING = PADDING;
        SHADOW_WIDTH = SHADOW;
        node.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (UndecoratorController.this.undecorator.getStageStyle() != StageStyle.UTILITY && !stage.isFullScreen() && mouseEvent.getClickCount() > 1 && mouseEvent.getSceneY() - (double)SHADOW_WIDTH < 20.0) {
                    UndecoratorController.this.undecorator.maximize(false);
                    mouseEvent.consume();
                }
            }
        });
        node.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isPrimaryButtonDown()) {
                    initX = mouseEvent.getScreenX();
                    initY = mouseEvent.getScreenY();
                    mouseEvent.consume();
                }
            }
        });
        node.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (!mouseEvent.isPrimaryButtonDown() || initX == -1.0 && initY == -1.0) {
                    return;
                }
                if (stage.isFullScreen()) {
                    return;
                }
                if (mouseEvent.isStillSincePress()) {
                    return;
                }
                if (UndecoratorController.this.undecorator.isEffectivelyMaximized()) {
                    UndecoratorController.this.undecorator.maximized.set(false);
                    UndecoratorController.this.undecorator.addShadow();
                }
                newX = mouseEvent.getScreenX();
                newY = mouseEvent.getScreenY();
                double deltax = newX - initX;
                double deltay = newY - initY;
                Cursor cursor = node.getCursor();
                if (Cursor.E_RESIZE.equals(cursor)) {
                    UndecoratorController.this.setStageWidth(stage, stage.getWidth() + deltax);
                    mouseEvent.consume();
                } else if (Cursor.NE_RESIZE.equals(cursor)) {
                    if (UndecoratorController.this.setStageHeight(stage, stage.getHeight() - deltay)) {
                        UndecoratorController.this.setStageY(stage, stage.getY() + deltay);
                    }
                    UndecoratorController.this.setStageWidth(stage, stage.getWidth() + deltax);
                    mouseEvent.consume();
                } else if (Cursor.SE_RESIZE.equals(cursor)) {
                    UndecoratorController.this.setStageWidth(stage, stage.getWidth() + deltax);
                    UndecoratorController.this.setStageHeight(stage, stage.getHeight() + deltay);
                    mouseEvent.consume();
                } else if (Cursor.S_RESIZE.equals(cursor)) {
                    UndecoratorController.this.setStageHeight(stage, stage.getHeight() + deltay);
                    mouseEvent.consume();
                } else if (Cursor.W_RESIZE.equals(cursor)) {
                    if (UndecoratorController.this.setStageWidth(stage, stage.getWidth() - deltax)) {
                        stage.setX(stage.getX() + deltax);
                    }
                    mouseEvent.consume();
                } else if (Cursor.SW_RESIZE.equals(cursor)) {
                    if (UndecoratorController.this.setStageWidth(stage, stage.getWidth() - deltax)) {
                        stage.setX(stage.getX() + deltax);
                    }
                    UndecoratorController.this.setStageHeight(stage, stage.getHeight() + deltay);
                    mouseEvent.consume();
                } else if (Cursor.NW_RESIZE.equals(cursor)) {
                    if (UndecoratorController.this.setStageWidth(stage, stage.getWidth() - deltax)) {
                        stage.setX(stage.getX() + deltax);
                    }
                    if (UndecoratorController.this.setStageHeight(stage, stage.getHeight() - deltay)) {
                        UndecoratorController.this.setStageY(stage, stage.getY() + deltay);
                    }
                    mouseEvent.consume();
                } else if (Cursor.N_RESIZE.equals(cursor)) {
                    if (UndecoratorController.this.setStageHeight(stage, stage.getHeight() - deltay)) {
                        UndecoratorController.this.setStageY(stage, stage.getY() + deltay);
                    }
                    mouseEvent.consume();
                }
            }
        });
        node.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                Bounds boundsInParent;
                double y;
                if (stage.isFullScreen()) {
                    return;
                }
                if (!stage.isResizable()) {
                    return;
                }
                double x = mouseEvent.getX();
                if (UndecoratorController.this.isRightEdge(x, y = mouseEvent.getY(), boundsInParent = node.getBoundsInParent())) {
                    if (y < (double)(RESIZE_PADDING + SHADOW_WIDTH)) {
                        UndecoratorController.this.setCursor(node, Cursor.NE_RESIZE);
                    } else if (y > boundsInParent.getHeight() - (double)(RESIZE_PADDING + SHADOW_WIDTH)) {
                        UndecoratorController.this.setCursor(node, Cursor.SE_RESIZE);
                    } else {
                        UndecoratorController.this.setCursor(node, Cursor.E_RESIZE);
                    }
                } else if (UndecoratorController.this.isLeftEdge(x, y, boundsInParent)) {
                    if (y < (double)(RESIZE_PADDING + SHADOW_WIDTH)) {
                        UndecoratorController.this.setCursor(node, Cursor.NW_RESIZE);
                    } else if (y > boundsInParent.getHeight() - (double)(RESIZE_PADDING + SHADOW_WIDTH)) {
                        UndecoratorController.this.setCursor(node, Cursor.SW_RESIZE);
                    } else {
                        UndecoratorController.this.setCursor(node, Cursor.W_RESIZE);
                    }
                } else if (UndecoratorController.this.isTopEdge(x, y, boundsInParent)) {
                    UndecoratorController.this.setCursor(node, Cursor.N_RESIZE);
                } else if (UndecoratorController.this.isBottomEdge(x, y, boundsInParent)) {
                    UndecoratorController.this.setCursor(node, Cursor.S_RESIZE);
                } else {
                    UndecoratorController.this.setCursor(node, Cursor.DEFAULT);
                }
            }
        });
    }

    void setStageY(Stage stage, double y) {
        try {
            Screen screen;
            Rectangle2D visualBounds;
            ObservableList screensForRectangle = Screen.getScreensForRectangle((double)stage.getX(), (double)stage.getY(), (double)stage.getWidth(), (double)stage.getHeight());
            if (screensForRectangle.size() > 0 && y < (visualBounds = (screen = (Screen)screensForRectangle.get(0)).getVisualBounds()).getHeight() - 30.0 && y + (double)SHADOW_WIDTH >= visualBounds.getMinY()) {
                stage.setY(y);
            }
        }
        catch (Exception e) {
            Undecorator.LOGGER.log(Level.SEVERE, "setStageY issue", e);
        }
    }

    boolean setStageWidth(Stage stage, double width) {
        if (width >= stage.getMinWidth()) {
            stage.setWidth(width);
            initX = newX;
            this.undecorator.originalBox = new BoundingBox(stage.getX(), stage.getY(), stage.getWidth(), stage.getHeight());
            return true;
        }
        return false;
    }

    boolean setStageHeight(Stage stage, double height) {
        if (height >= stage.getMinHeight()) {
            stage.setHeight(height);
            initY = newY;
            this.undecorator.originalBox = new BoundingBox(stage.getX(), stage.getY(), stage.getWidth(), stage.getHeight());
            return true;
        }
        return false;
    }

    public void setAsStageDraggable(final Stage stage, final Node node) {
        node.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (UndecoratorController.this.undecorator.getStageStyle() != StageStyle.UTILITY && !stage.isFullScreen() && stage.isResizable() && mouseEvent.getClickCount() > 1 && mouseEvent.getSceneY() - (double)SHADOW_WIDTH < 20.0) {
                    UndecoratorController.this.undecorator.maximize(!UndecoratorController.this.undecorator.isEffectivelyMaximized());
                    mouseEvent.consume();
                }
            }
        });
        node.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (!mouseEvent.isPrimaryButtonDown()) {
                    return;
                }
                if (mouseEvent.isStillSincePress()) {
                    return;
                }
                if (UndecoratorController.this.xOffsetRatio == -1.0 || UndecoratorController.this.yOffset == -1.0) {
                    UndecoratorController.this.xOffsetRatio = mouseEvent.getSceneX() / stage.getWidth();
                    UndecoratorController.this.yOffset = mouseEvent.getSceneY();
                }
                if (UndecoratorController.this.undecorator.isEffectivelyMaximized() || UndecoratorController.this.undecorator.isFullScreen()) {
                    UndecoratorController.this.undecorator.maximize(false);
                    UndecoratorController.this.undecorator.setFullscreen(false);
                    UndecoratorController.this.yOffset += (double)UndecoratorController.this.undecorator.SHADOW_WIDTH;
                }
                double newX = mouseEvent.getScreenX();
                double newY = mouseEvent.getScreenY();
                UndecoratorController.this.setCursor(node, Cursor.HAND);
                stage.setX(newX - stage.getWidth() * UndecoratorController.this.xOffsetRatio);
                UndecoratorController.this.setStageY(stage, newY - UndecoratorController.this.yOffset);
                mouseEvent.consume();
            }
        });
        node.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (stage.isResizable()) {
                    UndecoratorController.this.undecorator.setDockFeedbackInvisible();
                    UndecoratorController.this.setCursor(node, Cursor.DEFAULT);
                    UndecoratorController.this.xOffsetRatio = -1.0;
                    UndecoratorController.this.yOffset = -1.0;
                }
            }
        });
        node.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
            }
        });
    }

    int getDockSide(MouseEvent mouseEvent) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = 0.0;
        double maxY = 0.0;
        ObservableList screens = Screen.getScreens();
        for (Screen screen : screens) {
            Rectangle2D visualBounds = screen.getVisualBounds();
            minX = Math.min(minX, visualBounds.getMinX());
            minY = Math.min(minY, visualBounds.getMinY());
            maxX = Math.max(maxX, visualBounds.getMaxX());
            maxY = Math.max(maxY, visualBounds.getMaxY());
        }
        if (mouseEvent.getScreenX() == minX) {
            return 1;
        }
        if (mouseEvent.getScreenX() >= maxX - 1.0) {
            return 2;
        }
        if (mouseEvent.getScreenY() <= minY) {
            return 4;
        }
        return 0;
    }

    public boolean isRightEdge(double x, double y, Bounds boundsInParent) {
        return x < boundsInParent.getWidth() && x > boundsInParent.getWidth() - (double)RESIZE_PADDING;
    }

    public boolean isTopEdge(double x, double y, Bounds boundsInParent) {
        return y >= 0.0 && y < (double)RESIZE_PADDING;
    }

    public boolean isBottomEdge(double x, double y, Bounds boundsInParent) {
        return y < boundsInParent.getHeight() && y > boundsInParent.getHeight() - (double)RESIZE_PADDING;
    }

    public boolean isLeftEdge(double x, double y, Bounds boundsInParent) {
        return x >= 0.0 && x < (double)RESIZE_PADDING;
    }

    public void setCursor(Node n, Cursor c) {
        n.setCursor(c);
    }
}

