/*
 * Decompiled with CFR 0.152.
 */
package insidefx.undecorator;

import insidefx.undecorator.Undecorator;
import javafx.geometry.BoundingBox;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class UndecoratorScene {
    public static final String DEFAULT_STYLESHEET = UndecoratorScene.class.getResource("/skin/undecorator.css").toExternalForm();
    public static final String DEFAULT_STYLESHEET_UTILITY = UndecoratorScene.class.getResource("/skin/undecoratorUtilityStage.css").toExternalForm();
    public static final String DEFAULT_STAGEDECORATION = "stagedecoration.fxml";
    public static final String DEFAULT_STAGEDECORATION_UTILITY = "stageUtilityDecoration.fxml";
    public static final String DEFAULT_STYLESHEET_TOUCH = UndecoratorScene.class.getResource("/skin/Touch/undecorator.css").toExternalForm();
    public static final String DEFAULT_STYLESHEET_UTILITY_TOUCH = UndecoratorScene.class.getResource("/skin/Touch/undecoratorUtilityStage.css").toExternalForm();
    public static final String DEFAULT_STAGEDECORATION_TOUCH = "stagedecorationTouch.fxml";
    public static final String DEFAULT_STAGEDECORATION_UTILITY_TOUCH = "stageUtilityDecorationTouch.fxml";
    public static String STYLESHEET = DEFAULT_STYLESHEET_TOUCH;
    public static String STYLESHEET_UTILITY = DEFAULT_STYLESHEET_UTILITY_TOUCH;
    public static String STAGEDECORATION = "stagedecorationTouch.fxml";
    public static String STAGEDECORATION_UTILITY = "stageUtilityDecorationTouch.fxml";
    Undecorator undecorator;

    public static void setClassicDecoration() {
        STAGEDECORATION = DEFAULT_STAGEDECORATION;
        STAGEDECORATION_UTILITY = DEFAULT_STAGEDECORATION_UTILITY;
        STYLESHEET = DEFAULT_STYLESHEET;
        STYLESHEET_UTILITY = DEFAULT_STYLESHEET_UTILITY;
    }

    public UndecoratorScene(Stage stage, Region root, BoundingBox originalBox) {
        this(stage, StageStyle.TRANSPARENT, root, STAGEDECORATION, originalBox);
    }

    public UndecoratorScene(Stage stage, StageStyle stageStyle, Region root, String stageDecorationFxml, BoundingBox originalBox) {
        if (stageDecorationFxml == null) {
            stageDecorationFxml = stageStyle == StageStyle.UTILITY ? STAGEDECORATION_UTILITY : STAGEDECORATION;
        }
        this.undecorator = new Undecorator(stage, root, stageDecorationFxml, stageStyle, originalBox);
        stage.getScene().setRoot((Parent)this.undecorator);
        if (stageStyle == StageStyle.UTILITY) {
            this.undecorator.getStylesheets().add((Object)STYLESHEET_UTILITY);
        } else {
            this.undecorator.getStylesheets().add((Object)STYLESHEET);
        }
        if (stage.getStyle() != StageStyle.TRANSPARENT) {
            stage.initStyle(StageStyle.TRANSPARENT);
        }
        stage.getScene().setFill((Paint)Color.TRANSPARENT);
        this.undecorator.installAccelerators(stage.getScene());
        stage.setMinWidth(this.undecorator.getMinWidth());
        stage.setMinHeight(this.undecorator.getMinHeight());
        stage.setWidth(this.undecorator.getPrefWidth());
        stage.setHeight(this.undecorator.getPrefHeight());
    }

    public void removeDefaultStylesheet() {
        this.undecorator.getStylesheets().remove((Object)STYLESHEET);
        this.undecorator.getStylesheets().remove((Object)STYLESHEET_UTILITY);
    }

    public void addStylesheet(String css) {
        this.undecorator.getStylesheets().add((Object)css);
    }

    public void setAsStageDraggable(Stage stage, Node node) {
        this.undecorator.setAsStageDraggable(stage, node);
    }

    public void setBackgroundStyle(String style) {
        this.undecorator.getShadowNode().setStyle(style);
    }

    public void setBackgroundOpacity(double opacity) {
        this.undecorator.getShadowNode().setOpacity(opacity);
    }

    public void setBackgroundPaint(Paint paint) {
        this.undecorator.removeDefaultBackgroundStyleClass();
        this.undecorator.getShadowNode().setFill(paint);
    }

    public Undecorator getUndecorator() {
        return this.undecorator;
    }

    public void setFadeInTransition() {
        this.undecorator.setFadeInTransition();
    }

    public void setFadeOutTransition() {
        this.undecorator.setFadeOutTransition();
    }
}

