/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MimeTypeFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import javax.activation.FileTypeMap;
import javax.activation.SecuritySupport;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private MimeTypeFile[] DB;
    private static final int PROG = 0;
    private static final String defaultType = "application/octet-stream";
    private static final String confDir;

    static {
        String dir = null;
        try {
            dir = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String home = System.getProperty("java.home");
                    String newdir = String.valueOf(home) + File.separator + "conf";
                    File conf = new File(newdir);
                    if (conf.exists()) {
                        return String.valueOf(newdir) + File.separator;
                    }
                    return String.valueOf(home) + File.separator + "lib" + File.separator;
                }
            });
        }
        catch (Exception exception) {}
        confDir = dir;
    }

    public MimetypesFileTypeMap() {
        Vector<MimeTypeFile> dbv = new Vector<MimeTypeFile>(5);
        MimeTypeFile mf = null;
        dbv.addElement(null);
        LogSupport.log("MimetypesFileTypeMap: load HOME");
        try {
            String path;
            String user_home = System.getProperty("user.home");
            if (user_home != null && (mf = this.loadFile(path = String.valueOf(user_home) + File.separator + ".mime.types")) != null) {
                dbv.addElement(mf);
            }
        }
        catch (SecurityException securityException) {}
        LogSupport.log("MimetypesFileTypeMap: load SYS");
        try {
            if (confDir != null && (mf = this.loadFile(String.valueOf(confDir) + "mime.types")) != null) {
                dbv.addElement(mf);
            }
        }
        catch (SecurityException securityException) {}
        LogSupport.log("MimetypesFileTypeMap: load JAR");
        this.loadAllResources(dbv, "META-INF/mime.types");
        LogSupport.log("MimetypesFileTypeMap: load DEF");
        mf = this.loadResource("/META-INF/mimetypes.default");
        if (mf != null) {
            dbv.addElement(mf);
        }
        this.DB = new MimeTypeFile[dbv.size()];
        dbv.copyInto(this.DB);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MimeTypeFile loadResource(String name) {
        InputStream clis;
        block20: {
            block19: {
                clis = null;
                clis = SecuritySupport.getResourceAsStream(this.getClass(), name);
                if (clis == null) break block19;
                MimeTypeFile mf = new MimeTypeFile(clis);
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MimetypesFileTypeMap: successfully loaded mime types file: " + name);
                }
                MimeTypeFile mimeTypeFile = mf;
                try {
                    if (clis == null) return mimeTypeFile;
                    clis.close();
                    return mimeTypeFile;
                }
                catch (IOException iOException) {}
                return mimeTypeFile;
            }
            try {
                if (!LogSupport.isLoggable()) break block20;
                LogSupport.log("MimetypesFileTypeMap: not loading mime types file: " + name);
            }
            catch (IOException e) {
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MimetypesFileTypeMap: can't load " + name, e);
                }
                try {
                    if (clis == null) return null;
                    clis.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
            catch (SecurityException sex) {
                block21: {
                    try {
                        if (!LogSupport.isLoggable()) break block21;
                        LogSupport.log("MimetypesFileTypeMap: can't load " + name, sex);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (clis == null) throw throwable;
                            clis.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {
                    if (clis == null) return null;
                    clis.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        try {
            if (clis == null) return null;
            clis.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    private void loadAllResources(Vector v, String name) {
        boolean anyLoaded;
        block31: {
            anyLoaded = false;
            try {
                URL[] urls;
                ClassLoader cld = null;
                cld = SecuritySupport.getContextClassLoader();
                if (cld == null) {
                    cld = this.getClass().getClassLoader();
                }
                if ((urls = cld != null ? SecuritySupport.getResources(cld, name) : SecuritySupport.getSystemResources(name)) == null) break block31;
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MimetypesFileTypeMap: getResources");
                }
                int i = 0;
                while (i < urls.length) {
                    block32: {
                        URL url = urls[i];
                        InputStream clis = null;
                        if (LogSupport.isLoggable()) {
                            LogSupport.log("MimetypesFileTypeMap: URL " + url);
                        }
                        try {
                            clis = SecuritySupport.openStream(url);
                            if (clis != null) {
                                v.addElement(new MimeTypeFile(clis));
                                anyLoaded = true;
                                if (LogSupport.isLoggable()) {
                                    LogSupport.log("MimetypesFileTypeMap: successfully loaded mime types from URL: " + url);
                                }
                            } else if (LogSupport.isLoggable()) {
                                LogSupport.log("MimetypesFileTypeMap: not loading mime types from URL: " + url);
                            }
                        }
                        catch (IOException ioex) {
                            if (LogSupport.isLoggable()) {
                                LogSupport.log("MimetypesFileTypeMap: can't load " + url, ioex);
                            }
                            try {
                                if (clis != null) {
                                    clis.close();
                                }
                                break block32;
                            }
                            catch (IOException iOException) {}
                            break block32;
                        }
                        catch (SecurityException sex) {
                            block33: {
                                try {
                                    if (!LogSupport.isLoggable()) break block33;
                                    LogSupport.log("MimetypesFileTypeMap: can't load " + url, sex);
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (clis != null) {
                                            clis.close();
                                        }
                                    }
                                    catch (IOException iOException) {}
                                    throw throwable;
                                }
                            }
                            try {
                                if (clis != null) {
                                    clis.close();
                                }
                                break block32;
                            }
                            catch (IOException iOException) {}
                            break block32;
                        }
                        try {
                            if (clis != null) {
                                clis.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                if (!LogSupport.isLoggable()) break block31;
                LogSupport.log("MimetypesFileTypeMap: can't load " + name, ex);
            }
        }
        if (!anyLoaded) {
            LogSupport.log("MimetypesFileTypeMap: !anyLoaded");
            MimeTypeFile mf = this.loadResource("/" + name);
            if (mf != null) {
                v.addElement(mf);
            }
        }
    }

    private MimeTypeFile loadFile(String name) {
        MimeTypeFile mtf = null;
        try {
            mtf = new MimeTypeFile(name);
        }
        catch (IOException iOException) {}
        return mtf;
    }

    public MimetypesFileTypeMap(String mimeTypeFileName) throws IOException {
        this();
        this.DB[0] = new MimeTypeFile(mimeTypeFileName);
    }

    public MimetypesFileTypeMap(InputStream is) {
        this();
        try {
            this.DB[0] = new MimeTypeFile(is);
        }
        catch (IOException iOException) {}
    }

    public synchronized void addMimeTypes(String mime_types) {
        if (this.DB[0] == null) {
            this.DB[0] = new MimeTypeFile();
        }
        this.DB[0].appendToRegistry(mime_types);
    }

    @Override
    public String getContentType(File f) {
        return this.getContentType(f.getName());
    }

    @Override
    public synchronized String getContentType(String filename) {
        int dot_pos = filename.lastIndexOf(".");
        if (dot_pos < 0) {
            return defaultType;
        }
        String file_ext = filename.substring(dot_pos + 1);
        if (file_ext.length() == 0) {
            return defaultType;
        }
        int i = 0;
        while (i < this.DB.length) {
            String result;
            if (this.DB[i] != null && (result = this.DB[i].getMIMETypeString(file_ext)) != null) {
                return result;
            }
            ++i;
        }
        return defaultType;
    }
}

