/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class UIDSet {
    public long start;
    public long end;

    public UIDSet() {
    }

    public UIDSet(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long size() {
        return this.end - this.start + 1L;
    }

    public static UIDSet[] createUIDSets(long[] uids) {
        if (uids == null) {
            return null;
        }
        ArrayList<UIDSet> v = new ArrayList<UIDSet>();
        int i = 0;
        while (i < uids.length) {
            UIDSet ms = new UIDSet();
            ms.start = uids[i];
            int j = i + 1;
            while (j < uids.length) {
                if (uids[j] != uids[j - 1] + 1L) break;
                ++j;
            }
            ms.end = uids[j - 1];
            v.add(ms);
            i = j - 1;
            ++i;
        }
        UIDSet[] uidset = new UIDSet[v.size()];
        return v.toArray(uidset);
    }

    public static UIDSet[] parseUIDSets(String uids) {
        if (uids == null) {
            return null;
        }
        ArrayList<UIDSet> v = new ArrayList<UIDSet>();
        StringTokenizer st = new StringTokenizer(uids, ",:", true);
        UIDSet cur = null;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.equals(",")) {
                    if (cur != null) {
                        v.add(cur);
                    }
                    cur = null;
                    continue;
                }
                if (s.equals(":")) continue;
                long n = Long.parseLong(s);
                if (cur != null) {
                    cur.end = n;
                    continue;
                }
                cur = new UIDSet(n, n);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (cur != null) {
            v.add(cur);
        }
        UIDSet[] uidset = new UIDSet[v.size()];
        return v.toArray(uidset);
    }

    public static String toString(UIDSet[] uidset) {
        if (uidset == null) {
            return null;
        }
        if (uidset.length == 0) {
            return "";
        }
        int i = 0;
        StringBuilder s = new StringBuilder();
        int size = uidset.length;
        while (true) {
            long start;
            long end;
            if ((end = uidset[i].end) > (start = uidset[i].start)) {
                s.append(start).append(':').append(end);
            } else {
                s.append(start);
            }
            if (++i >= size) break;
            s.append(',');
        }
        return s.toString();
    }

    public static long[] toArray(UIDSet[] uidset) {
        if (uidset == null) {
            return null;
        }
        long[] uids = new long[(int)UIDSet.size(uidset)];
        int i = 0;
        UIDSet[] uIDSetArray = uidset;
        int n = uidset.length;
        int n2 = 0;
        while (n2 < n) {
            UIDSet u = uIDSetArray[n2];
            long n3 = u.start;
            while (n3 <= u.end) {
                uids[i++] = n3++;
            }
            ++n2;
        }
        return uids;
    }

    public static long[] toArray(UIDSet[] uidset, long uidmax) {
        if (uidset == null) {
            return null;
        }
        long[] uids = new long[(int)UIDSet.size(uidset, uidmax)];
        int i = 0;
        UIDSet[] uIDSetArray = uidset;
        int n = uidset.length;
        int n2 = 0;
        while (n2 < n) {
            UIDSet u = uIDSetArray[n2];
            long n3 = u.start;
            while (n3 <= u.end) {
                if (uidmax >= 0L && n3 > uidmax) break;
                uids[i++] = n3++;
            }
            ++n2;
        }
        return uids;
    }

    public static long size(UIDSet[] uidset) {
        long count = 0L;
        if (uidset != null) {
            UIDSet[] uIDSetArray = uidset;
            int n = uidset.length;
            int n2 = 0;
            while (n2 < n) {
                UIDSet u = uIDSetArray[n2];
                count += u.size();
                ++n2;
            }
        }
        return count;
    }

    private static long size(UIDSet[] uidset, long uidmax) {
        long count = 0L;
        if (uidset != null) {
            UIDSet[] uIDSetArray = uidset;
            int n = uidset.length;
            int n2 = 0;
            while (n2 < n) {
                UIDSet u = uIDSetArray[n2];
                if (uidmax < 0L) {
                    count += u.size();
                } else if (u.start <= uidmax) {
                    count = u.end < uidmax ? (count += u.end - u.start + 1L) : (count += uidmax - u.start + 1L);
                }
                ++n2;
            }
        }
        return count;
    }
}

