/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import java.io.IOException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.search.StringTerm;

public final class BodyTerm
extends StringTerm {
    private static final long serialVersionUID = -4888862527916911385L;

    public BodyTerm(String pattern) {
        super(pattern);
    }

    @Override
    public boolean match(Message msg) {
        return this.matchPart(msg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchPart(Part p) {
        try {
            if (p.isMimeType("text/*")) {
                String s = (String)p.getContent();
                if (s != null) return super.match(s);
                return false;
            }
            if (!p.isMimeType("multipart/*")) {
                if (!p.isMimeType("message/rfc822")) return false;
                return this.matchPart((Part)p.getContent());
            }
            Multipart mp = (Multipart)p.getContent();
            int count = mp.getCount();
            int i = 0;
            while (true) {
                if (i >= count) {
                    return false;
                }
                if (this.matchPart(mp.getBodyPart(i))) {
                    return true;
                }
                ++i;
            }
        }
        catch (MessagingException messagingException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (RuntimeException runtimeException) {}
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BodyTerm)) {
            return false;
        }
        return super.equals(obj);
    }
}

