/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.output;

import com.sun.xml.bind.v2.runtime.output.UTF8XmlOutput;
import java.io.IOException;

public final class Encoded {
    public byte[] buf;
    public int len;
    private static final byte[][] entities = new byte[128][];
    private static final byte[][] attributeEntities = new byte[128][];

    static {
        Encoded.add('&', "&amp;", false);
        Encoded.add('<', "&lt;", false);
        Encoded.add('>', "&gt;", false);
        Encoded.add('\"', "&quot;", true);
        Encoded.add('\t', "&#x9;", true);
        Encoded.add('\r', "&#xD;", false);
        Encoded.add('\n', "&#xA;", true);
    }

    public Encoded() {
    }

    public Encoded(String text) {
        this.set(text);
    }

    public void ensureSize(int size) {
        if (this.buf == null || this.buf.length < size) {
            this.buf = new byte[size];
        }
    }

    public final void set(String text) {
        int length = text.length();
        this.ensureSize(length * 3 + 1);
        int ptr = 0;
        int i = 0;
        while (i < length) {
            block4: {
                char chr;
                block1: {
                    block5: {
                        block2: {
                            block3: {
                                chr = text.charAt(i);
                                if (chr <= '\u007f') break block1;
                                if (chr <= '\u07ff') break block2;
                                if ('\ud800' > chr || chr > '\udfff') break block3;
                                int uc = ((chr & 0x3FF) << 10 | text.charAt(++i) & 0x3FF) + 65536;
                                this.buf[ptr++] = (byte)(0xF0 | uc >> 18);
                                this.buf[ptr++] = (byte)(0x80 | uc >> 12 & 0x3F);
                                this.buf[ptr++] = (byte)(0x80 | uc >> 6 & 0x3F);
                                this.buf[ptr++] = (byte)(128 + (uc & 0x3F));
                                break block4;
                            }
                            this.buf[ptr++] = (byte)(224 + (chr >> 12));
                            this.buf[ptr++] = (byte)(128 + (chr >> 6 & 0x3F));
                            break block5;
                        }
                        this.buf[ptr++] = (byte)(192 + (chr >> 6));
                    }
                    this.buf[ptr++] = (byte)(128 + (chr & 0x3F));
                    break block4;
                }
                this.buf[ptr++] = (byte)chr;
            }
            ++i;
        }
        this.len = ptr;
    }

    public final void setEscape(String text, boolean isAttribute) {
        int length = text.length();
        this.ensureSize(length * 6 + 1);
        int ptr = 0;
        int i = 0;
        while (i < length) {
            block8: {
                int ptr1;
                block10: {
                    char chr;
                    block5: {
                        block9: {
                            block6: {
                                block7: {
                                    chr = text.charAt(i);
                                    ptr1 = ptr;
                                    if (chr <= '\u007f') break block5;
                                    if (chr <= '\u07ff') break block6;
                                    if ('\ud800' > chr || chr > '\udfff') break block7;
                                    int uc = ((chr & 0x3FF) << 10 | text.charAt(++i) & 0x3FF) + 65536;
                                    this.buf[ptr++] = (byte)(0xF0 | uc >> 18);
                                    this.buf[ptr++] = (byte)(0x80 | uc >> 12 & 0x3F);
                                    this.buf[ptr++] = (byte)(0x80 | uc >> 6 & 0x3F);
                                    this.buf[ptr++] = (byte)(128 + (uc & 0x3F));
                                    break block8;
                                }
                                this.buf[ptr1++] = (byte)(224 + (chr >> 12));
                                this.buf[ptr1++] = (byte)(128 + (chr >> 6 & 0x3F));
                                break block9;
                            }
                            this.buf[ptr1++] = (byte)(192 + (chr >> 6));
                        }
                        this.buf[ptr1++] = (byte)(128 + (chr & 0x3F));
                        break block10;
                    }
                    byte[] ent = attributeEntities[chr];
                    if (ent != null) {
                        if (isAttribute || entities[chr] != null) {
                            ptr1 = this.writeEntity(ent, ptr1);
                        } else {
                            this.buf[ptr1++] = (byte)chr;
                        }
                    } else {
                        this.buf[ptr1++] = (byte)chr;
                    }
                }
                ptr = ptr1;
            }
            ++i;
        }
        this.len = ptr;
    }

    private int writeEntity(byte[] entity, int ptr) {
        System.arraycopy(entity, 0, this.buf, ptr, entity.length);
        return ptr + entity.length;
    }

    public final void write(UTF8XmlOutput out) throws IOException {
        out.write(this.buf, 0, this.len);
    }

    public void append(char b) {
        this.buf[this.len++] = (byte)b;
    }

    public void compact() {
        byte[] b = new byte[this.len];
        System.arraycopy(this.buf, 0, b, 0, this.len);
        this.buf = b;
    }

    private static void add(char c, String s, boolean attOnly) {
        byte[] image = UTF8XmlOutput.toBytes(s);
        Encoded.attributeEntities[c] = image;
        if (!attOnly) {
            Encoded.entities[c] = image;
        }
    }
}

