/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect.opt;

import com.sun.xml.bind.Utils;
import com.sun.xml.bind.v2.bytecode.ClassTailor;
import com.sun.xml.bind.v2.runtime.reflect.opt.Injector;
import com.sun.xml.bind.v2.runtime.reflect.opt.SecureLoader;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class AccessorInjector {
    private static final Logger logger = Utils.getClassLogger();
    protected static final boolean noOptimize;
    private static final ClassLoader CLASS_LOADER;

    static {
        boolean bl = noOptimize = Utils.getSystemProperty(String.valueOf(ClassTailor.class.getName()) + ".noOptimize") != null;
        if (noOptimize) {
            logger.info("The optimized code generation is disabled");
        }
        CLASS_LOADER = SecureLoader.getClassClassLoader(AccessorInjector.class);
    }

    AccessorInjector() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?> prepare(Class beanClass, String templateClassName, String newClassName, String ... replacements) {
        byte[] image;
        Class c;
        ClassLoader cl;
        block6: {
            block5: {
                if (noOptimize) {
                    return null;
                }
                try {
                    cl = SecureLoader.getClassClassLoader(beanClass);
                    if (cl != null) break block5;
                    return null;
                }
                catch (SecurityException e) {
                    logger.log(Level.INFO, "Unable to create an optimized TransducedAccessor ", e);
                    return null;
                }
            }
            c = Injector.find(cl, newClassName);
            if (c != null) return c;
            image = AccessorInjector.tailor(templateClassName, newClassName, replacements);
            if (image != null) break block6;
            return null;
        }
        c = Injector.inject(cl, newClassName, image);
        if (c != null) return c;
        Injector.find(cl, newClassName);
        return c;
    }

    private static byte[] tailor(String templateClassName, String newClassName, String ... replacements) {
        InputStream resource = CLASS_LOADER != null ? CLASS_LOADER.getResourceAsStream(String.valueOf(templateClassName) + ".class") : ClassLoader.getSystemResourceAsStream(String.valueOf(templateClassName) + ".class");
        if (resource == null) {
            return null;
        }
        return ClassTailor.tailor(resource, templateClassName, newClassName, replacements);
    }
}

