/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.annotation.adapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;

public class CollapsedStringAdapter
extends XmlAdapter<String, String> {
    @Override
    public String unmarshal(String text) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        int s = 0;
        while (s < len) {
            if (CollapsedStringAdapter.isWhiteSpace(text.charAt(s))) break;
            ++s;
        }
        if (s == len) {
            return text;
        }
        StringBuilder result = new StringBuilder(len);
        if (s != 0) {
            int i = 0;
            while (i < s) {
                result.append(text.charAt(i));
                ++i;
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        int i = s + 1;
        while (i < len) {
            char ch = text.charAt(i);
            boolean b = CollapsedStringAdapter.isWhiteSpace(ch);
            if (!inStripMode || !b) {
                inStripMode = b;
                if (inStripMode) {
                    result.append(' ');
                } else {
                    result.append(ch);
                }
            }
            ++i;
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result.toString();
    }

    @Override
    public String marshal(String s) {
        return s;
    }

    protected static boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }
}

