/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.simple;

import java.awt.Color;
import java.awt.Paint;
import net.sf.jasperreports.chartthemes.simple.BlockFrameProvider;
import net.sf.jasperreports.chartthemes.simple.PaintProvider;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.ui.RectangleInsets;

public class BlockBorderProvider
implements BlockFrameProvider,
JRChangeEventsSupport {
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_PAINT = "paint";
    private RectangleInsets insets;
    private PaintProvider paint;
    private transient JRPropertyChangeSupport eventSupport;

    public BlockBorderProvider() {
    }

    public BlockBorderProvider(RectangleInsets insets, PaintProvider paint) {
        this.insets = insets;
        this.paint = paint;
    }

    @Override
    public BlockFrame getBlockFrame() {
        Paint borderPaint;
        Paint paint = borderPaint = this.paint == null ? null : this.paint.getPaint();
        BlockBorder border = this.insets == null ? (this.paint == null ? new BlockBorder() : new BlockBorder(borderPaint)) : (borderPaint == null ? new BlockBorder(this.insets, (Paint)Color.black) : new BlockBorder(this.insets, borderPaint));
        return border;
    }

    public RectangleInsets getInsets() {
        return this.insets;
    }

    public void setInsets(RectangleInsets insets) {
        RectangleInsets old = this.insets;
        this.insets = insets;
        this.getEventSupport().firePropertyChange(PROPERTY_INSETS, (Object)old, (Object)this.insets);
    }

    public PaintProvider getPaint() {
        return this.paint;
    }

    public void setPaint(PaintProvider paint) {
        PaintProvider old = this.paint;
        this.paint = paint;
        this.getEventSupport().firePropertyChange(PROPERTY_PAINT, (Object)old, (Object)this.paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        BlockBorderProvider blockBorderProvider = this;
        synchronized (blockBorderProvider) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport((Object)this);
            }
        }
        return this.eventSupport;
    }
}

