/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.simple;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import net.sf.jasperreports.chartthemes.simple.BlockFrameProvider;
import net.sf.jasperreports.chartthemes.simple.PaintProvider;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.LineBorder;
import org.jfree.chart.ui.RectangleInsets;

public class LineBorderProvider
implements BlockFrameProvider,
JRChangeEventsSupport {
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_LINE_STROKE = "lineStroke";
    public static final String PROPERTY_PAINT = "paint";
    private RectangleInsets insets;
    private Stroke lineStroke;
    private PaintProvider paint;
    private transient JRPropertyChangeSupport eventSupport;

    public LineBorderProvider() {
    }

    public LineBorderProvider(RectangleInsets insets, Stroke stroke, PaintProvider paint) {
        this.insets = insets;
        this.lineStroke = stroke;
        this.paint = paint;
    }

    @Override
    public BlockFrame getBlockFrame() {
        Paint borderPaint;
        RectangleInsets borderInsets = this.insets == null ? new RectangleInsets(1.0, 1.0, 1.0, 1.0) : this.insets;
        Stroke borderStroke = this.lineStroke == null ? new BasicStroke(1.0f) : this.lineStroke;
        Paint paint = borderPaint = this.paint == null ? null : this.paint.getPaint();
        if (borderPaint == null) {
            borderPaint = Color.BLACK;
        }
        return new LineBorder(borderPaint, borderStroke, borderInsets);
    }

    public RectangleInsets getInsets() {
        return this.insets;
    }

    public void setInsets(RectangleInsets insets) {
        RectangleInsets old = this.insets;
        this.insets = insets;
        this.getEventSupport().firePropertyChange(PROPERTY_INSETS, (Object)old, (Object)this.insets);
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(Stroke stroke) {
        Stroke old = this.lineStroke;
        this.lineStroke = stroke;
        this.getEventSupport().firePropertyChange(PROPERTY_LINE_STROKE, (Object)old, (Object)this.lineStroke);
    }

    public PaintProvider getPaint() {
        return this.paint;
    }

    public void setPaint(PaintProvider paint) {
        PaintProvider old = this.paint;
        this.paint = paint;
        this.getEventSupport().firePropertyChange(PROPERTY_PAINT, (Object)old, (Object)this.paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        LineBorderProvider lineBorderProvider = this;
        synchronized (lineBorderProvider) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport((Object)this);
            }
        }
        return this.eventSupport;
    }
}

