/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.spring;

import java.math.BigDecimal;
import net.sf.jasperreports.engine.JRFont;

public class ChartThemesUtilities {
    public static int getScale(double value) {
        return BigDecimal.valueOf(value).precision() - BigDecimal.valueOf(value).scale() - 1;
    }

    public static double getTruncatedValue(double value, int scale) {
        String newValue;
        String sign = value < 0.0 ? "-" : "";
        value = Math.abs(value);
        if (scale < 0) {
            newValue = (String.valueOf(String.valueOf(value *= Math.pow(10.0, -scale))) + "0000").substring(0, 4);
        } else if (scale > 2) {
            newValue = (String.valueOf(String.valueOf(value / Math.pow(10.0, scale - 2))) + "000").substring(0, 3);
        } else {
            newValue = String.valueOf(value);
            if (newValue.length() > 4) {
                newValue = newValue.substring(0, 4);
            }
        }
        return Double.valueOf(String.valueOf(sign) + newValue);
    }

    public static double getScaledValue(double value, int scale) {
        if (scale < 0) {
            return value * Math.pow(10.0, -scale);
        }
        if (scale > 2) {
            return value / Math.pow(10.0, scale - 2);
        }
        return value;
    }

    public static int getAwtFontStyle(JRFont font, int defaultBoldStyle, int defaultItalicStyle) {
        if (font == null) {
            return 0;
        }
        int style = 0;
        if (font.isOwnBold() == null && defaultBoldStyle == 1 || font.isOwnBold() != null && font.isOwnBold().booleanValue()) {
            style = 1;
        }
        if (font.isOwnItalic() == null && defaultItalicStyle == 2 || font.isOwnItalic() != null && font.isOwnItalic().booleanValue()) {
            style = style == 1 ? (style |= 2) : 2;
        }
        return style;
    }
}

