/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.spring;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.sf.jasperreports.chartthemes.spring.ChartThemesUtilities;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.text.TextUtils;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.Size2D;
import org.jfree.chart.ui.TextAnchor;

public class ScaledDialValueIndicator
extends DialValueIndicator {
    private static final long serialVersionUID = 10200L;
    private int scale;

    public ScaledDialValueIndicator() {
        this(0, 1);
    }

    public ScaledDialValueIndicator(int datasetIndex) {
        this(datasetIndex, 1);
    }

    public ScaledDialValueIndicator(int datasetIndex, int scale) {
        super(datasetIndex);
        this.setScale(scale);
    }

    public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
        Rectangle2D f = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)this.getRadius(), (double)this.getRadius());
        Arc2D.Double arc = new Arc2D.Double(f, this.getAngle(), 0.0, 0);
        Point2D pt = arc.getStartPoint();
        FontMetrics fm = g2.getFontMetrics(this.getFont());
        String s = this.getNumberFormat().format(this.getTemplateValue());
        Rectangle2D tb = TextUtils.getTextBounds((String)s, (Graphics2D)g2, (FontMetrics)fm);
        Rectangle2D bounds = RectangleAnchor.createRectangle((Size2D)new Size2D(tb.getWidth(), tb.getHeight()), (double)pt.getX(), (double)pt.getY(), (RectangleAnchor)this.getFrameAnchor());
        Rectangle2D fb = this.getInsets().createOutsetRectangle(bounds);
        g2.setPaint(this.getBackgroundPaint());
        g2.fill(fb);
        g2.setStroke(this.getOutlineStroke());
        g2.setPaint(this.getOutlinePaint());
        g2.draw(fb);
        String valueStr = this.getNumberFormat().format(ChartThemesUtilities.getScaledValue(plot.getValue(this.getDatasetIndex()), this.scale));
        Point2D pt2 = this.getValueAnchor().getAnchorPoint(bounds);
        g2.setPaint(this.getPaint());
        g2.setFont(this.getFont());
        TextUtils.drawAlignedString((String)valueStr, (Graphics2D)g2, (float)((float)pt2.getX()), (float)((float)pt2.getY()), (TextAnchor)this.getTextAnchor());
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ScaledDialValueIndicator)) {
            return false;
        }
        ScaledDialValueIndicator that = (ScaledDialValueIndicator)((Object)obj);
        if (this.scale != that.scale) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return 37 * super.hashCode() + this.scale;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

