/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.export;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.customvisualization.CVUtils;
import net.sf.jasperreports.customvisualization.export.CVElementAbstractGenericHandler;
import net.sf.jasperreports.customvisualization.export.CVElementJsonHandler;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.FileHtmlResourceHandler;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.export.HtmlExporterOutput;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.web.util.VelocityUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CVElementHtmlHandler
extends CVElementAbstractGenericHandler
implements GenericElementHtmlHandler {
    private static final CVElementHtmlHandler INSTANCE = new CVElementHtmlHandler();
    private static final Log log = LogFactory.getLog(CVElementHtmlHandler.class);
    private static final String COMPONENT_TEMPLATE = "net/sf/jasperreports/customvisualization/templates/component.vm";
    private final String[] scriptResourceLocations = new String[]{"net/sf/jasperreports/customvisualization/resources/require/require.js", "net/sf/jasperreports/customvisualization/resources/require/cv-component_static.js"};

    public static CVElementHtmlHandler getInstance() {
        return INSTANCE;
    }

    public String getHtmlFragment(JRHtmlExporterContext context, JRGenericPrintElement element) {
        if (context == null) {
            return "No JasperReports Context found";
        }
        return this.getHtmlFragment(context.getJasperReportsContext(), context, element);
    }

    public String getHtmlFragment(JasperReportsContext jrContext, JRHtmlExporterContext context, JRGenericPrintElement element) {
        Map originalConfiguration = (Map)element.getParameterValue("configuration");
        if (originalConfiguration == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Configuration object in the element " + element + " is NULL!"));
            }
            throw new JRRuntimeException("Configuration object in the element " + element + " is NULL!");
        }
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        configuration.putAll(originalConfiguration);
        configuration.put("element", element);
        if (context != null && context.getExporterRef() != null && context.getExporterRef().getReportContext() != null) {
            configuration.put("isInteractiveViewer", true);
        } else {
            configuration.put("isInteractiveViewer", false);
            try {
                ObjectMapper mapper = new ObjectMapper();
                Map<String, Object> jsonConfiguration = CVElementJsonHandler.createConfigurationForJSON(configuration, null);
                String instanceData = mapper.writeValueAsString(jsonConfiguration);
                configuration.put("instanceData", instanceData);
            }
            catch (Exception ex) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Error dumping the JSON for the configuration...: " + ex.getMessage()), (Throwable)ex);
                }
                throw new JRRuntimeException("Error dumping the JSON for the CVC configuration!", (Throwable)ex);
            }
            ArrayList<String> scripts = new ArrayList<String>();
            HtmlResourceHandler htmlResourceHandler = null;
            HtmlExporter exporter = (HtmlExporter)context.getExporterRef();
            if (exporter.getExporterOutput() != null && ((HtmlExporterOutput)exporter.getExporterOutput()).getResourceHandler() != null) {
                htmlResourceHandler = ((HtmlExporterOutput)exporter.getExporterOutput()).getResourceHandler();
            }
            RepositoryUtil repositoryUtil = RepositoryUtil.getInstance((JasperReportsContext)jrContext);
            String[] stringArray = this.scriptResourceLocations;
            int n = this.scriptResourceLocations.length;
            int n2 = 0;
            while (n2 < n) {
                String scriptResourceLocation = stringArray[n2];
                scripts.add(this.getResourceURL(scriptResourceLocation, htmlResourceHandler, repositoryUtil));
                ++n2;
            }
            scripts.add(this.getResourceURL((String)element.getParameterValue("script_uri"), htmlResourceHandler, repositoryUtil));
            velocityContext.put("scripts", scripts);
            velocityContext.put("cssUri", this.getResourceURL((String)element.getParameterValue("css_uri"), htmlResourceHandler, repositoryUtil));
            velocityContext.put("module", element.getParameterValue("module"));
        }
        velocityContext.put("elementId", CVUtils.getElementId(element));
        velocityContext.put("configuration", configuration);
        return VelocityUtil.processTemplate((String)COMPONENT_TEMPLATE, velocityContext);
    }

    protected String getResourceURL(String scriptResourceLocation, HtmlResourceHandler htmlResourceHandler, RepositoryUtil repositoryUtil) {
        if (scriptResourceLocation != null && htmlResourceHandler != null && !CVElementHtmlHandler.isUrl(scriptResourceLocation)) {
            if (htmlResourceHandler instanceof FileHtmlResourceHandler) {
                String resourceName = CVUtils.getResourceName(scriptResourceLocation);
                try {
                    byte[] resourceData = repositoryUtil.getBytesFromLocation(scriptResourceLocation);
                    htmlResourceHandler.handleResource(resourceName, resourceData);
                }
                catch (JRException e) {
                    throw new JRRuntimeException((Throwable)e);
                }
                return htmlResourceHandler.getResourcePath(resourceName);
            }
            return htmlResourceHandler.getResourcePath(scriptResourceLocation);
        }
        return scriptResourceLocation;
    }
}

