/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.export;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.customvisualization.CVUtils;
import net.sf.jasperreports.customvisualization.export.CVElementAbstractGenericHandler;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.GenericElementJsonHandler;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.JsonExporter;
import net.sf.jasperreports.engine.export.JsonExporterContext;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import net.sf.jasperreports.export.JsonExporterOutput;
import net.sf.jasperreports.web.util.VelocityUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CVElementJsonHandler
extends CVElementAbstractGenericHandler
implements GenericElementJsonHandler {
    private static final CVElementJsonHandler INSTANCE = new CVElementJsonHandler();
    private static final Log log = LogFactory.getLog(CVElementJsonHandler.class);
    private static final String CV_ELEMENT_JSON_TEMPLATE = "net/sf/jasperreports/customvisualization/resources/require/CVElementJsonTemplate.vm";

    public static CVElementJsonHandler getInstance() {
        return INSTANCE;
    }

    public String getJsonFragment(JsonExporterContext context, JRGenericPrintElement element) {
        Map originalConfiguration = (Map)element.getParameterValue("configuration");
        if (originalConfiguration == null) {
            log.warn((Object)("Configuration object in the element " + element + " is NULL!"));
            throw new JRRuntimeException("Configuration object in the element " + element + " is NULL!");
        }
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.putAll(originalConfiguration);
        ObjectMapper mapper = new ObjectMapper();
        try {
            if (!configuration.containsKey("instanceData")) {
                JsonExporter exporter = (JsonExporter)context.getExporterRef();
                HtmlResourceHandler htmlResourceHandler = exporter.getExporterOutput() != null ? ((JsonExporterOutput)exporter.getExporterOutput()).getResourceHandler() : null;
                Map<String, Object> jsonConfiguration = CVElementJsonHandler.createConfigurationForJSON(configuration, htmlResourceHandler);
                String instanceData = mapper.writeValueAsString(jsonConfiguration);
                configuration.put("instanceData", instanceData);
            }
        }
        catch (Exception ex) {
            log.warn((Object)("(JSON): Error dumping the JSON for the configuration...: " + ex.getMessage()), (Throwable)ex);
        }
        configuration.put("module", element.getParameterValue("module"));
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("elementId", CVUtils.getElementId(element));
        velocityContext.put("configuration", configuration);
        return VelocityUtil.processTemplate((String)CV_ELEMENT_JSON_TEMPLATE, velocityContext);
    }

    public static Map<String, Object> createConfigurationForJSON(Map<String, Object> configuration, HtmlResourceHandler htmlResourceHandler) {
        HashMap<String, Object> jsonConfiguration = new HashMap<String, Object>();
        JRTemplateGenericPrintElement element = (JRTemplateGenericPrintElement)configuration.get("element");
        if (configuration.containsKey("series")) {
            jsonConfiguration.put("series", configuration.get("series"));
        }
        if (element != null) {
            jsonConfiguration.put("width", element.getWidth());
            jsonConfiguration.put("height", element.getHeight());
            String[] stringArray = element.getPropertiesMap().getPropertyNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String prop = stringArray[n2];
                jsonConfiguration.put("property." + prop, element.getPropertiesMap().getProperty(prop));
                configuration.put("property." + prop, element.getPropertiesMap().getProperty(prop));
                ++n2;
            }
            jsonConfiguration.put("id", CVUtils.getElementId((JRGenericPrintElement)element));
            if (element.getParameterValue("script_uri") != null) {
                String scriptLocation = CVElementJsonHandler.getResourceURL((String)element.getParameterValue("script_uri"), htmlResourceHandler);
                configuration.put("script_uri", scriptLocation);
            }
            if (element.getParameterValue("css_uri") != null) {
                String cssLocation = CVElementJsonHandler.getResourceURL((String)element.getParameterValue("css_uri"), htmlResourceHandler);
                configuration.put("css_uri", cssLocation);
            }
        }
        for (String itemPropertyKey : configuration.keySet()) {
            Object value = configuration.get(itemPropertyKey);
            if (itemPropertyKey == null || itemPropertyKey.isEmpty() || itemPropertyKey.equals("element") || itemPropertyKey.equals("series") || value == null) continue;
            jsonConfiguration.put(itemPropertyKey, value.toString());
        }
        return jsonConfiguration;
    }

    protected static String getResourceURL(String scriptResourceLocation, HtmlResourceHandler htmlResourceHandler) {
        if (htmlResourceHandler != null && !CVElementJsonHandler.isUrl(scriptResourceLocation)) {
            return htmlResourceHandler.getResourcePath(scriptResourceLocation);
        }
        return scriptResourceLocation;
    }
}

