/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.export;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import net.sf.jasperreports.chrome.BrowserService;
import net.sf.jasperreports.chrome.Chrome;
import net.sf.jasperreports.chrome.PageOptions;
import net.sf.jasperreports.chrome.ResourceManager;
import net.sf.jasperreports.customvisualization.CVUtils;
import net.sf.jasperreports.customvisualization.export.CVElementAbstractImageDataProvider;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.util.Base64Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChromeCVElementImageDataProvider
extends CVElementAbstractImageDataProvider {
    private static final Log log = LogFactory.getLog(ChromeCVElementImageDataProvider.class);
    private final String[] scriptResourceLocations = new String[]{"net/sf/jasperreports/customvisualization/resources/require/require.js", "net/sf/jasperreports/customvisualization/resources/require/cv-component_static.js", "net/sf/jasperreports/customvisualization/scripts/customvisualization-chrome.js"};

    public boolean isEnabled(JasperReportsContext jasperReportsContext) {
        Chrome chrome = Chrome.instance((JasperReportsContext)jasperReportsContext);
        return chrome.isEnabled();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getImageData(JasperReportsContext jasperReportsContext, JRGenericPrintElement element) throws Exception {
        Object cssBase64;
        String cssUri;
        boolean renderAsPng;
        ArrayList<String> scriptFilenames;
        ResourceManager resourceManager;
        Chrome chrome;
        block21: {
            String cssResourceLocation;
            if (element.getParameterValue("configuration") == null) {
                throw new JRRuntimeException("Configuration object is null.");
            }
            chrome = Chrome.instance((JasperReportsContext)jasperReportsContext);
            resourceManager = ResourceManager.instance();
            scriptFilenames = new ArrayList<String>();
            String[] stringArray = this.scriptResourceLocations;
            int n = this.scriptResourceLocations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Configured script URI: " + element.getParameterValue("script_uri")));
                        log.debug((Object)("Configured css URI: " + element.getParameterValue("css_uri")));
                    }
                    scriptFilenames.add(resourceManager.getResourceLocation((String)element.getParameterValue("script_uri"), jasperReportsContext));
                    renderAsPng = CVUtils.isRenderAsPng(element);
                    String cssUriParameter = (String)element.getParameterValue("css_uri");
                    cssUri = null;
                    if (cssUriParameter != null) {
                        cssResourceLocation = resourceManager.getResourceLocation(cssUriParameter, jasperReportsContext);
                        if (!renderAsPng) break;
                        cssUri = cssResourceLocation;
                    }
                    break block21;
                }
                String scriptLocation = stringArray[n2];
                scriptFilenames.add(resourceManager.getResourceLocation(scriptLocation, jasperReportsContext));
                ++n2;
            }
            byte[] cssBytes = RepositoryUtil.getInstance((JasperReportsContext)jasperReportsContext).getBytesFromLocation(cssResourceLocation);
            cssBase64 = Base64Util.encode((byte[])cssBytes);
            cssUri = "data:text/css;base64," + (String)cssBase64;
        }
        String htmlPage = this.getHtmlPage(jasperReportsContext, element, scriptFilenames, cssUri);
        File htmlTempFile = File.createTempFile("cv_", ".html", resourceManager.getTempFolder(jasperReportsContext));
        try {
            byte[] data;
            block23: {
                cssBase64 = null;
                Object var12_16 = null;
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(htmlPage.getBytes());
                    try {
                        try (FileOutputStream os = new FileOutputStream(htmlTempFile);){
                            CVUtils.byteStreamCopy(is, os);
                        }
                        if (is == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (cssBase64 == null) {
                            cssBase64 = throwable;
                        } else if (cssBase64 != throwable) {
                            ((Throwable)cssBase64).addSuppressed(throwable);
                        }
                        if (is == null) throw cssBase64;
                        ((InputStream)is).close();
                        throw cssBase64;
                    }
                    ((InputStream)is).close();
                }
                catch (Throwable throwable) {
                    if (cssBase64 == null) {
                        cssBase64 = throwable;
                        throw cssBase64;
                    }
                    if (cssBase64 == throwable) throw cssBase64;
                    ((Throwable)cssBase64).addSuppressed(throwable);
                    throw cssBase64;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("wrote CV render HTML page to " + htmlTempFile));
            }
            PageOptions options = new PageOptions();
            options.setTimeout(CVUtils.getOwnTimeout(element));
            BrowserService service = chrome.getService();
            byte[] byArray = data = (byte[])service.evaluateInPage(htmlTempFile.toURI().toString(), options, page -> {
                Object resultValue = page.evaluatePromise("renderResult(" + !renderAsPng + ")");
                if (log.isTraceEnabled()) {
                    log.trace((Object)("got result " + resultValue));
                }
                byte[] imageData = null;
                if (resultValue != null) {
                    if (renderAsPng) {
                        Map resultMap = (Map)resultValue;
                        int width = (Integer)resultMap.get("w");
                        int height = (Integer)resultMap.get("h");
                        float zoomFactor = CVUtils.getZoomFactor(element);
                        imageData = page.captureScreenshot(width, height, (double)zoomFactor);
                    } else {
                        imageData = ((String)resultValue).getBytes(StandardCharsets.UTF_8);
                    }
                }
                return imageData;
            });
            return byArray;
        }
        finally {
            htmlTempFile.delete();
        }
    }
}

