/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRExpression;

public class Misc {
    private static final Set<String> SQLKEYWORDS = new HashSet<String>();

    static {
        SQLKEYWORDS.add("SELECT");
        SQLKEYWORDS.add("MICROSECOND");
        SQLKEYWORDS.add("SECOND");
        SQLKEYWORDS.add("MINUTE");
        SQLKEYWORDS.add("HOUR");
        SQLKEYWORDS.add("DAY");
        SQLKEYWORDS.add("WEEK");
        SQLKEYWORDS.add("MONTH");
        SQLKEYWORDS.add("QUARTER");
        SQLKEYWORDS.add("YEAR");
        SQLKEYWORDS.add("SECOND_MICROSECOND");
        SQLKEYWORDS.add("MINUTE_MICROSECOND");
        SQLKEYWORDS.add("MINUTE_SECOND");
        SQLKEYWORDS.add("HOUR_MICROSECOND");
        SQLKEYWORDS.add("HOUR_SECOND");
        SQLKEYWORDS.add("HOUR_MINUTE");
        SQLKEYWORDS.add("DAY_MICROSECOND");
        SQLKEYWORDS.add("DAY_SECOND");
        SQLKEYWORDS.add("DAY_MINUTE");
        SQLKEYWORDS.add("DAY_HOUR");
        SQLKEYWORDS.add("YEAR_MONTH");
        SQLKEYWORDS.add("IN");
        SQLKEYWORDS.add("NOT");
        SQLKEYWORDS.add("NATURAL");
        SQLKEYWORDS.add("INNER");
        SQLKEYWORDS.add("LEFT");
        SQLKEYWORDS.add("RIGHT");
        SQLKEYWORDS.add("FULL");
        SQLKEYWORDS.add("OUTER");
        SQLKEYWORDS.add("CROSS");
        SQLKEYWORDS.add("JOIN");
        SQLKEYWORDS.add("STRAIGHT_JOIN");
        SQLKEYWORDS.add("WHEN");
        SQLKEYWORDS.add("THEN");
        SQLKEYWORDS.add("ELSE");
        SQLKEYWORDS.add("CASE");
        SQLKEYWORDS.add("END");
        SQLKEYWORDS.add("ALL");
        SQLKEYWORDS.add("DISTINCT");
        SQLKEYWORDS.add("UNION");
        SQLKEYWORDS.add("INTERSECT");
        SQLKEYWORDS.add("MINUS");
        SQLKEYWORDS.add("EXCEPT");
        SQLKEYWORDS.add("ROW");
        SQLKEYWORDS.add("ROWS");
        SQLKEYWORDS.add("ONLY");
        SQLKEYWORDS.add("TOP");
        SQLKEYWORDS.add("INT");
        SQLKEYWORDS.add("FROM");
        SQLKEYWORDS.add("WHERE");
        SQLKEYWORDS.add("GROUP");
        SQLKEYWORDS.add("ORDER");
        SQLKEYWORDS.add("BY");
        SQLKEYWORDS.add("LIMIT");
        SQLKEYWORDS.add("HAVING");
        SQLKEYWORDS.add("OFFSET");
        SQLKEYWORDS.add("AS");
        SQLKEYWORDS.add("ON");
        SQLKEYWORDS.add("IN");
        SQLKEYWORDS.add("ASC");
        SQLKEYWORDS.add("DESC");
        SQLKEYWORDS.add("AND");
        SQLKEYWORDS.add("OR");
        SQLKEYWORDS.add("NOT");
        SQLKEYWORDS.add("NULL");
        SQLKEYWORDS.add("LIKE");
        SQLKEYWORDS.add("BETWEEN");
        SQLKEYWORDS.add("ANY");
        SQLKEYWORDS.add("SOME");
        SQLKEYWORDS.add("EXISTS");
    }

    public static String nvl(Object obj, String def) {
        if (obj == null) {
            return def;
        }
        return obj.toString();
    }

    public static String nvl(String obj) {
        return Misc.nvl(obj, "");
    }

    public static <T> T nvl(T obj, T def) {
        if (obj == null) {
            return def;
        }
        return obj;
    }

    public static String addSlashesString(String str) {
        if (str == null) {
            return str;
        }
        String newStr = "";
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    newStr = String.valueOf(newStr) + "\\n";
                    break;
                }
                case '\r': {
                    newStr = String.valueOf(newStr) + "\\r";
                    break;
                }
                case '\t': {
                    newStr = String.valueOf(newStr) + "\\t";
                    break;
                }
                case '\\': {
                    newStr = String.valueOf(newStr) + "\\\\";
                    break;
                }
                default: {
                    newStr = String.valueOf(newStr) + c;
                }
            }
            ++i;
        }
        return newStr;
    }

    public static String removeSlashesString(String str) {
        if (str == null) {
            return str;
        }
        String newStr = "";
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\\' && str.length() > i + 1) {
                char c2 = str.charAt(++i);
                switch (c2) {
                    case 'n': {
                        newStr = String.valueOf(newStr) + "\n";
                        break;
                    }
                    case 'r': {
                        newStr = String.valueOf(newStr) + "\r";
                        break;
                    }
                    case 't': {
                        newStr = String.valueOf(newStr) + "\t";
                        break;
                    }
                    case '\\': {
                        newStr = String.valueOf(newStr) + "\\";
                        break;
                    }
                    default: {
                        newStr = String.valueOf(newStr) + c;
                        newStr = String.valueOf(newStr) + c2;
                        break;
                    }
                }
            } else {
                newStr = String.valueOf(newStr) + c;
            }
            ++i;
        }
        return newStr;
    }

    public static int indexOf(String[] array, String key) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equalsIgnoreCase(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String nullValue(String value) {
        if (value != null && value.trim().isEmpty()) {
            return null;
        }
        return value;
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static boolean isNullOrEmpty(Collection<?> value) {
        return value == null || value.isEmpty();
    }

    public static <T> boolean isNullOrEmpty(T[] value) {
        return value == null || value.length == 0;
    }

    public static String nullIfEmpty(String value) {
        return value != null && value.isEmpty() ? null : value;
    }

    public static String strReplace(String s1, String s2, String s3) {
        String string = "";
        if (s2 == null || s3 == null || Misc.isNullOrEmpty(s2)) {
            return s3;
        }
        int pos_i = 0;
        int pos_f = 0;
        int len = s2.length();
        while ((pos_f = s3.indexOf(s2, pos_i)) >= 0) {
            string = String.valueOf(string) + s3.substring(pos_i, pos_f) + s1;
            pos_f = pos_i = pos_f + len;
        }
        return String.valueOf(string) + s3.substring(pos_i);
    }

    public static String getExpressionText(JRExpression exp) {
        if (exp == null || exp.getText() == null) {
            return "";
        }
        return exp.getText();
    }

    public static boolean compare(String a, String b, boolean caseSensitive) {
        if (caseSensitive) {
            return a.equals(b);
        }
        return a.equalsIgnoreCase(b);
    }

    public static String getBase(String resid) {
        if (resid.indexOf(".") > 0) {
            return resid.substring(0, resid.indexOf("."));
        }
        return resid;
    }

    public static String extract(String expr, String start, String end) {
        int sindx = expr.indexOf(start) + start.length();
        return expr.substring(sindx, expr.indexOf(end, sindx));
    }

    public static <K extends Comparable<K>, V extends Comparable<V>> LinkedHashMap<K, V> sortByValues(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return ((Comparable)a.getValue()).compareTo((Comparable)b.getValue());
            }
        });
        LinkedHashMap<Comparable, Comparable> sortedMap = new LinkedHashMap<Comparable, Comparable>();
        for (Map.Entry entry : entries) {
            sortedMap.put((Comparable)entry.getKey(), (Comparable)entry.getValue());
        }
        return sortedMap;
    }

    public static String quote(String value, String q, boolean onlyException) {
        if (onlyException) {
            boolean useQuote = false;
            char[] cArray = value.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' || Character.isUpperCase(c)) {
                    useQuote = true;
                    break;
                }
                ++n2;
            }
            if (!useQuote && SQLKEYWORDS.contains(value.toUpperCase())) {
                useQuote = true;
            }
            if (!useQuote) {
                return value;
            }
        }
        String str = String.valueOf(q) + value;
        if (q.equals("[")) {
            q = "]";
        }
        return String.valueOf(str) + q;
    }
}

