/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class SecureStorageUtils {
    private SecureStorageUtils() {
    }

    public static ISecurePreferences getDefaultSecurePreferences() {
        return SecurePreferencesFactory.getDefault();
    }

    public static ISecurePreferences getDefaultSecurePreferencesNode(String pathName) {
        return SecureStorageUtils.getSecurePreferencesNode(pathName, SecureStorageUtils.getDefaultSecurePreferences(), false);
    }

    public static ISecurePreferences getDefaultSecurePreferencesNode(String pathName, boolean createIfMissing) {
        return SecureStorageUtils.getSecurePreferencesNode(pathName, SecureStorageUtils.getDefaultSecurePreferences(), createIfMissing);
    }

    public static ISecurePreferences getSecurePreferencesNode(String pathName, ISecurePreferences preferences) {
        return SecureStorageUtils.getSecurePreferencesNode(pathName, preferences, false);
    }

    public static ISecurePreferences getSecurePreferencesNode(String pathName, ISecurePreferences preferences, boolean createIfMissing) {
        Assert.isNotNull((Object)pathName);
        Assert.isNotNull((Object)preferences);
        if (preferences.nodeExists(pathName) || createIfMissing) {
            return preferences.node(pathName);
        }
        return null;
    }

    public static void saveToDefaultSecurePreferences(String pathName, String key, String value) throws StorageException {
        ISecurePreferences prefNode = SecureStorageUtils.getDefaultSecurePreferencesNode(pathName, true);
        prefNode.put(key, value, true);
    }

    public static String readFromDefaultSecurePreferences(String pathName, String key, String defaultValue) throws StorageException {
        ISecurePreferences prefNode = SecureStorageUtils.getDefaultSecurePreferencesNode(pathName);
        if (prefNode != null) {
            return prefNode.get(key, defaultValue);
        }
        return null;
    }

    public static String readFromDefaultSecurePreferences(String pathName, String key) throws StorageException {
        return SecureStorageUtils.readFromDefaultSecurePreferences(pathName, key, null);
    }
}

