/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.atn;

import java.util.Arrays;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.atn.LexerAction;
import org.antlr.v4.runtime.atn.LexerIndexedCustomAction;
import org.antlr.v4.runtime.misc.MurmurHash;

public class LexerActionExecutor {
    private final LexerAction[] lexerActions;
    private final int hashCode;

    public LexerActionExecutor(LexerAction[] lexerActions) {
        this.lexerActions = lexerActions;
        int hash = MurmurHash.initialize();
        LexerAction[] lexerActionArray = lexerActions;
        int n = lexerActions.length;
        int n2 = 0;
        while (n2 < n) {
            LexerAction lexerAction = lexerActionArray[n2];
            hash = MurmurHash.update(hash, lexerAction);
            ++n2;
        }
        this.hashCode = MurmurHash.finish(hash, lexerActions.length);
    }

    public static LexerActionExecutor append(LexerActionExecutor lexerActionExecutor, LexerAction lexerAction) {
        if (lexerActionExecutor == null) {
            return new LexerActionExecutor(new LexerAction[]{lexerAction});
        }
        LexerAction[] lexerActions = Arrays.copyOf(lexerActionExecutor.lexerActions, lexerActionExecutor.lexerActions.length + 1);
        lexerActions[lexerActions.length - 1] = lexerAction;
        return new LexerActionExecutor(lexerActions);
    }

    public LexerActionExecutor fixOffsetBeforeMatch(int offset) {
        LexerAction[] updatedLexerActions = null;
        int i = 0;
        while (i < this.lexerActions.length) {
            if (this.lexerActions[i].isPositionDependent() && !(this.lexerActions[i] instanceof LexerIndexedCustomAction)) {
                if (updatedLexerActions == null) {
                    updatedLexerActions = (LexerAction[])this.lexerActions.clone();
                }
                updatedLexerActions[i] = new LexerIndexedCustomAction(offset, this.lexerActions[i]);
            }
            ++i;
        }
        if (updatedLexerActions == null) {
            return this;
        }
        return new LexerActionExecutor(updatedLexerActions);
    }

    public LexerAction[] getLexerActions() {
        return this.lexerActions;
    }

    public void execute(Lexer lexer, CharStream input, int startIndex) {
        boolean requiresSeek = false;
        int stopIndex = input.index();
        try {
            LexerAction[] lexerActionArray = this.lexerActions;
            int n = this.lexerActions.length;
            int n2 = 0;
            while (n2 < n) {
                LexerAction lexerAction = lexerActionArray[n2];
                if (lexerAction instanceof LexerIndexedCustomAction) {
                    int offset = ((LexerIndexedCustomAction)lexerAction).getOffset();
                    input.seek(startIndex + offset);
                    lexerAction = ((LexerIndexedCustomAction)lexerAction).getAction();
                    requiresSeek = startIndex + offset != stopIndex;
                } else if (lexerAction.isPositionDependent()) {
                    input.seek(stopIndex);
                    requiresSeek = false;
                }
                lexerAction.execute(lexer);
                ++n2;
            }
        }
        finally {
            if (requiresSeek) {
                input.seek(stopIndex);
            }
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LexerActionExecutor)) {
            return false;
        }
        LexerActionExecutor other = (LexerActionExecutor)obj;
        return this.hashCode == other.hashCode && Arrays.equals(this.lexerActions, other.lexerActions);
    }
}

