/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.antlr.v4.runtime.misc.AbstractEqualityComparator;
import org.antlr.v4.runtime.misc.MurmurHash;
import org.antlr.v4.runtime.misc.ObjectEqualityComparator;

public class Array2DHashSet<T>
implements Set<T> {
    public static final int INITAL_CAPACITY = 16;
    public static final int INITAL_BUCKET_CAPACITY = 8;
    public static final double LOAD_FACTOR = 0.75;
    protected final AbstractEqualityComparator<? super T> comparator;
    protected T[][] buckets;
    protected int n = 0;
    protected int threshold = (int)Math.floor(12.0);
    protected int currentPrime = 1;
    protected int initialBucketCapacity = 8;

    public Array2DHashSet() {
        this(null, 16, 8);
    }

    public Array2DHashSet(AbstractEqualityComparator<? super T> comparator) {
        this(comparator, 16, 8);
    }

    public Array2DHashSet(AbstractEqualityComparator<? super T> comparator, int initialCapacity, int initialBucketCapacity) {
        if (comparator == null) {
            comparator = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator = comparator;
        this.buckets = this.createBuckets(initialCapacity);
        this.initialBucketCapacity = initialBucketCapacity;
    }

    public final T getOrAdd(T o) {
        if (this.n > this.threshold) {
            this.expand();
        }
        return this.getOrAddImpl(o);
    }

    protected T getOrAddImpl(T o) {
        int b = this.getBucket(o);
        T[] bucket = this.buckets[b];
        if (bucket == null) {
            bucket = this.createBucket(this.initialBucketCapacity);
            bucket[0] = o;
            this.buckets[b] = bucket;
            ++this.n;
            return o;
        }
        int i = 0;
        while (i < bucket.length) {
            T existing = bucket[i];
            if (existing == null) {
                bucket[i] = o;
                ++this.n;
                return o;
            }
            if (this.comparator.equals(existing, o)) {
                return existing;
            }
            ++i;
        }
        int oldLength = bucket.length;
        bucket = Arrays.copyOf(bucket, bucket.length * 2);
        this.buckets[b] = bucket;
        bucket[oldLength] = o;
        ++this.n;
        return o;
    }

    public T get(T o) {
        if (o == null) {
            return o;
        }
        int b = this.getBucket(o);
        T[] bucket = this.buckets[b];
        if (bucket == null) {
            return null;
        }
        T[] TArray = bucket;
        int n = bucket.length;
        int n2 = 0;
        while (n2 < n) {
            T e = TArray[n2];
            if (e == null) {
                return null;
            }
            if (this.comparator.equals(e, o)) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    protected final int getBucket(T o) {
        int hash = this.comparator.hashCode(o);
        int b = hash & this.buckets.length - 1;
        return b;
    }

    @Override
    public int hashCode() {
        int hash = MurmurHash.initialize();
        T[][] TArray = this.buckets;
        int n = this.buckets.length;
        int n2 = 0;
        while (n2 < n) {
            T[] bucket = TArray[n2];
            if (bucket != null) {
                T[] TArray2 = bucket;
                int n3 = bucket.length;
                int n4 = 0;
                while (n4 < n3) {
                    T o = TArray2[n4];
                    if (o == null) break;
                    hash = MurmurHash.update(hash, this.comparator.hashCode(o));
                    ++n4;
                }
            }
            ++n2;
        }
        hash = MurmurHash.finish(hash, this.size());
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Array2DHashSet)) {
            return false;
        }
        Array2DHashSet other = (Array2DHashSet)o;
        if (other.size() != this.size()) {
            return false;
        }
        boolean same = this.containsAll(other);
        return same;
    }

    protected void expand() {
        T[][] old = this.buckets;
        this.currentPrime += 4;
        int newCapacity = this.buckets.length * 2;
        T[][] newTable = this.createBuckets(newCapacity);
        int[] newBucketLengths = new int[newTable.length];
        this.buckets = newTable;
        this.threshold = (int)((double)newCapacity * 0.75);
        int oldSize = this.size();
        T[][] TArray = old;
        int n = old.length;
        int n2 = 0;
        while (n2 < n) {
            T[] bucket = TArray[n2];
            if (bucket != null) {
                T[] TArray2 = bucket;
                int n3 = bucket.length;
                int n4 = 0;
                while (n4 < n3) {
                    T[] newBucket;
                    T o = TArray2[n4];
                    if (o == null) break;
                    int b = this.getBucket(o);
                    int bucketLength = newBucketLengths[b];
                    if (bucketLength == 0) {
                        newBucket = this.createBucket(this.initialBucketCapacity);
                        newTable[b] = newBucket;
                    } else {
                        newBucket = newTable[b];
                        if (bucketLength == newBucket.length) {
                            newBucket = Arrays.copyOf(newBucket, newBucket.length * 2);
                            newTable[b] = newBucket;
                        }
                    }
                    newBucket[bucketLength] = o;
                    int n5 = b;
                    newBucketLengths[n5] = newBucketLengths[n5] + 1;
                    ++n4;
                }
            }
            ++n2;
        }
        assert (this.n == oldSize);
    }

    @Override
    public final boolean add(T t) {
        T existing = this.getOrAdd(t);
        return existing == t;
    }

    @Override
    public final int size() {
        return this.n;
    }

    @Override
    public final boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public final boolean contains(Object o) {
        return this.containsFast(this.asElementType(o));
    }

    public boolean containsFast(T obj) {
        if (obj == null) {
            return false;
        }
        return this.get(obj) != null;
    }

    @Override
    public Iterator<T> iterator() {
        return new SetIterator(this.toArray());
    }

    @Override
    public T[] toArray() {
        T[] a = this.createBucket(this.size());
        int i = 0;
        T[][] TArray = this.buckets;
        int n = this.buckets.length;
        int n2 = 0;
        while (n2 < n) {
            T[] bucket = TArray[n2];
            if (bucket != null) {
                T[] TArray2 = bucket;
                int n3 = bucket.length;
                int n4 = 0;
                while (n4 < n3) {
                    T o = TArray2[n4];
                    if (o == null) break;
                    a[i++] = o;
                    ++n4;
                }
            }
            ++n2;
        }
        return a;
    }

    @Override
    public <U> U[] toArray(U[] a) {
        if (a.length < this.size()) {
            a = Arrays.copyOf(a, this.size());
        }
        int i = 0;
        T[][] TArray = this.buckets;
        int n = this.buckets.length;
        int n2 = 0;
        while (n2 < n) {
            T[] bucket = TArray[n2];
            if (bucket != null) {
                T[] TArray2 = bucket;
                int n3 = bucket.length;
                int n4 = 0;
                while (n4 < n3) {
                    T o = TArray2[n4];
                    if (o == null) break;
                    T targetElement = o;
                    a[i++] = targetElement;
                    ++n4;
                }
            }
            ++n2;
        }
        return a;
    }

    @Override
    public final boolean remove(Object o) {
        return this.removeFast(this.asElementType(o));
    }

    public boolean removeFast(T obj) {
        if (obj == null) {
            return false;
        }
        int b = this.getBucket(obj);
        T[] bucket = this.buckets[b];
        if (bucket == null) {
            return false;
        }
        int i = 0;
        while (i < bucket.length) {
            T e = bucket[i];
            if (e == null) {
                return false;
            }
            if (this.comparator.equals(e, obj)) {
                System.arraycopy(bucket, i + 1, bucket, i, bucket.length - i - 1);
                bucket[bucket.length - 1] = null;
                --this.n;
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof Array2DHashSet) {
            Array2DHashSet s = (Array2DHashSet)collection;
            T[][] TArray = s.buckets;
            int n = s.buckets.length;
            int n2 = 0;
            while (n2 < n) {
                T[] bucket = TArray[n2];
                if (bucket != null) {
                    T[] TArray2 = bucket;
                    int n3 = bucket.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        T o = TArray2[n4];
                        if (o == null) break;
                        if (!this.containsFast(this.asElementType(o))) {
                            return false;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        } else {
            for (Object o : collection) {
                if (this.containsFast(this.asElementType(o))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T o : c) {
            T existing = this.getOrAdd(o);
            if (existing == o) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        int newsize = 0;
        T[][] TArray = this.buckets;
        int n = this.buckets.length;
        int n2 = 0;
        while (n2 < n) {
            T[] bucket = TArray[n2];
            if (bucket != null) {
                int i = 0;
                int j = 0;
                while (i < bucket.length) {
                    if (bucket[i] == null) break;
                    if (c.contains(bucket[i])) {
                        if (i != j) {
                            bucket[j] = bucket[i];
                        }
                        ++j;
                        ++newsize;
                    }
                    ++i;
                }
                newsize += j;
                while (j < i) {
                    bucket[j] = null;
                    ++j;
                }
            }
            ++n2;
        }
        boolean changed = newsize != this.n;
        this.n = newsize;
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.removeFast(this.asElementType(o));
        }
        return changed;
    }

    @Override
    public void clear() {
        this.buckets = this.createBuckets(16);
        this.n = 0;
        this.threshold = (int)Math.floor(12.0);
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        boolean first = true;
        T[][] TArray = this.buckets;
        int n = this.buckets.length;
        int n2 = 0;
        while (n2 < n) {
            T[] bucket = TArray[n2];
            if (bucket != null) {
                T[] TArray2 = bucket;
                int n3 = bucket.length;
                int n4 = 0;
                while (n4 < n3) {
                    T o = TArray2[n4];
                    if (o == null) break;
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(o.toString());
                    ++n4;
                }
            }
            ++n2;
        }
        buf.append('}');
        return buf.toString();
    }

    public String toTableString() {
        StringBuilder buf = new StringBuilder();
        T[][] TArray = this.buckets;
        int n = this.buckets.length;
        int n2 = 0;
        while (n2 < n) {
            T[] bucket = TArray[n2];
            if (bucket == null) {
                buf.append("null\n");
            } else {
                buf.append('[');
                boolean first = true;
                T[] TArray2 = bucket;
                int n3 = bucket.length;
                int n4 = 0;
                while (n4 < n3) {
                    T o = TArray2[n4];
                    if (first) {
                        first = false;
                    } else {
                        buf.append(" ");
                    }
                    if (o == null) {
                        buf.append("_");
                    } else {
                        buf.append(o.toString());
                    }
                    ++n4;
                }
                buf.append("]\n");
            }
            ++n2;
        }
        return buf.toString();
    }

    protected T asElementType(Object o) {
        return (T)o;
    }

    protected T[][] createBuckets(int capacity) {
        return new Object[capacity][];
    }

    protected T[] createBucket(int capacity) {
        return new Object[capacity];
    }

    protected class SetIterator
    implements Iterator<T> {
        final T[] data;
        int nextIndex = 0;
        boolean removed = true;

        public SetIterator(T[] data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.data.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removed = false;
            return this.data[this.nextIndex++];
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            Array2DHashSet.this.remove(this.data[this.nextIndex - 1]);
            this.removed = true;
        }
    }
}

