/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.centerdevice.javafxsvg;

import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import de.codecentric.centerdevice.javafxsvg.BufferedImageTranscoder;
import de.codecentric.centerdevice.javafxsvg.FixedPixelDensityImageFrame;
import de.codecentric.centerdevice.javafxsvg.ScreenHelper;
import de.codecentric.centerdevice.javafxsvg.SvgDescriptor;
import de.codecentric.centerdevice.javafxsvg.dimension.Dimension;
import de.codecentric.centerdevice.javafxsvg.dimension.DimensionProvider;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javafx.stage.Screen;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;

public class SvgImageLoader
extends ImageLoaderImpl {
    private static final int BYTES_PER_PIXEL = 4;
    private final InputStream input;
    private float maxPixelScale = 0.0f;
    private final DimensionProvider dimensionProvider;

    protected SvgImageLoader(InputStream input, DimensionProvider dimensionProvider) {
        super((ImageFormatDescription)SvgDescriptor.getInstance());
        if (input == null) {
            throw new IllegalArgumentException("input == null!");
        }
        this.input = input;
        this.dimensionProvider = dimensionProvider;
    }

    public ImageFrame load(int imageIndex, int width, int height, boolean preserveAspectRatio, boolean smooth) throws IOException {
        if (imageIndex != 0) {
            return null;
        }
        Document document = this.createDocument();
        Dimension fallbackDimension = width <= 0 || height <= 0 ? this.dimensionProvider.getDimension(document) : null;
        float imageWidth = width > 0 ? (float)width : fallbackDimension.getWidth();
        float imageHeight = height > 0 ? (float)height : fallbackDimension.getHeight();
        try {
            return this.createImageFrame(document, imageWidth, imageHeight, this.getPixelScale());
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    private Document createDocument() throws IOException {
        return new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName()).createDocument(null, this.input);
    }

    public float getPixelScale() {
        if (this.maxPixelScale == 0.0f) {
            this.maxPixelScale = this.calculateMaxRenderScale();
        }
        return this.maxPixelScale;
    }

    public float calculateMaxRenderScale() {
        float maxRenderScale = 0.0f;
        ScreenHelper.ScreenAccessor accessor = ScreenHelper.getScreenAccessor();
        for (Screen screen : Screen.getScreens()) {
            maxRenderScale = Math.max(maxRenderScale, accessor.getRenderScale(screen));
        }
        return maxRenderScale;
    }

    private ImageFrame createImageFrame(Document document, float width, float height, float pixelScale) throws TranscoderException {
        BufferedImage bufferedImage = this.getTranscodedImage(document, width * pixelScale, height * pixelScale);
        ByteBuffer imageData = this.getImageData(bufferedImage);
        return new FixedPixelDensityImageFrame(ImageStorage.ImageType.RGBA, imageData, bufferedImage.getWidth(), bufferedImage.getHeight(), this.getStride(bufferedImage), null, pixelScale, null);
    }

    private BufferedImage getTranscodedImage(Document document, float width, float height) throws TranscoderException {
        BufferedImageTranscoder trans = new BufferedImageTranscoder(2);
        trans.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, Float.valueOf(width));
        trans.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, Float.valueOf(height));
        trans.transcode(new TranscoderInput(document), null);
        return trans.getBufferedImage();
    }

    private int getStride(BufferedImage bufferedImage) {
        return bufferedImage.getWidth() * 4;
    }

    private ByteBuffer getImageData(BufferedImage bufferedImage) {
        int[] rgb = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
        byte[] imageData = new byte[this.getStride(bufferedImage) * bufferedImage.getHeight()];
        this.copyColorToBytes(rgb, imageData);
        return ByteBuffer.wrap(imageData);
    }

    private void copyColorToBytes(int[] rgb, byte[] imageData) {
        if (rgb.length * 4 != imageData.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        int i = 0;
        while (i < rgb.length) {
            byte[] bytes = byteBuffer.putInt(rgb[i]).array();
            int dataOffset = 4 * i;
            imageData[dataOffset] = bytes[1];
            imageData[dataOffset + 1] = bytes[2];
            imageData[dataOffset + 2] = bytes[3];
            imageData[dataOffset + 3] = bytes[0];
            byteBuffer.clear();
            ++i;
        }
    }

    public void dispose() {
    }
}

