/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public class AnnotationEntry
implements Node {
    private final int typeIndex;
    private final ConstantPool constantPool;
    private final boolean isRuntimeVisible;
    private List<ElementValuePair> elementValuePairs;

    public static AnnotationEntry read(DataInput input, ConstantPool constant_pool, boolean isRuntimeVisible) throws IOException {
        AnnotationEntry annotationEntry = new AnnotationEntry(input.readUnsignedShort(), constant_pool, isRuntimeVisible);
        int num_element_value_pairs = input.readUnsignedShort();
        annotationEntry.elementValuePairs = new ArrayList<ElementValuePair>();
        int i = 0;
        while (i < num_element_value_pairs) {
            annotationEntry.elementValuePairs.add(new ElementValuePair(input.readUnsignedShort(), ElementValue.readElementValue(input, constant_pool), constant_pool));
            ++i;
        }
        return annotationEntry;
    }

    public AnnotationEntry(int type_index, ConstantPool constant_pool, boolean isRuntimeVisible) {
        this.typeIndex = type_index;
        this.constantPool = constant_pool;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    @Override
    public void accept(Visitor v) {
        v.visitAnnotationEntry(this);
    }

    public String getAnnotationType() {
        ConstantUtf8 c = (ConstantUtf8)this.constantPool.getConstant(this.typeIndex, (byte)1);
        return c.getBytes();
    }

    public int getAnnotationTypeIndex() {
        return this.typeIndex;
    }

    public final int getNumElementValuePairs() {
        return this.elementValuePairs.size();
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.elementValuePairs.toArray(new ElementValuePair[this.elementValuePairs.size()]);
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.typeIndex);
        dos.writeShort(this.elementValuePairs.size());
        for (ElementValuePair envp : this.elementValuePairs) {
            envp.dump(dos);
        }
    }

    public void addElementNameValuePair(ElementValuePair elementNameValuePair) {
        this.elementValuePairs.add(elementNameValuePair);
    }

    public String toShortString() {
        StringBuilder result = new StringBuilder();
        result.append("@");
        result.append(this.getAnnotationType());
        ElementValuePair[] evPairs = this.getElementValuePairs();
        if (evPairs.length > 0) {
            result.append("(");
            ElementValuePair[] elementValuePairArray = evPairs;
            int n = evPairs.length;
            int n2 = 0;
            while (n2 < n) {
                ElementValuePair element = elementValuePairArray[n2];
                result.append(element.toShortString());
                ++n2;
            }
            result.append(")");
        }
        return result.toString();
    }

    public String toString() {
        return this.toShortString();
    }

    public static AnnotationEntry[] createAnnotationEntries(Attribute[] attrs) {
        ArrayList accumulatedAnnotations = new ArrayList(attrs.length);
        Attribute[] attributeArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof Annotations) {
                Annotations runtimeAnnotations = (Annotations)attribute;
                Collections.addAll(accumulatedAnnotations, runtimeAnnotations.getAnnotationEntries());
            }
            ++n2;
        }
        return accumulatedAnnotations.toArray(new AnnotationEntry[accumulatedAnnotations.size()]);
    }
}

