/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public abstract class Annotations
extends Attribute {
    private AnnotationEntry[] annotationTable;
    private final boolean isRuntimeVisible;

    Annotations(byte annotation_type, int name_index, int length, DataInput input, ConstantPool constant_pool, boolean isRuntimeVisible) throws IOException {
        this(annotation_type, name_index, length, (AnnotationEntry[])null, constant_pool, isRuntimeVisible);
        int annotation_table_length = input.readUnsignedShort();
        this.annotationTable = new AnnotationEntry[annotation_table_length];
        int i = 0;
        while (i < annotation_table_length) {
            this.annotationTable[i] = AnnotationEntry.read(input, constant_pool, isRuntimeVisible);
            ++i;
        }
    }

    public Annotations(byte annotationType, int nameIndex, int length, AnnotationEntry[] annotationTable, ConstantPool constantPool, boolean isRuntimeVisible) {
        super(annotationType, nameIndex, length, constantPool);
        this.annotationTable = annotationTable;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    @Override
    public void accept(Visitor v) {
        v.visitAnnotation(this);
    }

    public final void setAnnotationTable(AnnotationEntry[] annotationTable) {
        this.annotationTable = annotationTable;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        return this.annotationTable;
    }

    public final int getNumAnnotations() {
        if (this.annotationTable == null) {
            return 0;
        }
        return this.annotationTable.length;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    protected void writeAnnotations(DataOutputStream dos) throws IOException {
        if (this.annotationTable == null) {
            return;
        }
        dos.writeShort(this.annotationTable.length);
        AnnotationEntry[] annotationEntryArray = this.annotationTable;
        int n = this.annotationTable.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationEntry element = annotationEntryArray[n2];
            element.dump(dos);
            ++n2;
        }
    }
}

