/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;

public class BootstrapMethod
implements Cloneable {
    private int bootstrapMethodRef;
    private int[] bootstrapArguments;

    public BootstrapMethod(BootstrapMethod c) {
        this(c.getBootstrapMethodRef(), c.getBootstrapArguments());
    }

    BootstrapMethod(DataInput input) throws IOException {
        this(input.readUnsignedShort(), input.readUnsignedShort());
        int i = 0;
        while (i < this.bootstrapArguments.length) {
            this.bootstrapArguments[i] = input.readUnsignedShort();
            ++i;
        }
    }

    private BootstrapMethod(int bootstrap_method_ref, int num_bootstrap_arguments) {
        this(bootstrap_method_ref, new int[num_bootstrap_arguments]);
    }

    public BootstrapMethod(int bootstrapMethodRef, int[] bootstrapArguments) {
        this.bootstrapMethodRef = bootstrapMethodRef;
        this.bootstrapArguments = bootstrapArguments;
    }

    public int getBootstrapMethodRef() {
        return this.bootstrapMethodRef;
    }

    public void setBootstrapMethodRef(int bootstrapMethodRef) {
        this.bootstrapMethodRef = bootstrapMethodRef;
    }

    public int[] getBootstrapArguments() {
        return this.bootstrapArguments;
    }

    public int getNumBootstrapArguments() {
        return this.bootstrapArguments.length;
    }

    public void setBootstrapArguments(int[] bootstrapArguments) {
        this.bootstrapArguments = bootstrapArguments;
    }

    public final String toString() {
        return "BootstrapMethod(" + this.bootstrapMethodRef + ", " + this.bootstrapArguments.length + ", " + Arrays.toString(this.bootstrapArguments) + ")";
    }

    public final String toString(ConstantPool constantPool) {
        StringBuilder buf = new StringBuilder();
        String bootstrap_method_name = constantPool.constantToString(this.bootstrapMethodRef, (byte)15);
        buf.append(Utility.compactClassName(bootstrap_method_name, false));
        int num_bootstrap_arguments = this.bootstrapArguments.length;
        if (num_bootstrap_arguments > 0) {
            buf.append("\nMethod Arguments:");
            int i = 0;
            while (i < num_bootstrap_arguments) {
                buf.append("\n  ").append(i).append(": ");
                buf.append(constantPool.constantToString(constantPool.getConstant(this.bootstrapArguments[i])));
                ++i;
            }
        }
        return buf.toString();
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.bootstrapMethodRef);
        file.writeShort(this.bootstrapArguments.length);
        int[] nArray = this.bootstrapArguments;
        int n = this.bootstrapArguments.length;
        int n2 = 0;
        while (n2 < n) {
            int bootstrap_argument = nArray[n2];
            file.writeShort(bootstrap_argument);
            ++n2;
        }
    }

    public BootstrapMethod copy() {
        try {
            return (BootstrapMethod)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

