/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodType;
import org.apache.bcel.classfile.ConstantModule;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPackage;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public class ConstantPool
implements Cloneable,
Node {
    private Constant[] constantPool;

    public ConstantPool(Constant[] constantPool) {
        this.constantPool = constantPool;
    }

    public ConstantPool(DataInput input) throws IOException, ClassFormatException {
        int constant_pool_count = input.readUnsignedShort();
        this.constantPool = new Constant[constant_pool_count];
        int i = 1;
        while (i < constant_pool_count) {
            this.constantPool[i] = Constant.readConstant(input);
            byte tag = this.constantPool[i].getTag();
            if (tag == 6 || tag == 5) {
                ++i;
            }
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantPool(this);
    }

    public String constantToString(Constant c) throws ClassFormatException {
        byte tag = c.getTag();
        return switch (tag) {
            case 7 -> {
                int i = ((ConstantClass)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                yield Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
            }
            case 8 -> {
                int i = ((ConstantString)c).getStringIndex();
                c = this.getConstant(i, (byte)1);
                yield "\"" + ConstantPool.escape(((ConstantUtf8)c).getBytes()) + "\"";
            }
            case 1 -> ((ConstantUtf8)c).getBytes();
            case 6 -> String.valueOf(((ConstantDouble)c).getBytes());
            case 4 -> String.valueOf(((ConstantFloat)c).getBytes());
            case 5 -> String.valueOf(((ConstantLong)c).getBytes());
            case 3 -> String.valueOf(((ConstantInteger)c).getBytes());
            case 12 -> String.valueOf(this.constantToString(((ConstantNameAndType)c).getNameIndex(), (byte)1)) + " " + this.constantToString(((ConstantNameAndType)c).getSignatureIndex(), (byte)1);
            case 9, 10, 11 -> String.valueOf(this.constantToString(((ConstantCP)c).getClassIndex(), (byte)7)) + "." + this.constantToString(((ConstantCP)c).getNameAndTypeIndex(), (byte)12);
            case 15 -> {
                ConstantMethodHandle cmh = (ConstantMethodHandle)c;
                yield String.valueOf(Const.getMethodHandleName(cmh.getReferenceKind())) + " " + this.constantToString(cmh.getReferenceIndex(), this.getConstant(cmh.getReferenceIndex()).getTag());
            }
            case 16 -> {
                ConstantMethodType cmt = (ConstantMethodType)c;
                yield this.constantToString(cmt.getDescriptorIndex(), (byte)1);
            }
            case 18 -> {
                ConstantInvokeDynamic cid = (ConstantInvokeDynamic)c;
                yield String.valueOf(cid.getBootstrapMethodAttrIndex()) + ":" + this.constantToString(cid.getNameAndTypeIndex(), (byte)12);
            }
            case 19 -> {
                int i = ((ConstantModule)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                yield Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
            }
            case 20 -> {
                int i = ((ConstantPackage)c).getNameIndex();
                c = this.getConstant(i, (byte)1);
                yield Utility.compactClassName(((ConstantUtf8)c).getBytes(), false);
            }
            default -> throw new IllegalArgumentException("Unknown constant type " + tag);
        };
    }

    private static String escape(String str) {
        int len = str.length();
        StringBuilder buf = new StringBuilder(len + 5);
        char[] ch = str.toCharArray();
        int i = 0;
        while (i < len) {
            switch (ch[i]) {
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '\b': {
                    buf.append("\\b");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                default: {
                    buf.append(ch[i]);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public String constantToString(int index, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index, tag);
        return this.constantToString(c);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.constantPool.length);
        int i = 1;
        while (i < this.constantPool.length) {
            if (this.constantPool[i] != null) {
                this.constantPool[i].dump(file);
            }
            ++i;
        }
    }

    public Constant getConstant(int index) {
        if (index >= this.constantPool.length || index < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + index + ". Constant pool size is: " + this.constantPool.length);
        }
        return this.constantPool[index];
    }

    public Constant getConstant(int index, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index);
        if (c == null) {
            throw new ClassFormatException("Constant pool at index " + index + " is null.");
        }
        if (c.getTag() != tag) {
            throw new ClassFormatException("Expected class `" + Const.getConstantName(tag) + "' at index " + index + " and got " + c);
        }
        return c;
    }

    public Constant[] getConstantPool() {
        return this.constantPool;
    }

    public String getConstantString(int index, byte tag) throws ClassFormatException {
        Constant c = this.getConstant(index, tag);
        c = this.getConstant(switch (tag) {
            case 7 -> ((ConstantClass)c).getNameIndex();
            case 8 -> ((ConstantString)c).getStringIndex();
            case 19 -> ((ConstantModule)c).getNameIndex();
            case 20 -> ((ConstantPackage)c).getNameIndex();
            default -> throw new IllegalArgumentException("getConstantString called with illegal tag " + tag);
        }, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public int getLength() {
        return this.constantPool == null ? 0 : this.constantPool.length;
    }

    public void setConstant(int index, Constant constant) {
        this.constantPool[index] = constant;
    }

    public void setConstantPool(Constant[] constantPool) {
        this.constantPool = constantPool;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int i = 1;
        while (i < this.constantPool.length) {
            buf.append(i).append(")").append(this.constantPool[i]).append("\n");
            ++i;
        }
        return buf.toString();
    }

    public ConstantPool copy() {
        ConstantPool c = null;
        try {
            c = (ConstantPool)this.clone();
            c.constantPool = new Constant[this.constantPool.length];
            int i = 1;
            while (i < this.constantPool.length) {
                if (this.constantPool[i] != null) {
                    c.constantPool[i] = this.constantPool[i].copy();
                }
                ++i;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return c;
    }
}

