/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ExceptionTable
extends Attribute {
    private int[] exceptionIndexTable;

    public ExceptionTable(ExceptionTable c) {
        this(c.getNameIndex(), c.getLength(), c.getExceptionIndexTable(), c.getConstantPool());
    }

    public ExceptionTable(int name_index, int length, int[] exceptionIndexTable, ConstantPool constant_pool) {
        super((byte)3, name_index, length, constant_pool);
        this.exceptionIndexTable = exceptionIndexTable != null ? exceptionIndexTable : new int[]{};
    }

    ExceptionTable(int nameIndex, int length, DataInput input, ConstantPool constantPool) throws IOException {
        this(nameIndex, length, (int[])null, constantPool);
        int number_of_exceptions = input.readUnsignedShort();
        this.exceptionIndexTable = new int[number_of_exceptions];
        int i = 0;
        while (i < number_of_exceptions) {
            this.exceptionIndexTable[i] = input.readUnsignedShort();
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitExceptionTable(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.exceptionIndexTable.length);
        int[] nArray = this.exceptionIndexTable;
        int n = this.exceptionIndexTable.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            file.writeShort(index);
            ++n2;
        }
    }

    public int[] getExceptionIndexTable() {
        return this.exceptionIndexTable;
    }

    public int getNumberOfExceptions() {
        return this.exceptionIndexTable == null ? 0 : this.exceptionIndexTable.length;
    }

    public String[] getExceptionNames() {
        String[] names = new String[this.exceptionIndexTable.length];
        int i = 0;
        while (i < this.exceptionIndexTable.length) {
            names[i] = super.getConstantPool().getConstantString(this.exceptionIndexTable[i], (byte)7).replace('/', '.');
            ++i;
        }
        return names;
    }

    public void setExceptionIndexTable(int[] exceptionIndexTable) {
        this.exceptionIndexTable = exceptionIndexTable != null ? exceptionIndexTable : new int[]{};
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Exceptions: ");
        int i = 0;
        while (i < this.exceptionIndexTable.length) {
            String str = super.getConstantPool().getConstantString(this.exceptionIndexTable[i], (byte)7);
            buf.append(Utility.compactClassName(str, false));
            if (i < this.exceptionIndexTable.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        ExceptionTable c = (ExceptionTable)this.clone();
        if (this.exceptionIndexTable != null) {
            c.exceptionIndexTable = new int[this.exceptionIndexTable.length];
            System.arraycopy(this.exceptionIndexTable, 0, c.exceptionIndexTable, 0, this.exceptionIndexTable.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

