/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.Visitor;

public final class InnerClasses
extends Attribute {
    private InnerClass[] innerClasses;

    public InnerClasses(InnerClasses c) {
        this(c.getNameIndex(), c.getLength(), c.getInnerClasses(), c.getConstantPool());
    }

    public InnerClasses(int name_index, int length, InnerClass[] innerClasses, ConstantPool constant_pool) {
        super((byte)6, name_index, length, constant_pool);
        this.innerClasses = innerClasses != null ? innerClasses : new InnerClass[]{};
    }

    InnerClasses(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (InnerClass[])null, constant_pool);
        int number_of_classes = input.readUnsignedShort();
        this.innerClasses = new InnerClass[number_of_classes];
        int i = 0;
        while (i < number_of_classes) {
            this.innerClasses[i] = new InnerClass(input);
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitInnerClasses(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.innerClasses.length);
        InnerClass[] innerClassArray = this.innerClasses;
        int n = this.innerClasses.length;
        int n2 = 0;
        while (n2 < n) {
            InnerClass inner_class = innerClassArray[n2];
            inner_class.dump(file);
            ++n2;
        }
    }

    public InnerClass[] getInnerClasses() {
        return this.innerClasses;
    }

    public void setInnerClasses(InnerClass[] innerClasses) {
        this.innerClasses = innerClasses != null ? innerClasses : new InnerClass[]{};
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("InnerClasses(");
        buf.append(this.innerClasses.length);
        buf.append("):\n");
        InnerClass[] innerClassArray = this.innerClasses;
        int n = this.innerClasses.length;
        int n2 = 0;
        while (n2 < n) {
            InnerClass inner_class = innerClassArray[n2];
            buf.append(inner_class.toString(super.getConstantPool())).append("\n");
            ++n2;
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        InnerClasses c = (InnerClasses)this.clone();
        c.innerClasses = new InnerClass[this.innerClasses.length];
        int i = 0;
        while (i < this.innerClasses.length) {
            c.innerClasses[i] = this.innerClasses[i].copy();
            ++i;
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

