/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELComparator;
import org.apache.bcel.util.ClassQueue;
import org.apache.bcel.util.Repository;
import org.apache.bcel.util.SyntheticRepository;

public class JavaClass
extends AccessFlags
implements Cloneable,
Node,
Comparable<JavaClass> {
    private String fileName;
    private String packageName;
    private String sourceFileName = "<Unknown>";
    private int classNameIndex;
    private int superclassNameIndex;
    private String className;
    private String superclassName;
    private int major;
    private int minor;
    private ConstantPool constantPool;
    private int[] interfaces;
    private String[] interfaceNames;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private AnnotationEntry[] annotations;
    private byte source = 1;
    private boolean isAnonymous = false;
    private boolean isNested = false;
    private boolean computedNestedTypeStatus = false;
    public static final byte HEAP = 1;
    public static final byte FILE = 2;
    public static final byte ZIP = 3;
    private static final boolean debug = Boolean.getBoolean("JavaClass.debug");
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            JavaClass THIS = (JavaClass)o1;
            JavaClass THAT = (JavaClass)o2;
            return Objects.equals(THIS.getClassName(), THAT.getClassName());
        }

        @Override
        public int hashCode(Object o) {
            JavaClass THIS = (JavaClass)o;
            return THIS.getClassName().hashCode();
        }
    };
    private transient Repository repository = SyntheticRepository.getInstance();

    public JavaClass(int classNameIndex, int superclassNameIndex, String fileName, int major, int minor, int access_flags, ConstantPool constantPool, int[] interfaces, Field[] fields, Method[] methods, Attribute[] attributes, byte source) {
        super(access_flags);
        if (interfaces == null) {
            interfaces = new int[]{};
        }
        if (attributes == null) {
            attributes = new Attribute[]{};
        }
        if (fields == null) {
            fields = new Field[]{};
        }
        if (methods == null) {
            methods = new Method[]{};
        }
        this.classNameIndex = classNameIndex;
        this.superclassNameIndex = superclassNameIndex;
        this.fileName = fileName;
        this.major = major;
        this.minor = minor;
        this.constantPool = constantPool;
        this.interfaces = interfaces;
        this.fields = fields;
        this.methods = methods;
        this.attributes = attributes;
        this.source = source;
        Attribute[] attributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof SourceFile) {
                this.sourceFileName = ((SourceFile)attribute).getSourceFileName();
                break;
            }
            ++n2;
        }
        this.className = constantPool.getConstantString(classNameIndex, (byte)7);
        this.className = Utility.compactClassName(this.className, false);
        int index = this.className.lastIndexOf(46);
        this.packageName = index < 0 ? "" : this.className.substring(0, index);
        if (superclassNameIndex > 0) {
            this.superclassName = constantPool.getConstantString(superclassNameIndex, (byte)7);
            this.superclassName = Utility.compactClassName(this.superclassName, false);
        } else {
            this.superclassName = "java.lang.Object";
        }
        this.interfaceNames = new String[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            String str = constantPool.getConstantString(interfaces[i], (byte)7);
            this.interfaceNames[i] = Utility.compactClassName(str, false);
            ++i;
        }
    }

    public JavaClass(int classNameIndex, int superclassNameIndex, String fileName, int major, int minor, int access_flags, ConstantPool constantPool, int[] interfaces, Field[] fields, Method[] methods, Attribute[] attributes) {
        this(classNameIndex, superclassNameIndex, fileName, major, minor, access_flags, constantPool, interfaces, fields, methods, attributes, 1);
    }

    @Override
    public void accept(Visitor v) {
        v.visitJavaClass(this);
    }

    static void Debug(String str) {
        if (debug) {
            System.out.println(str);
        }
    }

    public void dump(File file) throws IOException {
        File dir;
        String parent = file.getParent();
        if (parent != null && !(dir = new File(parent)).mkdirs() && !dir.isDirectory()) {
            throw new IOException("Could not create the directory " + dir);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
            this.dump(dos);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void dump(String _file_name) throws IOException {
        this.dump(new File(_file_name));
    }

    public byte[] getBytes() {
        ByteArrayOutputStream s;
        block11: {
            s = new ByteArrayOutputStream();
            DataOutputStream ds = new DataOutputStream(s);
            try {
                try {
                    this.dump(ds);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        ds.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    ds.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
            try {
                ds.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return s.toByteArray();
    }

    public void dump(OutputStream file) throws IOException {
        this.dump(new DataOutputStream(file));
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeInt(-889275714);
        file.writeShort(this.minor);
        file.writeShort(this.major);
        this.constantPool.dump(file);
        file.writeShort(super.getAccessFlags());
        file.writeShort(this.classNameIndex);
        file.writeShort(this.superclassNameIndex);
        file.writeShort(this.interfaces.length);
        Object[] objectArray = this.interfaces;
        int n = this.interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            int interface1 = objectArray[n2];
            file.writeShort(interface1);
            ++n2;
        }
        file.writeShort(this.fields.length);
        objectArray = this.fields;
        n = this.fields.length;
        n2 = 0;
        while (n2 < n) {
            int field = objectArray[n2];
            field.dump(file);
            ++n2;
        }
        file.writeShort(this.methods.length);
        objectArray = this.methods;
        n = this.methods.length;
        n2 = 0;
        while (n2 < n) {
            int method = objectArray[n2];
            method.dump(file);
            ++n2;
        }
        if (this.attributes != null) {
            file.writeShort(this.attributes.length);
            objectArray = this.attributes;
            n = this.attributes.length;
            n2 = 0;
            while (n2 < n) {
                int attribute = objectArray[n2];
                attribute.dump(file);
                ++n2;
            }
        } else {
            file.writeShort(0);
        }
        file.flush();
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        if (this.annotations == null) {
            this.annotations = AnnotationEntry.createAnnotationEntries(this.getAttributes());
        }
        return this.annotations;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getClassNameIndex() {
        return this.classNameIndex;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public int[] getInterfaceIndices() {
        return this.interfaces;
    }

    public int getMajor() {
        return this.major;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public Method getMethod(java.lang.reflect.Method m) {
        Method[] methodArray = this.methods;
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (m.getName().equals(method.getName()) && m.getModifiers() == method.getModifiers() && Type.getSignature(m).equals(method.getSignature())) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getSuperclassName() {
        return this.superclassName;
    }

    public int getSuperclassNameIndex() {
        return this.superclassNameIndex;
    }

    public void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setClassNameIndex(int classNameIndex) {
        this.classNameIndex = classNameIndex;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void setFields(Field[] fields) {
        this.fields = fields;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setInterfaceNames(String[] interfaceNames) {
        this.interfaceNames = interfaceNames;
    }

    public void setInterfaces(int[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setMethods(Method[] methods) {
        this.methods = methods;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public void setSuperclassName(String superclassName) {
        this.superclassName = superclassName;
    }

    public void setSuperclassNameIndex(int superclassNameIndex) {
        this.superclassNameIndex = superclassNameIndex;
    }

    public String toString() {
        Node[] nodeArray;
        AnnotationEntry[] annotations;
        int n;
        String access = Utility.accessToString(super.getAccessFlags(), true);
        access = access.isEmpty() ? "" : String.valueOf(access) + " ";
        StringBuilder buf = new StringBuilder(128);
        buf.append(access).append(Utility.classOrInterface(super.getAccessFlags())).append(" ").append(this.className).append(" extends ").append(Utility.compactClassName(this.superclassName, false)).append('\n');
        int size = this.interfaces.length;
        if (size > 0) {
            buf.append("implements\t\t");
            int i = 0;
            while (i < size) {
                buf.append(this.interfaceNames[i]);
                if (i < size - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append('\n');
        }
        buf.append("file name\t\t").append(this.fileName).append('\n');
        buf.append("compiled from\t\t").append(this.sourceFileName).append('\n');
        buf.append("compiler version\t").append(this.major).append(".").append(this.minor).append('\n');
        buf.append("access flags\t\t").append(super.getAccessFlags()).append('\n');
        buf.append("constant pool\t\t").append(this.constantPool.getLength()).append(" entries\n");
        buf.append("ACC_SUPER flag\t\t").append(this.isSuper()).append("\n");
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s):\n");
            Attribute[] attributeArray = this.attributes;
            n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = attributeArray[n2];
                buf.append(JavaClass.indent(attribute));
                ++n2;
            }
        }
        if ((annotations = this.getAnnotationEntries()) != null && annotations.length > 0) {
            buf.append("\nAnnotation(s):\n");
            nodeArray = annotations;
            int n3 = annotations.length;
            n = 0;
            while (n < n3) {
                Node annotation = nodeArray[n];
                buf.append(JavaClass.indent(annotation));
                ++n;
            }
        }
        if (this.fields.length > 0) {
            buf.append("\n").append(this.fields.length).append(" fields:\n");
            nodeArray = this.fields;
            int n4 = this.fields.length;
            n = 0;
            while (n < n4) {
                Node field = nodeArray[n];
                buf.append("\t").append(field).append('\n');
                ++n;
            }
        }
        if (this.methods.length > 0) {
            buf.append("\n").append(this.methods.length).append(" methods:\n");
            nodeArray = this.methods;
            int n5 = this.methods.length;
            n = 0;
            while (n < n5) {
                Node method = nodeArray[n];
                buf.append("\t").append(method).append('\n');
                ++n;
            }
        }
        return buf.toString();
    }

    private static String indent(Object obj) {
        StringTokenizer tok = new StringTokenizer(obj.toString(), "\n");
        StringBuilder buf = new StringBuilder();
        while (tok.hasMoreTokens()) {
            buf.append("\t").append(tok.nextToken()).append("\n");
        }
        return buf.toString();
    }

    public JavaClass copy() {
        JavaClass c = null;
        try {
            c = (JavaClass)this.clone();
            c.constantPool = this.constantPool.copy();
            c.interfaces = (int[])this.interfaces.clone();
            c.interfaceNames = (String[])this.interfaceNames.clone();
            c.fields = new Field[this.fields.length];
            int i = 0;
            while (i < this.fields.length) {
                c.fields[i] = this.fields[i].copy(c.constantPool);
                ++i;
            }
            c.methods = new Method[this.methods.length];
            i = 0;
            while (i < this.methods.length) {
                c.methods[i] = this.methods[i].copy(c.constantPool);
                ++i;
            }
            c.attributes = new Attribute[this.attributes.length];
            i = 0;
            while (i < this.attributes.length) {
                c.attributes[i] = this.attributes[i].copy(c.constantPool);
                ++i;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return c;
    }

    public final boolean isSuper() {
        return (super.getAccessFlags() & 0x20) != 0;
    }

    public final boolean isClass() {
        return (super.getAccessFlags() & 0x200) == 0;
    }

    public final boolean isAnonymous() {
        this.computeNestedTypeStatus();
        return this.isAnonymous;
    }

    public final boolean isNested() {
        this.computeNestedTypeStatus();
        return this.isNested;
    }

    private void computeNestedTypeStatus() {
        if (this.computedNestedTypeStatus) {
            return;
        }
        Attribute[] attributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof InnerClasses) {
                InnerClass[] innerClasses;
                InnerClass[] innerClassArray = innerClasses = ((InnerClasses)attribute).getInnerClasses();
                int n3 = innerClasses.length;
                int n4 = 0;
                while (n4 < n3) {
                    InnerClass innerClasse = innerClassArray[n4];
                    boolean innerClassAttributeRefersToMe = false;
                    String inner_class_name = this.constantPool.getConstantString(innerClasse.getInnerClassIndex(), (byte)7);
                    if ((inner_class_name = Utility.compactClassName(inner_class_name, false)).equals(this.getClassName())) {
                        innerClassAttributeRefersToMe = true;
                    }
                    if (innerClassAttributeRefersToMe) {
                        this.isNested = true;
                        if (innerClasse.getInnerNameIndex() == 0) {
                            this.isAnonymous = true;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.computedNestedTypeStatus = true;
    }

    public final byte getSource() {
        return this.source;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public final boolean instanceOf(JavaClass super_class) throws ClassNotFoundException {
        JavaClass[] super_classes;
        if (this.equals(super_class)) {
            return true;
        }
        JavaClass[] javaClassArray = super_classes = this.getSuperClasses();
        int n = super_classes.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass super_classe = javaClassArray[n2];
            if (super_classe.equals(super_class)) {
                return true;
            }
            ++n2;
        }
        if (super_class.isInterface()) {
            return this.implementationOf(super_class);
        }
        return false;
    }

    public boolean implementationOf(JavaClass inter) throws ClassNotFoundException {
        JavaClass[] super_interfaces;
        if (!inter.isInterface()) {
            throw new IllegalArgumentException(String.valueOf(inter.getClassName()) + " is no interface");
        }
        if (this.equals(inter)) {
            return true;
        }
        JavaClass[] javaClassArray = super_interfaces = this.getAllInterfaces();
        int n = super_interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            JavaClass super_interface = javaClassArray[n2];
            if (super_interface.equals(inter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public JavaClass getSuperClass() throws ClassNotFoundException {
        if ("java.lang.Object".equals(this.getClassName())) {
            return null;
        }
        return this.repository.loadClass(this.getSuperclassName());
    }

    public JavaClass[] getSuperClasses() throws ClassNotFoundException {
        JavaClass clazz = this;
        ArrayList<JavaClass> allSuperClasses = new ArrayList<JavaClass>();
        clazz = clazz.getSuperClass();
        while (clazz != null) {
            allSuperClasses.add(clazz);
            clazz = clazz.getSuperClass();
        }
        return allSuperClasses.toArray(new JavaClass[allSuperClasses.size()]);
    }

    public JavaClass[] getInterfaces() throws ClassNotFoundException {
        String[] _interfaces = this.getInterfaceNames();
        JavaClass[] classes = new JavaClass[_interfaces.length];
        int i = 0;
        while (i < _interfaces.length) {
            classes[i] = this.repository.loadClass(_interfaces[i]);
            ++i;
        }
        return classes;
    }

    public JavaClass[] getAllInterfaces() throws ClassNotFoundException {
        ClassQueue queue = new ClassQueue();
        TreeSet<JavaClass> allInterfaces = new TreeSet<JavaClass>();
        queue.enqueue(this);
        while (!queue.empty()) {
            JavaClass clazz = queue.dequeue();
            JavaClass souper = clazz.getSuperClass();
            JavaClass[] _interfaces = clazz.getInterfaces();
            if (clazz.isInterface()) {
                allInterfaces.add(clazz);
            } else if (souper != null) {
                queue.enqueue(souper);
            }
            JavaClass[] javaClassArray = _interfaces;
            int n = _interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                JavaClass _interface = javaClassArray[n2];
                queue.enqueue(_interface);
                ++n2;
            }
        }
        return allInterfaces.toArray(new JavaClass[allInterfaces.size()]);
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator comparator) {
        bcelComparator = comparator;
    }

    public boolean equals(Object obj) {
        return bcelComparator.equals(this, obj);
    }

    @Override
    public int compareTo(JavaClass obj) {
        return this.getClassName().compareTo(obj.getClassName());
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

