/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ModuleExports;
import org.apache.bcel.classfile.ModuleOpens;
import org.apache.bcel.classfile.ModuleProvides;
import org.apache.bcel.classfile.ModuleRequires;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class Module
extends Attribute {
    private final int moduleNameIndex;
    private final int moduleFlags;
    private final int moduleVersionIndex;
    private ModuleRequires[] requiresTable;
    private ModuleExports[] exportsTable;
    private ModuleOpens[] opensTable;
    private final int usesCount;
    private final int[] usesIndex;
    private ModuleProvides[] providesTable;

    Module(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        super((byte)22, name_index, length, constant_pool);
        this.moduleNameIndex = input.readUnsignedShort();
        this.moduleFlags = input.readUnsignedShort();
        this.moduleVersionIndex = input.readUnsignedShort();
        int requires_count = input.readUnsignedShort();
        this.requiresTable = new ModuleRequires[requires_count];
        int i = 0;
        while (i < requires_count) {
            this.requiresTable[i] = new ModuleRequires(input);
            ++i;
        }
        int exports_count = input.readUnsignedShort();
        this.exportsTable = new ModuleExports[exports_count];
        int i2 = 0;
        while (i2 < exports_count) {
            this.exportsTable[i2] = new ModuleExports(input);
            ++i2;
        }
        int opens_count = input.readUnsignedShort();
        this.opensTable = new ModuleOpens[opens_count];
        int i3 = 0;
        while (i3 < opens_count) {
            this.opensTable[i3] = new ModuleOpens(input);
            ++i3;
        }
        this.usesCount = input.readUnsignedShort();
        this.usesIndex = new int[this.usesCount];
        i3 = 0;
        while (i3 < this.usesCount) {
            this.usesIndex[i3] = input.readUnsignedShort();
            ++i3;
        }
        int provides_count = input.readUnsignedShort();
        this.providesTable = new ModuleProvides[provides_count];
        int i4 = 0;
        while (i4 < provides_count) {
            this.providesTable[i4] = new ModuleProvides(input);
            ++i4;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModule(this);
    }

    public ModuleRequires[] getRequiresTable() {
        return this.requiresTable;
    }

    public ModuleExports[] getExportsTable() {
        return this.exportsTable;
    }

    public ModuleOpens[] getOpensTable() {
        return this.opensTable;
    }

    public ModuleProvides[] getProvidesTable() {
        return this.providesTable;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        Node entry;
        super.dump(file);
        file.writeShort(this.moduleNameIndex);
        file.writeShort(this.moduleFlags);
        file.writeShort(this.moduleVersionIndex);
        file.writeShort(this.requiresTable.length);
        Object[] objectArray = this.requiresTable;
        int n = this.requiresTable.length;
        int n2 = 0;
        while (n2 < n) {
            entry = objectArray[n2];
            ((ModuleRequires)entry).dump(file);
            ++n2;
        }
        file.writeShort(this.exportsTable.length);
        objectArray = this.exportsTable;
        n = this.exportsTable.length;
        n2 = 0;
        while (n2 < n) {
            entry = objectArray[n2];
            ((ModuleExports)entry).dump(file);
            ++n2;
        }
        file.writeShort(this.opensTable.length);
        objectArray = this.opensTable;
        n = this.opensTable.length;
        n2 = 0;
        while (n2 < n) {
            entry = objectArray[n2];
            ((ModuleOpens)entry).dump(file);
            ++n2;
        }
        file.writeShort(this.usesIndex.length);
        objectArray = this.usesIndex;
        n = this.usesIndex.length;
        n2 = 0;
        while (n2 < n) {
            Node entry2 = objectArray[n2];
            file.writeShort((int)entry2);
            ++n2;
        }
        file.writeShort(this.providesTable.length);
        objectArray = this.providesTable;
        n = this.providesTable.length;
        n2 = 0;
        while (n2 < n) {
            Node entry3 = objectArray[n2];
            ((ModuleProvides)entry3).dump(file);
            ++n2;
        }
    }

    @Override
    public String toString() {
        Node module;
        ConstantPool cp = super.getConstantPool();
        StringBuilder buf = new StringBuilder();
        buf.append("Module:\n");
        buf.append("  name:    ").append(cp.getConstantString(this.moduleNameIndex, (byte)19).replace('/', '.')).append("\n");
        buf.append("  flags:   ").append(String.format("%04x", this.moduleFlags)).append("\n");
        String version = this.moduleVersionIndex == 0 ? "0" : cp.getConstantString(this.moduleVersionIndex, (byte)1);
        buf.append("  version: ").append(version).append("\n");
        buf.append("  requires(").append(this.requiresTable.length).append("):\n");
        Object[] objectArray = this.requiresTable;
        int n = this.requiresTable.length;
        int n2 = 0;
        while (n2 < n) {
            module = objectArray[n2];
            buf.append("    ").append(((ModuleRequires)module).toString(cp)).append("\n");
            ++n2;
        }
        buf.append("  exports(").append(this.exportsTable.length).append("):\n");
        objectArray = this.exportsTable;
        n = this.exportsTable.length;
        n2 = 0;
        while (n2 < n) {
            module = objectArray[n2];
            buf.append("    ").append(((ModuleExports)module).toString(cp)).append("\n");
            ++n2;
        }
        buf.append("  opens(").append(this.opensTable.length).append("):\n");
        objectArray = this.opensTable;
        n = this.opensTable.length;
        n2 = 0;
        while (n2 < n) {
            module = objectArray[n2];
            buf.append("    ").append(((ModuleOpens)module).toString(cp)).append("\n");
            ++n2;
        }
        buf.append("  uses(").append(this.usesIndex.length).append("):\n");
        objectArray = this.usesIndex;
        n = this.usesIndex.length;
        n2 = 0;
        while (n2 < n) {
            Node index = objectArray[n2];
            String class_name = cp.getConstantString((int)index, (byte)7);
            buf.append("    ").append(Utility.compactClassName(class_name, false)).append("\n");
            ++n2;
        }
        buf.append("  provides(").append(this.providesTable.length).append("):\n");
        objectArray = this.providesTable;
        n = this.providesTable.length;
        n2 = 0;
        while (n2 < n) {
            Node module2 = objectArray[n2];
            buf.append("    ").append(((ModuleProvides)module2).toString(cp)).append("\n");
            ++n2;
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        Module c = (Module)this.clone();
        c.requiresTable = new ModuleRequires[this.requiresTable.length];
        int i = 0;
        while (i < this.requiresTable.length) {
            c.requiresTable[i] = this.requiresTable[i].copy();
            ++i;
        }
        c.exportsTable = new ModuleExports[this.exportsTable.length];
        i = 0;
        while (i < this.exportsTable.length) {
            c.exportsTable[i] = this.exportsTable[i].copy();
            ++i;
        }
        c.opensTable = new ModuleOpens[this.opensTable.length];
        i = 0;
        while (i < this.opensTable.length) {
            c.opensTable[i] = this.opensTable[i].copy();
            ++i;
        }
        c.providesTable = new ModuleProvides[this.providesTable.length];
        i = 0;
        while (i < this.providesTable.length) {
            c.providesTable[i] = this.providesTable[i].copy();
            ++i;
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

