/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ModuleExports
implements Cloneable,
Node {
    private final int exportsIndex;
    private final int exportsFlags;
    private final int exportsToCount;
    private final int[] exportsToIndex;

    ModuleExports(DataInput file) throws IOException {
        this.exportsIndex = file.readUnsignedShort();
        this.exportsFlags = file.readUnsignedShort();
        this.exportsToCount = file.readUnsignedShort();
        this.exportsToIndex = new int[this.exportsToCount];
        int i = 0;
        while (i < this.exportsToCount) {
            this.exportsToIndex[i] = file.readUnsignedShort();
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleExports(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.exportsIndex);
        file.writeShort(this.exportsFlags);
        file.writeShort(this.exportsToCount);
        int[] nArray = this.exportsToIndex;
        int n = this.exportsToIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int entry = nArray[n2];
            file.writeShort(entry);
            ++n2;
        }
    }

    public String toString() {
        return "exports(" + this.exportsIndex + ", " + this.exportsFlags + ", " + this.exportsToCount + ", ...)";
    }

    public String toString(ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String package_name = constant_pool.constantToString(this.exportsIndex, (byte)20);
        buf.append(Utility.compactClassName(package_name, false));
        buf.append(", ").append(String.format("%04x", this.exportsFlags));
        buf.append(", to(").append(this.exportsToCount).append("):\n");
        int[] nArray = this.exportsToIndex;
        int n = this.exportsToIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            String module_name = constant_pool.getConstantString(index, (byte)19);
            buf.append("      ").append(Utility.compactClassName(module_name, false)).append("\n");
            ++n2;
        }
        return buf.substring(0, buf.length() - 1);
    }

    public ModuleExports copy() {
        try {
            return (ModuleExports)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

