/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ModuleOpens
implements Cloneable,
Node {
    private final int opensIndex;
    private final int opensFlags;
    private final int opensToCount;
    private final int[] opensToIndex;

    ModuleOpens(DataInput file) throws IOException {
        this.opensIndex = file.readUnsignedShort();
        this.opensFlags = file.readUnsignedShort();
        this.opensToCount = file.readUnsignedShort();
        this.opensToIndex = new int[this.opensToCount];
        int i = 0;
        while (i < this.opensToCount) {
            this.opensToIndex[i] = file.readUnsignedShort();
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleOpens(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.opensIndex);
        file.writeShort(this.opensFlags);
        file.writeShort(this.opensToCount);
        int[] nArray = this.opensToIndex;
        int n = this.opensToIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int entry = nArray[n2];
            file.writeShort(entry);
            ++n2;
        }
    }

    public String toString() {
        return "opens(" + this.opensIndex + ", " + this.opensFlags + ", " + this.opensToCount + ", ...)";
    }

    public String toString(ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String package_name = constant_pool.constantToString(this.opensIndex, (byte)20);
        buf.append(Utility.compactClassName(package_name, false));
        buf.append(", ").append(String.format("%04x", this.opensFlags));
        buf.append(", to(").append(this.opensToCount).append("):\n");
        int[] nArray = this.opensToIndex;
        int n = this.opensToIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            String module_name = constant_pool.getConstantString(index, (byte)19);
            buf.append("      ").append(Utility.compactClassName(module_name, false)).append("\n");
            ++n2;
        }
        return buf.substring(0, buf.length() - 1);
    }

    public ModuleOpens copy() {
        try {
            return (ModuleOpens)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

