/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ModulePackages
extends Attribute {
    private int[] packageIndexTable;

    public ModulePackages(ModulePackages c) {
        this(c.getNameIndex(), c.getLength(), c.getPackageIndexTable(), c.getConstantPool());
    }

    public ModulePackages(int nameIndex, int length, int[] packageIndexTable, ConstantPool constantPool) {
        super((byte)23, nameIndex, length, constantPool);
        this.packageIndexTable = packageIndexTable != null ? packageIndexTable : new int[]{};
    }

    ModulePackages(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (int[])null, constant_pool);
        int number_of_packages = input.readUnsignedShort();
        this.packageIndexTable = new int[number_of_packages];
        int i = 0;
        while (i < number_of_packages) {
            this.packageIndexTable[i] = input.readUnsignedShort();
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModulePackages(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.packageIndexTable.length);
        int[] nArray = this.packageIndexTable;
        int n = this.packageIndexTable.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            file.writeShort(index);
            ++n2;
        }
    }

    public int[] getPackageIndexTable() {
        return this.packageIndexTable;
    }

    public int getNumberOfPackages() {
        return this.packageIndexTable == null ? 0 : this.packageIndexTable.length;
    }

    public String[] getPackageNames() {
        String[] names = new String[this.packageIndexTable.length];
        int i = 0;
        while (i < this.packageIndexTable.length) {
            names[i] = super.getConstantPool().getConstantString(this.packageIndexTable[i], (byte)20).replace('/', '.');
            ++i;
        }
        return names;
    }

    public void setPackageIndexTable(int[] packageIndexTable) {
        this.packageIndexTable = packageIndexTable != null ? packageIndexTable : new int[]{};
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ModulePackages(");
        buf.append(this.packageIndexTable.length);
        buf.append("):\n");
        int[] nArray = this.packageIndexTable;
        int n = this.packageIndexTable.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            String package_name = super.getConstantPool().getConstantString(index, (byte)20);
            buf.append("  ").append(Utility.compactClassName(package_name, false)).append("\n");
            ++n2;
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        ModulePackages c = (ModulePackages)this.clone();
        if (this.packageIndexTable != null) {
            c.packageIndexTable = new int[this.packageIndexTable.length];
            System.arraycopy(this.packageIndexTable, 0, c.packageIndexTable, 0, this.packageIndexTable.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

