/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ModuleProvides
implements Cloneable,
Node {
    private final int providesIndex;
    private final int providesWithCount;
    private final int[] providesWithIndex;

    ModuleProvides(DataInput file) throws IOException {
        this.providesIndex = file.readUnsignedShort();
        this.providesWithCount = file.readUnsignedShort();
        this.providesWithIndex = new int[this.providesWithCount];
        int i = 0;
        while (i < this.providesWithCount) {
            this.providesWithIndex[i] = file.readUnsignedShort();
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleProvides(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.providesIndex);
        file.writeShort(this.providesWithCount);
        int[] nArray = this.providesWithIndex;
        int n = this.providesWithIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int entry = nArray[n2];
            file.writeShort(entry);
            ++n2;
        }
    }

    public String toString() {
        return "provides(" + this.providesIndex + ", " + this.providesWithCount + ", ...)";
    }

    public String toString(ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String interface_name = constant_pool.constantToString(this.providesIndex, (byte)7);
        buf.append(Utility.compactClassName(interface_name, false));
        buf.append(", with(").append(this.providesWithCount).append("):\n");
        int[] nArray = this.providesWithIndex;
        int n = this.providesWithIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            String class_name = constant_pool.getConstantString(index, (byte)7);
            buf.append("      ").append(Utility.compactClassName(class_name, false)).append("\n");
            ++n2;
        }
        return buf.substring(0, buf.length() - 1);
    }

    public ModuleProvides copy() {
        try {
            return (ModuleProvides)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

