/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.Visitor;

public class ParameterAnnotationEntry
implements Node {
    private final AnnotationEntry[] annotationTable;

    ParameterAnnotationEntry(DataInput input, ConstantPool constant_pool) throws IOException {
        int annotation_table_length = input.readUnsignedShort();
        this.annotationTable = new AnnotationEntry[annotation_table_length];
        int i = 0;
        while (i < annotation_table_length) {
            this.annotationTable[i] = AnnotationEntry.read(input, constant_pool, false);
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitParameterAnnotationEntry(this);
    }

    public AnnotationEntry[] getAnnotationEntries() {
        return this.annotationTable;
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.annotationTable.length);
        AnnotationEntry[] annotationEntryArray = this.annotationTable;
        int n = this.annotationTable.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationEntry entry = annotationEntryArray[n2];
            entry.dump(dos);
            ++n2;
        }
    }

    public static ParameterAnnotationEntry[] createParameterAnnotationEntries(Attribute[] attrs) {
        ArrayList accumulatedAnnotations = new ArrayList(attrs.length);
        Attribute[] attributeArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof ParameterAnnotations) {
                ParameterAnnotations runtimeAnnotations = (ParameterAnnotations)attribute;
                Collections.addAll(accumulatedAnnotations, runtimeAnnotations.getParameterAnnotationEntries());
            }
            ++n2;
        }
        return accumulatedAnnotations.toArray(new ParameterAnnotationEntry[accumulatedAnnotations.size()]);
    }
}

