/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.Visitor;

public abstract class ParameterAnnotations
extends Attribute {
    private ParameterAnnotationEntry[] parameterAnnotationTable;

    ParameterAnnotations(byte parameter_annotation_type, int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(parameter_annotation_type, name_index, length, (ParameterAnnotationEntry[])null, constant_pool);
        int num_parameters = input.readUnsignedByte();
        this.parameterAnnotationTable = new ParameterAnnotationEntry[num_parameters];
        int i = 0;
        while (i < num_parameters) {
            this.parameterAnnotationTable[i] = new ParameterAnnotationEntry(input, constant_pool);
            ++i;
        }
    }

    public ParameterAnnotations(byte parameterAnnotationType, int nameIndex, int length, ParameterAnnotationEntry[] parameterAnnotationTable, ConstantPool constantPool) {
        super(parameterAnnotationType, nameIndex, length, constantPool);
        this.parameterAnnotationTable = parameterAnnotationTable;
    }

    @Override
    public void accept(Visitor v) {
        v.visitParameterAnnotation(this);
    }

    public final void setParameterAnnotationTable(ParameterAnnotationEntry[] parameterAnnotationTable) {
        this.parameterAnnotationTable = parameterAnnotationTable;
    }

    public final ParameterAnnotationEntry[] getParameterAnnotationTable() {
        return this.parameterAnnotationTable;
    }

    public ParameterAnnotationEntry[] getParameterAnnotationEntries() {
        return this.parameterAnnotationTable;
    }

    @Override
    public void dump(DataOutputStream dos) throws IOException {
        super.dump(dos);
        dos.writeByte(this.parameterAnnotationTable.length);
        ParameterAnnotationEntry[] parameterAnnotationEntryArray = this.parameterAnnotationTable;
        int n = this.parameterAnnotationTable.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterAnnotationEntry element = parameterAnnotationEntryArray[n2];
            element.dump(dos);
            ++n2;
        }
    }

    @Override
    public Attribute copy(ConstantPool constant_pool) {
        return (Attribute)this.clone();
    }
}

