/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.StackMapType;
import org.apache.bcel.classfile.Visitor;

public final class StackMapEntry
implements Node,
Cloneable {
    private int frameType;
    private int byteCodeOffset;
    private StackMapType[] typesOfLocals;
    private StackMapType[] typesOfStackItems;
    private ConstantPool constantPool;

    StackMapEntry(DataInput input, ConstantPool constantPool) throws IOException {
        this(input.readByte() & 0xFF, -1, null, null, constantPool);
        if (this.frameType >= 0 && this.frameType <= 63) {
            this.byteCodeOffset = this.frameType - 0;
        } else if (this.frameType >= 64 && this.frameType <= 127) {
            this.byteCodeOffset = this.frameType - 64;
            this.typesOfStackItems = new StackMapType[1];
            this.typesOfStackItems[0] = new StackMapType(input, constantPool);
        } else if (this.frameType == 247) {
            this.byteCodeOffset = input.readShort();
            this.typesOfStackItems = new StackMapType[1];
            this.typesOfStackItems[0] = new StackMapType(input, constantPool);
        } else if (this.frameType >= 248 && this.frameType <= 250) {
            this.byteCodeOffset = input.readShort();
        } else if (this.frameType == 251) {
            this.byteCodeOffset = input.readShort();
        } else if (this.frameType >= 252 && this.frameType <= 254) {
            this.byteCodeOffset = input.readShort();
            int number_of_locals = this.frameType - 251;
            this.typesOfLocals = new StackMapType[number_of_locals];
            int i = 0;
            while (i < number_of_locals) {
                this.typesOfLocals[i] = new StackMapType(input, constantPool);
                ++i;
            }
        } else if (this.frameType == 255) {
            this.byteCodeOffset = input.readShort();
            int number_of_locals = input.readShort();
            this.typesOfLocals = new StackMapType[number_of_locals];
            int i = 0;
            while (i < number_of_locals) {
                this.typesOfLocals[i] = new StackMapType(input, constantPool);
                ++i;
            }
            int number_of_stack_items = input.readShort();
            this.typesOfStackItems = new StackMapType[number_of_stack_items];
            int i2 = 0;
            while (i2 < number_of_stack_items) {
                this.typesOfStackItems[i2] = new StackMapType(input, constantPool);
                ++i2;
            }
        } else {
            throw new ClassFormatException("Invalid frame type found while parsing stack map table: " + this.frameType);
        }
    }

    @Deprecated
    public StackMapEntry(int byteCodeOffset, int numberOfLocals, StackMapType[] typesOfLocals, int numberOfStackItems, StackMapType[] typesOfStackItems, ConstantPool constantPool) {
        this.byteCodeOffset = byteCodeOffset;
        this.typesOfLocals = typesOfLocals != null ? typesOfLocals : new StackMapType[]{};
        this.typesOfStackItems = typesOfStackItems != null ? typesOfStackItems : new StackMapType[]{};
        this.constantPool = constantPool;
    }

    public StackMapEntry(int tag, int byteCodeOffset, StackMapType[] typesOfLocals, StackMapType[] typesOfStackItems, ConstantPool constantPool) {
        this.frameType = tag;
        this.byteCodeOffset = byteCodeOffset;
        this.typesOfLocals = typesOfLocals != null ? typesOfLocals : new StackMapType[]{};
        this.typesOfStackItems = typesOfStackItems != null ? typesOfStackItems : new StackMapType[]{};
        this.constantPool = constantPool;
    }

    public void dump(DataOutputStream file) throws IOException {
        file.write(this.frameType);
        if (this.frameType < 0 || this.frameType > 63) {
            if (this.frameType >= 64 && this.frameType <= 127) {
                this.typesOfStackItems[0].dump(file);
            } else if (this.frameType == 247) {
                file.writeShort(this.byteCodeOffset);
                this.typesOfStackItems[0].dump(file);
            } else if (this.frameType >= 248 && this.frameType <= 250) {
                file.writeShort(this.byteCodeOffset);
            } else if (this.frameType == 251) {
                file.writeShort(this.byteCodeOffset);
            } else if (this.frameType >= 252 && this.frameType <= 254) {
                file.writeShort(this.byteCodeOffset);
                StackMapType[] stackMapTypeArray = this.typesOfLocals;
                int n = this.typesOfLocals.length;
                int n2 = 0;
                while (n2 < n) {
                    StackMapType type = stackMapTypeArray[n2];
                    type.dump(file);
                    ++n2;
                }
            } else if (this.frameType == 255) {
                StackMapType type;
                file.writeShort(this.byteCodeOffset);
                file.writeShort(this.typesOfLocals.length);
                StackMapType[] stackMapTypeArray = this.typesOfLocals;
                int n = this.typesOfLocals.length;
                int n3 = 0;
                while (n3 < n) {
                    type = stackMapTypeArray[n3];
                    type.dump(file);
                    ++n3;
                }
                file.writeShort(this.typesOfStackItems.length);
                stackMapTypeArray = this.typesOfStackItems;
                n = this.typesOfStackItems.length;
                n3 = 0;
                while (n3 < n) {
                    type = stackMapTypeArray[n3];
                    type.dump(file);
                    ++n3;
                }
            } else {
                throw new ClassFormatException("Invalid Stack map table tag: " + this.frameType);
            }
        }
    }

    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder(64);
        buf.append("(");
        if (this.frameType >= 0 && this.frameType <= 63) {
            buf.append("SAME");
        } else if (this.frameType >= 64 && this.frameType <= 127) {
            buf.append("SAME_LOCALS_1_STACK");
        } else if (this.frameType == 247) {
            buf.append("SAME_LOCALS_1_STACK_EXTENDED");
        } else if (this.frameType >= 248 && this.frameType <= 250) {
            buf.append("CHOP ").append(String.valueOf(251 - this.frameType));
        } else if (this.frameType == 251) {
            buf.append("SAME_EXTENDED");
        } else if (this.frameType >= 252 && this.frameType <= 254) {
            buf.append("APPEND ").append(String.valueOf(this.frameType - 251));
        } else if (this.frameType == 255) {
            buf.append("FULL");
        } else {
            buf.append("UNKNOWN (").append(this.frameType).append(")");
        }
        buf.append(", offset delta=").append(this.byteCodeOffset);
        if (this.typesOfLocals.length > 0) {
            buf.append(", locals={");
            i = 0;
            while (i < this.typesOfLocals.length) {
                buf.append(this.typesOfLocals[i]);
                if (i < this.typesOfLocals.length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append("}");
        }
        if (this.typesOfStackItems.length > 0) {
            buf.append(", stack items={");
            i = 0;
            while (i < this.typesOfStackItems.length) {
                buf.append(this.typesOfStackItems[i]);
                if (i < this.typesOfStackItems.length - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append("}");
        }
        buf.append(")");
        return buf.toString();
    }

    int getMapEntrySize() {
        if (this.frameType >= 0 && this.frameType <= 63) {
            return 1;
        }
        if (this.frameType >= 64 && this.frameType <= 127) {
            return 1 + (this.typesOfStackItems[0].hasIndex() ? 3 : 1);
        }
        if (this.frameType == 247) {
            return 3 + (this.typesOfStackItems[0].hasIndex() ? 3 : 1);
        }
        if (this.frameType >= 248 && this.frameType <= 250) {
            return 3;
        }
        if (this.frameType == 251) {
            return 3;
        }
        if (this.frameType >= 252 && this.frameType <= 254) {
            int len = 3;
            StackMapType[] stackMapTypeArray = this.typesOfLocals;
            int n = this.typesOfLocals.length;
            int n2 = 0;
            while (n2 < n) {
                StackMapType types_of_local = stackMapTypeArray[n2];
                len += types_of_local.hasIndex() ? 3 : 1;
                ++n2;
            }
            return len;
        }
        if (this.frameType == 255) {
            int len = 7;
            StackMapType[] stackMapTypeArray = this.typesOfLocals;
            int n = this.typesOfLocals.length;
            int n3 = 0;
            while (n3 < n) {
                StackMapType types_of_local = stackMapTypeArray[n3];
                len += types_of_local.hasIndex() ? 3 : 1;
                ++n3;
            }
            stackMapTypeArray = this.typesOfStackItems;
            n = this.typesOfStackItems.length;
            n3 = 0;
            while (n3 < n) {
                StackMapType types_of_stack_item = stackMapTypeArray[n3];
                len += types_of_stack_item.hasIndex() ? 3 : 1;
                ++n3;
            }
            return len;
        }
        throw new IllegalStateException("Invalid StackMap frameType: " + this.frameType);
    }

    public void setFrameType(int f) {
        if (f >= 0 && f <= 63) {
            this.byteCodeOffset = f - 0;
        } else if (f >= 64 && f <= 127) {
            this.byteCodeOffset = f - 64;
        } else if (!(f == 247 || f >= 248 && f <= 250 || f == 251 || f >= 252 && f <= 254 || f == 255)) {
            throw new IllegalArgumentException("Invalid StackMap frameType");
        }
        this.frameType = f;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public void setByteCodeOffset(int new_offset) {
        if (new_offset < 0 || new_offset > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid StackMap offset: " + new_offset);
        }
        if (this.frameType >= 0 && this.frameType <= 63) {
            this.frameType = new_offset > 63 ? 251 : new_offset;
        } else if (this.frameType >= 64 && this.frameType <= 127) {
            this.frameType = new_offset > 63 ? 247 : 64 + new_offset;
        } else if (!(this.frameType == 247 || this.frameType >= 248 && this.frameType <= 250 || this.frameType == 251 || this.frameType >= 252 && this.frameType <= 254 || this.frameType == 255)) {
            throw new IllegalStateException("Invalid StackMap frameType: " + this.frameType);
        }
        this.byteCodeOffset = new_offset;
    }

    public void updateByteCodeOffset(int delta) {
        this.setByteCodeOffset(this.byteCodeOffset + delta);
    }

    public int getByteCodeOffset() {
        return this.byteCodeOffset;
    }

    @Deprecated
    public void setNumberOfLocals(int n) {
    }

    public int getNumberOfLocals() {
        return this.typesOfLocals.length;
    }

    public void setTypesOfLocals(StackMapType[] types) {
        this.typesOfLocals = types != null ? types : new StackMapType[]{};
    }

    public StackMapType[] getTypesOfLocals() {
        return this.typesOfLocals;
    }

    @Deprecated
    public void setNumberOfStackItems(int n) {
    }

    public int getNumberOfStackItems() {
        return this.typesOfStackItems.length;
    }

    public void setTypesOfStackItems(StackMapType[] types) {
        this.typesOfStackItems = types != null ? types : new StackMapType[]{};
    }

    public StackMapType[] getTypesOfStackItems() {
        return this.typesOfStackItems;
    }

    public StackMapEntry copy() {
        StackMapEntry e;
        try {
            e = (StackMapEntry)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
        e.typesOfLocals = new StackMapType[this.typesOfLocals.length];
        int i = 0;
        while (i < this.typesOfLocals.length) {
            e.typesOfLocals[i] = this.typesOfLocals[i].copy();
            ++i;
        }
        e.typesOfStackItems = new StackMapType[this.typesOfStackItems.length];
        i = 0;
        while (i < this.typesOfStackItems.length) {
            e.typesOfStackItems[i] = this.typesOfStackItems[i].copy();
            ++i;
        }
        return e;
    }

    @Override
    public void accept(Visitor v) {
        v.visitStackMapEntry(this);
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }
}

