/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.util.ByteSequence;

public abstract class Utility {
    private static ThreadLocal<Integer> consumed_chars = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static boolean wide = false;
    private static final int FREE_CHARS = 48;
    private static int[] CHAR_MAP = new int[48];
    private static int[] MAP_CHAR = new int[256];
    private static final char ESCAPE_CHAR = '$';

    static {
        int j = 0;
        int i = 65;
        while (i <= 90) {
            Utility.CHAR_MAP[j] = i;
            Utility.MAP_CHAR[i] = j++;
            ++i;
        }
        i = 103;
        while (i <= 122) {
            Utility.CHAR_MAP[j] = i;
            Utility.MAP_CHAR[i] = j++;
            ++i;
        }
        Utility.CHAR_MAP[j] = 36;
        Utility.MAP_CHAR[36] = j++;
        Utility.CHAR_MAP[j] = 95;
        Utility.MAP_CHAR[95] = j;
    }

    private static int unwrap(ThreadLocal<Integer> tl) {
        return tl.get();
    }

    private static void wrap(ThreadLocal<Integer> tl, int value) {
        tl.set(value);
    }

    public static String accessToString(int access_flags) {
        return Utility.accessToString(access_flags, false);
    }

    public static String accessToString(int access_flags, boolean for_class) {
        StringBuilder buf = new StringBuilder();
        int p = 0;
        int i = 0;
        while (p < 32768) {
            p = Utility.pow2(i);
            if ((access_flags & p) != 0 && (!for_class || p != 32 && p != 512)) {
                buf.append(Const.getAccessName(i)).append(" ");
            }
            ++i;
        }
        return buf.toString().trim();
    }

    public static String classOrInterface(int access_flags) {
        return (access_flags & 0x200) != 0 ? "interface" : "class";
    }

    public static String codeToString(byte[] code, ConstantPool constant_pool, int index, int length, boolean verbose) {
        StringBuilder buf = new StringBuilder(code.length * 20);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (ByteSequence stream = new ByteSequence(code);){
                int i = 0;
                while (i < index) {
                    Utility.codeToString(stream, constant_pool, verbose);
                    ++i;
                }
                i = 0;
                while (stream.available() > 0) {
                    if (length < 0 || i < length) {
                        String indices = Utility.fillup(String.valueOf(stream.getIndex()) + ":", 6, true, ' ');
                        buf.append(indices).append(Utility.codeToString(stream, constant_pool, verbose)).append('\n');
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ClassFormatException("Byte code error: " + buf.toString(), e);
        }
        return buf.toString();
    }

    public static String codeToString(byte[] code, ConstantPool constant_pool, int index, int length) {
        return Utility.codeToString(code, constant_pool, index, length, true);
    }

    public static String codeToString(ByteSequence bytes, ConstantPool constant_pool, boolean verbose) throws IOException {
        short opcode = (short)bytes.readUnsignedByte();
        int default_offset = 0;
        int no_pad_bytes = 0;
        StringBuilder buf = new StringBuilder(Const.getOpcodeName(opcode));
        if (opcode == 170 || opcode == 171) {
            int remainder = bytes.getIndex() % 4;
            no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            int i = 0;
            while (i < no_pad_bytes) {
                byte b = bytes.readByte();
                if (b != 0) {
                    System.err.println("Warning: Padding byte != 0 in " + Const.getOpcodeName(opcode) + ":" + b);
                }
                ++i;
            }
            default_offset = bytes.readInt();
        }
        switch (opcode) {
            case 170: {
                int low = bytes.readInt();
                int high = bytes.readInt();
                int offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                buf.append("\tdefault = ").append(default_offset += offset).append(", low = ").append(low).append(", high = ").append(high).append("(");
                int[] jump_table = new int[high - low + 1];
                int i = 0;
                while (i < jump_table.length) {
                    jump_table[i] = offset + bytes.readInt();
                    buf.append(jump_table[i]);
                    if (i < jump_table.length - 1) {
                        buf.append(", ");
                    }
                    ++i;
                }
                buf.append(")");
                break;
            }
            case 171: {
                int npairs = bytes.readInt();
                int offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                int[] match = new int[npairs];
                int[] jump_table = new int[npairs];
                buf.append("\tdefault = ").append(default_offset += offset).append(", npairs = ").append(npairs).append(" (");
                int i = 0;
                while (i < npairs) {
                    match[i] = bytes.readInt();
                    jump_table[i] = offset + bytes.readInt();
                    buf.append("(").append(match[i]).append(", ").append(jump_table[i]).append(")");
                    if (i < npairs - 1) {
                        buf.append(", ");
                    }
                    ++i;
                }
                buf.append(")");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                buf.append("\t\t#").append(bytes.getIndex() - 1 + bytes.readShort());
                break;
            }
            case 200: 
            case 201: {
                buf.append("\t\t#").append(bytes.getIndex() - 1 + bytes.readInt());
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int vindex;
                if (wide) {
                    vindex = bytes.readUnsignedShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                }
                buf.append("\t\t%").append(vindex);
                break;
            }
            case 196: {
                wide = true;
                buf.append("\t(wide)");
                break;
            }
            case 188: {
                buf.append("\t\t<").append(Const.getTypeName(bytes.readByte())).append(">");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t").append(constant_pool.constantToString(index, (byte)9)).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 187: 
            case 192: {
                buf.append("\t");
            }
            case 193: {
                int index = bytes.readUnsignedShort();
                buf.append("\t<").append(constant_pool.constantToString(index, (byte)7)).append(">").append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 183: 
            case 184: {
                int index = bytes.readUnsignedShort();
                Constant c = constant_pool.getConstant(index);
                buf.append("\t").append(constant_pool.constantToString(index, c.getTag())).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 182: {
                int index = bytes.readUnsignedShort();
                buf.append("\t").append(constant_pool.constantToString(index, (byte)10)).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 185: {
                int index = bytes.readUnsignedShort();
                int nargs = bytes.readUnsignedByte();
                buf.append("\t").append(constant_pool.constantToString(index, (byte)11)).append(verbose ? " (" + index + ")\t" : "").append(nargs).append("\t").append(bytes.readUnsignedByte());
                break;
            }
            case 186: {
                int index = bytes.readUnsignedShort();
                buf.append("\t").append(constant_pool.constantToString(index, (byte)18)).append(verbose ? " (" + index + ")\t" : "").append(bytes.readUnsignedByte()).append(bytes.readUnsignedByte());
                break;
            }
            case 19: 
            case 20: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t").append(constant_pool.constantToString(index, constant_pool.getConstant(index).getTag())).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 18: {
                int index = bytes.readUnsignedByte();
                buf.append("\t\t").append(constant_pool.constantToString(index, constant_pool.getConstant(index).getTag())).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 189: {
                int index = bytes.readUnsignedShort();
                buf.append("\t\t<").append(Utility.compactClassName(constant_pool.getConstantString(index, (byte)7), false)).append(">").append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 197: {
                int index = bytes.readUnsignedShort();
                int dimensions = bytes.readUnsignedByte();
                buf.append("\t<").append(Utility.compactClassName(constant_pool.getConstantString(index, (byte)7), false)).append(">\t").append(dimensions).append(verbose ? " (" + index + ")" : "");
                break;
            }
            case 132: {
                short constant;
                int vindex;
                if (wide) {
                    vindex = bytes.readUnsignedShort();
                    constant = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                    constant = bytes.readByte();
                }
                buf.append("\t\t%").append(vindex).append("\t").append(constant);
                break;
            }
            default: {
                if (Const.getNoOfOperands(opcode) <= 0) break;
                int i = 0;
                while ((long)i < Const.getOperandTypeCount(opcode)) {
                    buf.append("\t\t");
                    switch (Const.getOperandType(opcode, i)) {
                        case 8: {
                            buf.append(bytes.readByte());
                            break;
                        }
                        case 9: {
                            buf.append(bytes.readShort());
                            break;
                        }
                        case 10: {
                            buf.append(bytes.readInt());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable default case reached!");
                        }
                    }
                    ++i;
                }
                break block0;
            }
        }
        return buf.toString();
    }

    public static String codeToString(ByteSequence bytes, ConstantPool constant_pool) throws IOException {
        return Utility.codeToString(bytes, constant_pool, true);
    }

    public static String compactClassName(String str) {
        return Utility.compactClassName(str, true);
    }

    public static String compactClassName(String str, boolean chopit) {
        return Utility.compactClassName(str, "java.lang.", chopit);
    }

    public static String compactClassName(String str, String prefix, boolean chopit) {
        int len = prefix.length();
        str = str.replace('/', '.');
        if (chopit && str.startsWith(prefix) && str.substring(len).indexOf(46) == -1) {
            str = str.substring(len);
        }
        return str;
    }

    public static int setBit(int flag, int i) {
        return flag | Utility.pow2(i);
    }

    public static int clearBit(int flag, int i) {
        int bit = Utility.pow2(i);
        return (flag & bit) == 0 ? flag : flag ^ bit;
    }

    public static boolean isSet(int flag, int i) {
        return (flag & Utility.pow2(i)) != 0;
    }

    public static String methodTypeToSignature(String ret, String[] argv) throws ClassFormatException {
        String str;
        StringBuilder buf = new StringBuilder("(");
        if (argv != null) {
            String[] stringArray = argv;
            int n = argv.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                str = Utility.getSignature(element);
                if (str.endsWith("V")) {
                    throw new ClassFormatException("Invalid type: " + element);
                }
                buf.append(str);
                ++n2;
            }
        }
        str = Utility.getSignature(ret);
        buf.append(")").append(str);
        return buf.toString();
    }

    public static String[] methodSignatureArgumentTypes(String signature) throws ClassFormatException {
        return Utility.methodSignatureArgumentTypes(signature, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] methodSignatureArgumentTypes(String signature, boolean chopit) throws ClassFormatException {
        ArrayList<String> vec = new ArrayList<String>();
        try {
            int index = signature.indexOf(40) + 1;
            if (index <= 0) {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            while (true) {
                if (signature.charAt(index) == ')') {
                    return vec.toArray(new String[vec.size()]);
                }
                vec.add(Utility.typeSignatureToString(signature.substring(index), chopit));
                index += Utility.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
    }

    public static String methodSignatureReturnType(String signature) throws ClassFormatException {
        return Utility.methodSignatureReturnType(signature, true);
    }

    public static String methodSignatureReturnType(String signature, boolean chopit) throws ClassFormatException {
        String type;
        try {
            int index = signature.lastIndexOf(41) + 1;
            if (index <= 0) {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            type = Utility.typeSignatureToString(signature.substring(index), chopit);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
        return type;
    }

    public static String methodSignatureToString(String signature, String name, String access) {
        return Utility.methodSignatureToString(signature, name, access, true);
    }

    public static String methodSignatureToString(String signature, String name, String access, boolean chopit) {
        return Utility.methodSignatureToString(signature, name, access, chopit, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String methodSignatureToString(String signature, String name, String access, boolean chopit, LocalVariableTable vars) throws ClassFormatException {
        String string;
        String type;
        StringBuilder buf = new StringBuilder("(");
        int var_index = access.contains("static") ? 0 : 1;
        try {
            int index = signature.indexOf(40) + 1;
            if (index <= 0) {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            while (true) {
                if (signature.charAt(index) == ')') {
                    type = Utility.typeSignatureToString(signature.substring(++index), chopit);
                    break;
                }
                String param_type = Utility.typeSignatureToString(signature.substring(index), chopit);
                buf.append(param_type);
                if (vars != null) {
                    LocalVariable l = vars.getLocalVariable(var_index, 0);
                    if (l != null) {
                        buf.append(" ").append(l.getName());
                    }
                } else {
                    buf.append(" arg").append(var_index);
                }
                var_index = "double".equals(param_type) || "long".equals(param_type) ? (var_index += 2) : ++var_index;
                buf.append(", ");
                index += Utility.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
        if (buf.length() > 1) {
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(access));
        if (access.length() > 0) {
            string = " ";
            return stringBuilder.append(string).append(type).append(" ").append(name).append(buf.toString()).toString();
        }
        string = "";
        return stringBuilder.append(string).append(type).append(" ").append(name).append(buf.toString()).toString();
    }

    private static int pow2(int n) {
        return 1 << n;
    }

    public static String replace(String str, String old, String new_) {
        try {
            if (str.contains(old)) {
                int index;
                StringBuilder buf = new StringBuilder();
                int old_index = 0;
                while ((index = str.indexOf(old, old_index)) != -1) {
                    buf.append(str.substring(old_index, index));
                    buf.append(new_);
                    old_index = index + old.length();
                }
                buf.append(str.substring(old_index));
                str = buf.toString();
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println(e);
        }
        return str;
    }

    public static String signatureToString(String signature) {
        return Utility.signatureToString(signature, true);
    }

    public static String signatureToString(String signature, boolean chopit) {
        String type = "";
        String typeParams = "";
        int index = 0;
        if (signature.charAt(0) == '<') {
            typeParams = Utility.typeParamTypesToString(signature, chopit);
            index += Utility.unwrap(consumed_chars);
        }
        if (signature.charAt(index) == '(') {
            type = String.valueOf(typeParams) + Utility.typeSignaturesToString(signature.substring(index), chopit, ')');
            type = String.valueOf(type) + Utility.typeSignatureToString(signature.substring(index += Utility.unwrap(consumed_chars)), chopit);
            index += Utility.unwrap(consumed_chars);
            return type;
        }
        type = Utility.typeSignatureToString(signature.substring(index), chopit);
        if (typeParams.length() == 0 && (index += Utility.unwrap(consumed_chars)) == signature.length()) {
            return type;
        }
        StringBuilder typeClass = new StringBuilder(typeParams);
        typeClass.append(" extends ");
        typeClass.append(type);
        if (index < signature.length()) {
            typeClass.append(" implements ");
            typeClass.append(Utility.typeSignatureToString(signature.substring(index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        while (index < signature.length()) {
            typeClass.append(", ");
            typeClass.append(Utility.typeSignatureToString(signature.substring(index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        return typeClass.toString();
    }

    private static String typeParamTypesToString(String signature, boolean chopit) {
        StringBuilder typeParams = new StringBuilder("<");
        int index = 1;
        typeParams.append(Utility.typeParamTypeToString(signature.substring(index), chopit));
        index += Utility.unwrap(consumed_chars);
        while (signature.charAt(index) != '>') {
            typeParams.append(", ");
            typeParams.append(Utility.typeParamTypeToString(signature.substring(index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        Utility.wrap(consumed_chars, index + 1);
        return typeParams.append(">").toString();
    }

    private static String typeParamTypeToString(String signature, boolean chopit) {
        int index = signature.indexOf(58);
        if (index <= 0) {
            throw new ClassFormatException("Invalid type parameter signature: " + signature);
        }
        StringBuilder typeParam = new StringBuilder(signature.substring(0, index));
        if (signature.charAt(++index) != ':') {
            typeParam.append(" extends ");
            typeParam.append(Utility.typeSignatureToString(signature.substring(index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        while (signature.charAt(index) == ':') {
            typeParam.append(" & ");
            typeParam.append(Utility.typeSignatureToString(signature.substring(++index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        Utility.wrap(consumed_chars, index);
        return typeParam.toString();
    }

    private static String typeSignaturesToString(String signature, boolean chopit, char term) {
        StringBuilder typeList = new StringBuilder(signature.substring(0, 1));
        int index = 1;
        if (signature.charAt(index) != term) {
            typeList.append(Utility.typeSignatureToString(signature.substring(index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        while (signature.charAt(index) != term) {
            typeList.append(", ");
            typeList.append(Utility.typeSignatureToString(signature.substring(index), chopit));
            index += Utility.unwrap(consumed_chars);
        }
        Utility.wrap(consumed_chars, index + 1);
        return typeList.append(term).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String typeSignatureToString(String signature, boolean chopit) throws ClassFormatException {
        Utility.wrap(consumed_chars, 1);
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'T': {
                    int index = signature.indexOf(59);
                    if (index < 0) {
                        throw new ClassFormatException("Invalid type variable signature: " + signature);
                    }
                    Utility.wrap(consumed_chars, index + 1);
                    return Utility.compactClassName(signature.substring(1, index), chopit);
                }
                case 'L': {
                    int fromIndex = signature.indexOf(60);
                    if (fromIndex < 0) {
                        fromIndex = 0;
                    } else if ((fromIndex = signature.indexOf(62, fromIndex)) < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    int index = signature.indexOf(59, fromIndex);
                    if (index < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    int bracketIndex = signature.substring(0, index).indexOf(60);
                    if (bracketIndex < 0) {
                        Utility.wrap(consumed_chars, index + 1);
                        return Utility.compactClassName(signature.substring(1, index), chopit);
                    }
                    fromIndex = signature.indexOf(59);
                    if (fromIndex < 0) {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    if (fromIndex < bracketIndex) {
                        Utility.wrap(consumed_chars, fromIndex + 1);
                        return Utility.compactClassName(signature.substring(1, fromIndex), chopit);
                    }
                    StringBuilder type = new StringBuilder(Utility.compactClassName(signature.substring(1, bracketIndex), chopit)).append("<");
                    int consumed_chars = bracketIndex + 1;
                    if (signature.charAt(consumed_chars) == '+') {
                        type.append("? extends ");
                        ++consumed_chars;
                    } else if (signature.charAt(consumed_chars) == '-') {
                        type.append("? super ");
                        ++consumed_chars;
                    }
                    if (signature.charAt(consumed_chars) == '*') {
                        type.append("?");
                        ++consumed_chars;
                    } else {
                        type.append(Utility.typeSignatureToString(signature.substring(consumed_chars), chopit));
                        consumed_chars = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                        Utility.wrap(Utility.consumed_chars, consumed_chars);
                    }
                    while (true) {
                        if (signature.charAt(consumed_chars) == '>') {
                            type.append(">");
                            if (signature.charAt(++consumed_chars) != '.') break;
                            type.append(".");
                            type.append(Utility.typeSignatureToString("L" + signature.substring(consumed_chars + 1), chopit));
                            consumed_chars = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                            Utility.wrap(Utility.consumed_chars, consumed_chars);
                            return type.toString();
                        }
                        type.append(", ");
                        if (signature.charAt(consumed_chars) == '+') {
                            type.append("? extends ");
                            ++consumed_chars;
                        } else if (signature.charAt(consumed_chars) == '-') {
                            type.append("? super ");
                            ++consumed_chars;
                        }
                        if (signature.charAt(consumed_chars) == '*') {
                            type.append("?");
                            ++consumed_chars;
                            continue;
                        }
                        type.append(Utility.typeSignatureToString(signature.substring(consumed_chars), chopit));
                        consumed_chars = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                        Utility.wrap(Utility.consumed_chars, consumed_chars);
                    }
                    if (signature.charAt(consumed_chars) != ';') {
                        throw new ClassFormatException("Invalid signature: " + signature);
                    }
                    Utility.wrap(Utility.consumed_chars, consumed_chars + 1);
                    return type.toString();
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuilder brackets = new StringBuilder();
                    int n = 0;
                    while (true) {
                        if (signature.charAt(n) != '[') {
                            int consumed_chars = n;
                            String type = Utility.typeSignatureToString(signature.substring(n), chopit);
                            int _temp = Utility.unwrap(Utility.consumed_chars) + consumed_chars;
                            Utility.wrap(Utility.consumed_chars, _temp);
                            return String.valueOf(type) + brackets.toString();
                        }
                        brackets.append("[]");
                        ++n;
                    }
                }
                case 'V': {
                    return "void";
                }
            }
            throw new ClassFormatException("Invalid signature: `" + signature + "'");
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid signature: " + signature, e);
        }
    }

    public static String getSignature(String type) {
        StringBuilder buf = new StringBuilder();
        char[] chars = type.toCharArray();
        boolean char_found = false;
        boolean delim = false;
        int index = -1;
        int i = 0;
        block4: while (i < chars.length) {
            switch (chars[i]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!char_found) break;
                    delim = true;
                    break;
                }
                case '[': {
                    if (!char_found) {
                        throw new IllegalArgumentException("Illegal type: " + type);
                    }
                    index = i;
                    break block4;
                }
                default: {
                    char_found = true;
                    if (delim) break;
                    buf.append(chars[i]);
                }
            }
            ++i;
        }
        int brackets = 0;
        if (index > 0) {
            brackets = Utility.countBrackets(type.substring(index));
        }
        type = buf.toString();
        buf.setLength(0);
        int i2 = 0;
        while (i2 < brackets) {
            buf.append('[');
            ++i2;
        }
        boolean found = false;
        int i3 = 4;
        while (i3 <= 12 && !found) {
            if (Const.getTypeName(i3).equals(type)) {
                found = true;
                buf.append(Const.getShortTypeName(i3));
            }
            ++i3;
        }
        if (!found) {
            buf.append('L').append(type.replace('.', '/')).append(';');
        }
        return buf.toString();
    }

    private static int countBrackets(String brackets) {
        char[] chars = brackets.toCharArray();
        int count = 0;
        boolean open = false;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '[': {
                    if (open) {
                        throw new IllegalArgumentException("Illegally nested brackets:" + brackets);
                    }
                    open = true;
                    break;
                }
                case ']': {
                    if (!open) {
                        throw new IllegalArgumentException("Illegally nested brackets:" + brackets);
                    }
                    open = false;
                    ++count;
                    break;
                }
            }
            ++n2;
        }
        if (open) {
            throw new IllegalArgumentException("Illegally nested brackets:" + brackets);
        }
        return count;
    }

    public static byte typeOfMethodSignature(String signature) throws ClassFormatException {
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = signature.lastIndexOf(41) + 1;
            return Utility.typeOfSignature(signature.substring(index));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte typeOfSignature(String signature) throws ClassFormatException {
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return 8;
                }
                case 'C': {
                    return 5;
                }
                case 'D': {
                    return 7;
                }
                case 'F': {
                    return 6;
                }
                case 'I': {
                    return 10;
                }
                case 'J': {
                    return 11;
                }
                case 'L': 
                case 'T': {
                    return 14;
                }
                case '[': {
                    return 13;
                }
                case 'V': {
                    return 12;
                }
                case 'Z': {
                    return 4;
                }
                case 'S': {
                    return 9;
                }
                case '!': 
                case '*': 
                case '+': {
                    return Utility.typeOfSignature(signature.substring(1));
                }
            }
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
    }

    public static short searchOpcode(String name) {
        name = name.toLowerCase(Locale.ENGLISH);
        short i = 0;
        while (i < Const.OPCODE_NAMES_LENGTH) {
            if (Const.getOpcodeName(i).equals(name)) {
                return i;
            }
            i = (short)(i + 1);
        }
        return -1;
    }

    private static short byteToShort(byte b) {
        return b < 0 ? (short)(256 + b) : (short)b;
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            short b = Utility.byteToShort(bytes[i]);
            String hex = Integer.toHexString(b);
            if (b < 16) {
                buf.append('0');
            }
            buf.append(hex);
            if (i < bytes.length - 1) {
                buf.append(' ');
            }
            ++i;
        }
        return buf.toString();
    }

    public static String format(int i, int length, boolean left_justify, char fill) {
        return Utility.fillup(Integer.toString(i), length, left_justify, fill);
    }

    public static String fillup(String str, int length, boolean left_justify, char fill) {
        int len = length - str.length();
        char[] buf = new char[len < 0 ? 0 : len];
        int j = 0;
        while (j < buf.length) {
            buf[j] = fill;
            ++j;
        }
        if (left_justify) {
            return String.valueOf(str) + new String(buf);
        }
        return String.valueOf(new String(buf)) + str;
    }

    static boolean equals(byte[] a, byte[] b) {
        int size = a.length;
        if (size != b.length) {
            return false;
        }
        int i = 0;
        while (i < size) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void printArray(PrintStream out, Object[] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static void printArray(PrintWriter out, Object[] obj) {
        out.println(Utility.printArray(obj, true));
    }

    public static String printArray(Object[] obj) {
        return Utility.printArray(obj, true);
    }

    public static String printArray(Object[] obj, boolean braces) {
        return Utility.printArray(obj, braces, false);
    }

    public static String printArray(Object[] obj, boolean braces, boolean quote) {
        if (obj == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (braces) {
            buf.append('{');
        }
        int i = 0;
        while (i < obj.length) {
            if (obj[i] != null) {
                buf.append(quote ? "\"" : "").append(obj[i]).append(quote ? "\"" : "");
            } else {
                buf.append("null");
            }
            if (i < obj.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        if (braces) {
            buf.append('}');
        }
        return buf.toString();
    }

    public static boolean isJavaIdentifierPart(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_';
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encode(byte[] bytes, boolean compress) throws IOException {
        Throwable throwable;
        block23: {
            if (compress) {
                Throwable throwable2 = null;
                throwable = null;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        try (GZIPOutputStream gos = new GZIPOutputStream(baos);){
                            gos.write(bytes, 0, bytes.length);
                            bytes = baos.toByteArray();
                        }
                        if (baos == null) break block23;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        if (baos == null) throw throwable2;
                        baos.close();
                        throw throwable2;
                    }
                    baos.close();
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
        }
        CharArrayWriter caw = new CharArrayWriter();
        throwable = null;
        Object var4_8 = null;
        try (JavaWriter jw = new JavaWriter(caw);){
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return caw.toString();
                }
                byte b = byArray[n2];
                int in = b & 0xFF;
                jw.write(in);
                ++n2;
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decode(String s, boolean uncompress) throws IOException {
        byte[] bytes;
        block17: {
            Throwable throwable = null;
            Object var4_4 = null;
            try {
                JavaReader jr = new JavaReader(new CharArrayReader(s.toCharArray()));
                try {
                    try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                        while (true) {
                            int ch;
                            if ((ch = jr.read()) < 0) {
                                bytes = bos.toByteArray();
                                break;
                            }
                            bos.write(ch);
                        }
                    }
                    if (jr == null) break block17;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (jr == null) throw throwable;
                    jr.close();
                    throw throwable;
                }
                jr.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        if (!uncompress) return bytes;
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(bytes));
        byte[] tmp = new byte[bytes.length * 3];
        int count = 0;
        while (true) {
            int b;
            if ((b = gis.read()) < 0) {
                bytes = new byte[count];
                System.arraycopy(tmp, 0, bytes, 0, count);
                return bytes;
            }
            tmp[count++] = (byte)b;
        }
    }

    public static String convertString(String label) {
        char[] ch = label.toCharArray();
        StringBuilder buf = new StringBuilder();
        char[] cArray = ch;
        int n = ch.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            switch (element) {
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\'': {
                    buf.append("\\'");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                default: {
                    buf.append(element);
                }
            }
            ++n2;
        }
        return buf.toString();
    }

    private static class JavaReader
    extends FilterReader {
        public JavaReader(Reader in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b != 36) {
                return b;
            }
            int i = this.in.read();
            if (i < 0) {
                return -1;
            }
            if (i >= 48 && i <= 57 || i >= 97 && i <= 102) {
                int j = this.in.read();
                if (j < 0) {
                    return -1;
                }
                char[] tmp = new char[]{(char)i, (char)j};
                int s = Integer.parseInt(new String(tmp), 16);
                return s;
            }
            return MAP_CHAR[i];
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int i = 0;
            while (i < len) {
                cbuf[off + i] = (char)this.read();
                ++i;
            }
            return len;
        }
    }

    private static class JavaWriter
    extends FilterWriter {
        public JavaWriter(Writer out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            if (Utility.isJavaIdentifierPart((char)b) && b != 36) {
                this.out.write(b);
            } else {
                this.out.write(36);
                if (b >= 0 && b < 48) {
                    this.out.write(CHAR_MAP[b]);
                } else {
                    char[] tmp = Integer.toHexString(b).toCharArray();
                    if (tmp.length == 1) {
                        this.out.write(48);
                        this.out.write(tmp[0]);
                    } else {
                        this.out.write(tmp[0]);
                        this.out.write(tmp[1]);
                    }
                }
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            int i = 0;
            while (i < len) {
                this.write(cbuf[off + i]);
                ++i;
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), off, len);
        }
    }
}

