/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.RuntimeInvisibleAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleAnnotations;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.generic.AnnotationEntryGen;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ClassObserver;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.InstructionConst;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELComparator;

public class ClassGen
extends AccessFlags
implements Cloneable {
    private String className;
    private String superClassName;
    private final String fileName;
    private int classNameIndex = -1;
    private int superclass_name_index = -1;
    private int major = 45;
    private int minor = 3;
    private ConstantPoolGen cp;
    private final List<Field> fieldList = new ArrayList<Field>();
    private final List<Method> methodList = new ArrayList<Method>();
    private final List<Attribute> attributeList = new ArrayList<Attribute>();
    private final List<String> interfaceList = new ArrayList<String>();
    private final List<AnnotationEntryGen> annotationList = new ArrayList<AnnotationEntryGen>();
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            ClassGen THIS = (ClassGen)o1;
            ClassGen THAT = (ClassGen)o2;
            return Objects.equals(THIS.getClassName(), THAT.getClassName());
        }

        @Override
        public int hashCode(Object o) {
            ClassGen THIS = (ClassGen)o;
            return THIS.getClassName().hashCode();
        }
    };
    private List<ClassObserver> observers;

    public ClassGen(String className, String superClassName, String fileName, int accessFlags, String[] interfaces, ConstantPoolGen cp) {
        super(accessFlags);
        this.className = className;
        this.superClassName = superClassName;
        this.fileName = fileName;
        this.cp = cp;
        if (fileName != null) {
            this.addAttribute(new SourceFile(cp.addUtf8("SourceFile"), 2, cp.addUtf8(fileName), cp.getConstantPool()));
        }
        this.classNameIndex = cp.addClass(className);
        this.superclass_name_index = cp.addClass(superClassName);
        if (interfaces != null) {
            String[] stringArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                String interface1 = stringArray[n2];
                this.addInterface(interface1);
                ++n2;
            }
        }
    }

    public ClassGen(String className, String superClassName, String fileName, int accessFlags, String[] interfaces) {
        this(className, superClassName, fileName, accessFlags, interfaces, new ConstantPoolGen());
    }

    public ClassGen(JavaClass clazz) {
        super(clazz.getAccessFlags());
        this.classNameIndex = clazz.getClassNameIndex();
        this.superclass_name_index = clazz.getSuperclassNameIndex();
        this.className = clazz.getClassName();
        this.superClassName = clazz.getSuperclassName();
        this.fileName = clazz.getSourceFileName();
        this.cp = new ConstantPoolGen(clazz.getConstantPool());
        this.major = clazz.getMajor();
        this.minor = clazz.getMinor();
        Attribute[] attributes = clazz.getAttributes();
        AnnotationEntryGen[] annotations = this.unpackAnnotations(attributes);
        Method[] methods = clazz.getMethods();
        Field[] fields = clazz.getFields();
        String[] interfaces = clazz.getInterfaceNames();
        Object[] objectArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            String interface1 = objectArray[n2];
            this.addInterface(interface1);
            ++n2;
        }
        objectArray = attributes;
        n = attributes.length;
        n2 = 0;
        while (n2 < n) {
            Object attribute = objectArray[n2];
            if (!(attribute instanceof Annotations)) {
                this.addAttribute((Attribute)attribute);
            }
            ++n2;
        }
        objectArray = annotations;
        n = annotations.length;
        n2 = 0;
        while (n2 < n) {
            Object annotation = objectArray[n2];
            this.addAnnotationEntry((AnnotationEntryGen)annotation);
            ++n2;
        }
        objectArray = methods;
        n = methods.length;
        n2 = 0;
        while (n2 < n) {
            Object method = objectArray[n2];
            this.addMethod((Method)method);
            ++n2;
        }
        objectArray = fields;
        n = fields.length;
        n2 = 0;
        while (n2 < n) {
            Object field = objectArray[n2];
            this.addField((Field)field);
            ++n2;
        }
    }

    private AnnotationEntryGen[] unpackAnnotations(Attribute[] attrs) {
        ArrayList<AnnotationEntryGen> annotationGenObjs = new ArrayList<AnnotationEntryGen>();
        Attribute[] attributeArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            if (attr instanceof RuntimeVisibleAnnotations) {
                RuntimeVisibleAnnotations rva = (RuntimeVisibleAnnotations)attr;
                var12_12 = annos = rva.getAnnotationEntries();
                var11_11 = annos.length;
                var10_10 = 0;
                while (var10_10 < var11_11) {
                    a = var12_12[var10_10];
                    annotationGenObjs.add(new AnnotationEntryGen(a, this.getConstantPool(), false));
                    ++var10_10;
                }
            } else if (attr instanceof RuntimeInvisibleAnnotations) {
                RuntimeInvisibleAnnotations ria = (RuntimeInvisibleAnnotations)attr;
                var12_12 = annos = ria.getAnnotationEntries();
                var11_11 = annos.length;
                var10_10 = 0;
                while (var10_10 < var11_11) {
                    a = var12_12[var10_10];
                    annotationGenObjs.add(new AnnotationEntryGen(a, this.getConstantPool(), false));
                    ++var10_10;
                }
            }
            ++n2;
        }
        return annotationGenObjs.toArray(new AnnotationEntryGen[annotationGenObjs.size()]);
    }

    public JavaClass getJavaClass() {
        int[] interfaces = this.getInterfaces();
        Field[] fields = this.getFields();
        Method[] methods = this.getMethods();
        Attribute[] attributes = null;
        if (this.annotationList.isEmpty()) {
            attributes = this.getAttributes();
        } else {
            Attribute[] annAttributes = AnnotationEntryGen.getAnnotationAttributes(this.cp, this.getAnnotationEntries());
            attributes = new Attribute[this.attributeList.size() + annAttributes.length];
            this.attributeList.toArray(attributes);
            System.arraycopy(annAttributes, 0, attributes, this.attributeList.size(), annAttributes.length);
        }
        ConstantPool _cp = this.cp.getFinalConstantPool();
        return new JavaClass(this.classNameIndex, this.superclass_name_index, this.fileName, this.major, this.minor, super.getAccessFlags(), _cp, interfaces, fields, methods, attributes);
    }

    public void addInterface(String name) {
        this.interfaceList.add(name);
    }

    public void removeInterface(String name) {
        this.interfaceList.remove(name);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMinor() {
        return this.minor;
    }

    public void addAttribute(Attribute a) {
        this.attributeList.add(a);
    }

    public void addAnnotationEntry(AnnotationEntryGen a) {
        this.annotationList.add(a);
    }

    public void addMethod(Method m) {
        this.methodList.add(m);
    }

    public void addEmptyConstructor(int access_flags) {
        InstructionList il = new InstructionList();
        il.append(InstructionConst.THIS);
        il.append(new INVOKESPECIAL(this.cp.addMethodref(this.superClassName, "<init>", "()V")));
        il.append(InstructionConst.RETURN);
        MethodGen mg = new MethodGen(access_flags, Type.VOID, Type.NO_ARGS, null, "<init>", this.className, il, this.cp);
        mg.setMaxStack(1);
        this.addMethod(mg.getMethod());
    }

    public void addField(Field f) {
        this.fieldList.add(f);
    }

    public boolean containsField(Field f) {
        return this.fieldList.contains(f);
    }

    public Field containsField(String name) {
        for (Field f : this.fieldList) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public Method containsMethod(String name, String signature) {
        for (Method m : this.methodList) {
            if (!m.getName().equals(name) || !m.getSignature().equals(signature)) continue;
            return m;
        }
        return null;
    }

    public void removeAttribute(Attribute a) {
        this.attributeList.remove(a);
    }

    public void removeMethod(Method m) {
        this.methodList.remove(m);
    }

    public void replaceMethod(Method old, Method new_) {
        if (new_ == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int i = this.methodList.indexOf(old);
        if (i < 0) {
            this.methodList.add(new_);
        } else {
            this.methodList.set(i, new_);
        }
    }

    public void replaceField(Field old, Field new_) {
        if (new_ == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int i = this.fieldList.indexOf(old);
        if (i < 0) {
            this.fieldList.add(new_);
        } else {
            this.fieldList.set(i, new_);
        }
    }

    public void removeField(Field f) {
        this.fieldList.remove(f);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperclassName() {
        return this.superClassName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setClassName(String name) {
        this.className = name.replace('/', '.');
        this.classNameIndex = this.cp.addClass(name);
    }

    public void setSuperclassName(String name) {
        this.superClassName = name.replace('/', '.');
        this.superclass_name_index = this.cp.addClass(name);
    }

    public Method[] getMethods() {
        return this.methodList.toArray(new Method[this.methodList.size()]);
    }

    public void setMethods(Method[] methods) {
        this.methodList.clear();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            this.addMethod(method);
            ++n2;
        }
    }

    public void setMethodAt(Method method, int pos) {
        this.methodList.set(pos, method);
    }

    public Method getMethodAt(int pos) {
        return this.methodList.get(pos);
    }

    public String[] getInterfaceNames() {
        int size = this.interfaceList.size();
        String[] interfaces = new String[size];
        this.interfaceList.toArray(interfaces);
        return interfaces;
    }

    public int[] getInterfaces() {
        int size = this.interfaceList.size();
        int[] interfaces = new int[size];
        int i = 0;
        while (i < size) {
            interfaces[i] = this.cp.addClass(this.interfaceList.get(i));
            ++i;
        }
        return interfaces;
    }

    public Field[] getFields() {
        return this.fieldList.toArray(new Field[this.fieldList.size()]);
    }

    public Attribute[] getAttributes() {
        return this.attributeList.toArray(new Attribute[this.attributeList.size()]);
    }

    public AnnotationEntryGen[] getAnnotationEntries() {
        return this.annotationList.toArray(new AnnotationEntryGen[this.annotationList.size()]);
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(ConstantPoolGen constant_pool) {
        this.cp = constant_pool;
    }

    public void setClassNameIndex(int class_name_index) {
        this.classNameIndex = class_name_index;
        this.className = this.cp.getConstantPool().getConstantString(class_name_index, (byte)7).replace('/', '.');
    }

    public void setSuperclassNameIndex(int superclass_name_index) {
        this.superclass_name_index = superclass_name_index;
        this.superClassName = this.cp.getConstantPool().getConstantString(superclass_name_index, (byte)7).replace('/', '.');
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public int getClassNameIndex() {
        return this.classNameIndex;
    }

    public void addObserver(ClassObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList<ClassObserver>();
        }
        this.observers.add(o);
    }

    public void removeObserver(ClassObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (ClassObserver observer : this.observers) {
                observer.notify(this);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator comparator) {
        bcelComparator = comparator;
    }

    public boolean equals(Object obj) {
        return bcelComparator.equals(this, obj);
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

