/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.Objects;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionTargeter;

public class LineNumberGen
implements InstructionTargeter,
Cloneable {
    private InstructionHandle ih;
    private int srcLine;

    public LineNumberGen(InstructionHandle ih, int src_line) {
        this.setInstruction(ih);
        this.setSourceLine(src_line);
    }

    @Override
    public boolean containsTarget(InstructionHandle ih) {
        return this.ih == ih;
    }

    @Override
    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        if (old_ih != this.ih) {
            throw new ClassGenException("Not targeting " + old_ih + ", but " + this.ih + "}");
        }
        this.setInstruction(new_ih);
    }

    public LineNumber getLineNumber() {
        return new LineNumber(this.ih.getPosition(), this.srcLine);
    }

    public void setInstruction(InstructionHandle instructionHandle) {
        Objects.requireNonNull(instructionHandle, "instructionHandle");
        BranchInstruction.notifyTarget(this.ih, instructionHandle, this);
        this.ih = instructionHandle;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
    }

    public InstructionHandle getInstruction() {
        return this.ih;
    }

    public void setSourceLine(int src_line) {
        this.srcLine = src_line;
    }

    public int getSourceLine() {
        return this.srcLine;
    }
}

