/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.LocalVariableTypeTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleParameterAnnotations;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.AnnotationEntryGen;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGenOrMethodGen;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodObserver;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.util.BCELComparator;

public class MethodGen
extends FieldGenOrMethodGen {
    private String className;
    private Type[] argTypes;
    private String[] argNames;
    private int maxLocals;
    private int maxStack;
    private InstructionList il;
    private boolean stripAttributes;
    private LocalVariableTypeTable localVariableTypeTable = null;
    private final List<LocalVariableGen> variableList = new ArrayList<LocalVariableGen>();
    private final List<LineNumberGen> lineNumberList = new ArrayList<LineNumberGen>();
    private final List<CodeExceptionGen> exceptionList = new ArrayList<CodeExceptionGen>();
    private final List<String> throwsList = new ArrayList<String>();
    private final List<Attribute> codeAttrsList = new ArrayList<Attribute>();
    private List<AnnotationEntryGen>[] paramAnnotations;
    private boolean hasParameterAnnotations = false;
    private boolean haveUnpackedParameterAnnotations = false;
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            MethodGen THIS = (MethodGen)o1;
            MethodGen THAT = (MethodGen)o2;
            return Objects.equals(THIS.getName(), THAT.getName()) && Objects.equals(THIS.getSignature(), THAT.getSignature());
        }

        @Override
        public int hashCode(Object o) {
            MethodGen THIS = (MethodGen)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };
    private List<MethodObserver> observers;

    public MethodGen(int access_flags, Type return_type, Type[] argTypes, String[] argNames, String method_name, String className, InstructionList il, ConstantPoolGen cp) {
        super(access_flags);
        this.setType(return_type);
        this.setArgumentTypes(argTypes);
        this.setArgumentNames(argNames);
        this.setName(method_name);
        this.setClassName(className);
        this.setInstructionList(il);
        this.setConstantPool(cp);
        boolean abstract_ = this.isAbstract() || this.isNative();
        InstructionHandle start = null;
        InstructionHandle end = null;
        if (!abstract_) {
            start = il.getStart();
            if (!this.isStatic() && className != null) {
                this.addLocalVariable("this", ObjectType.getInstance(className), start, end);
            }
        }
        if (argTypes != null) {
            int size = argTypes.length;
            Type[] typeArray = argTypes;
            int n = argTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Type arg_type = typeArray[n2];
                if (Type.VOID == arg_type) {
                    throw new ClassGenException("'void' is an illegal argument type for a method");
                }
                ++n2;
            }
            if (argNames != null) {
                if (size != argNames.length) {
                    throw new ClassGenException("Mismatch in argument array lengths: " + size + " vs. " + argNames.length);
                }
            } else {
                argNames = new String[size];
                int i = 0;
                while (i < size) {
                    argNames[i] = "arg" + i;
                    ++i;
                }
                this.setArgumentNames(argNames);
            }
            if (!abstract_) {
                int i = 0;
                while (i < size) {
                    this.addLocalVariable(argNames[i], argTypes[i], start, end);
                    ++i;
                }
            }
        }
    }

    public MethodGen(Method method, String className, ConstantPoolGen cp) {
        this(method.getAccessFlags(), Type.getReturnType(method.getSignature()), Type.getArgumentTypes(method.getSignature()), null, method.getName(), className, (method.getAccessFlags() & 0x500) == 0 ? new InstructionList(MethodGen.getByteCodes(method)) : null, cp);
        Attribute[] attributes;
        Attribute[] attributeArray = attributes = method.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            Attribute a = attribute;
            if (a instanceof Code) {
                Attribute[] c_attributes;
                int n3;
                Code c = (Code)a;
                this.setMaxStack(c.getMaxStack());
                this.setMaxLocals(c.getMaxLocals());
                CodeException[] ces = c.getExceptionTable();
                if (ces != null) {
                    CodeException[] codeExceptionArray = ces;
                    n3 = ces.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        InstructionHandle end;
                        CodeException ce = codeExceptionArray[n4];
                        int type = ce.getCatchType();
                        ObjectType c_type = null;
                        if (type > 0) {
                            String cen = method.getConstantPool().getConstantString(type, (byte)7);
                            c_type = ObjectType.getInstance(cen);
                        }
                        int end_pc = ce.getEndPC();
                        int length = MethodGen.getByteCodes(method).length;
                        if (length == end_pc) {
                            end = this.il.getEnd();
                        } else {
                            end = this.il.findHandle(end_pc);
                            end = end.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(ce.getStartPC()), end, this.il.findHandle(ce.getHandlerPC()), c_type);
                        ++n4;
                    }
                }
                Attribute[] attributeArray2 = c_attributes = c.getAttributes();
                int n5 = c_attributes.length;
                n3 = 0;
                while (n3 < n5) {
                    Attribute c_attribute = attributeArray2[n3];
                    a = c_attribute;
                    if (a instanceof LineNumberTable) {
                        LineNumber[] ln;
                        LineNumber[] lineNumberArray = ln = ((LineNumberTable)a).getLineNumberTable();
                        int n6 = ln.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            LineNumber l = lineNumberArray[n7];
                            InstructionHandle ih = this.il.findHandle(l.getStartPC());
                            if (ih != null) {
                                this.addLineNumber(ih, l.getLineNumber());
                            }
                            ++n7;
                        }
                    } else if (a instanceof LocalVariableTable) {
                        this.updateLocalVariableTable((LocalVariableTable)a);
                    } else if (a instanceof LocalVariableTypeTable) {
                        this.localVariableTypeTable = (LocalVariableTypeTable)a.copy(cp.getConstantPool());
                    } else {
                        this.addCodeAttribute(a);
                    }
                    ++n3;
                }
            } else if (a instanceof ExceptionTable) {
                String[] names;
                String[] stringArray = names = ((ExceptionTable)a).getExceptionNames();
                int n8 = names.length;
                int c_attributes = 0;
                while (c_attributes < n8) {
                    String name2 = stringArray[c_attributes];
                    this.addException(name2);
                    ++c_attributes;
                }
            } else if (a instanceof Annotations) {
                AnnotationEntry[] aes;
                Annotations runtimeAnnotations = (Annotations)a;
                AnnotationEntry[] annotationEntryArray = aes = runtimeAnnotations.getAnnotationEntries();
                int n9 = aes.length;
                int n10 = 0;
                while (n10 < n9) {
                    AnnotationEntry element = annotationEntryArray[n10];
                    this.addAnnotationEntry(new AnnotationEntryGen(element, cp, false));
                    ++n10;
                }
            } else {
                this.addAttribute(a);
            }
            ++n2;
        }
    }

    private static byte[] getByteCodes(Method method) {
        Code code = method.getCode();
        if (code == null) {
            throw new IllegalStateException(String.format("The method '%s' has no code.", method));
        }
        return code.getCode();
    }

    public LocalVariableGen addLocalVariable(String name, Type type, int slot, InstructionHandle start, InstructionHandle end, int orig_index) {
        byte t = type.getType();
        if (t != 16) {
            LocalVariableGen l;
            int i;
            int add = type.getSize();
            if (slot + add > this.maxLocals) {
                this.maxLocals = slot + add;
            }
            if ((i = this.variableList.indexOf(l = new LocalVariableGen(slot, name, type, start, end, orig_index))) >= 0) {
                this.variableList.set(i, l);
            } else {
                this.variableList.add(l);
            }
            return l;
        }
        throw new IllegalArgumentException("Can not use " + type + " as type for local variable");
    }

    public LocalVariableGen addLocalVariable(String name, Type type, int slot, InstructionHandle start, InstructionHandle end) {
        return this.addLocalVariable(name, type, slot, start, end, slot);
    }

    public LocalVariableGen addLocalVariable(String name, Type type, InstructionHandle start, InstructionHandle end) {
        return this.addLocalVariable(name, type, this.maxLocals, start, end);
    }

    public void removeLocalVariable(LocalVariableGen l) {
        l.dispose();
        this.variableList.remove(l);
    }

    public void removeLocalVariables() {
        for (LocalVariableGen lv : this.variableList) {
            lv.dispose();
        }
        this.variableList.clear();
    }

    public LocalVariableGen[] getLocalVariables() {
        int size = this.variableList.size();
        LocalVariableGen[] lg = new LocalVariableGen[size];
        this.variableList.toArray(lg);
        int i = 0;
        while (i < size) {
            if (lg[i].getStart() == null && this.il != null) {
                lg[i].setStart(this.il.getStart());
            }
            if (lg[i].getEnd() == null && this.il != null) {
                lg[i].setEnd(this.il.getEnd());
            }
            ++i;
        }
        if (size > 1) {
            Arrays.sort(lg, (o1, o2) -> o1.getIndex() - o2.getIndex());
        }
        return lg;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPoolGen cp) {
        LocalVariableGen[] lg = this.getLocalVariables();
        int size = lg.length;
        LocalVariable[] lv = new LocalVariable[size];
        int i = 0;
        while (i < size) {
            lv[i] = lg[i].getLocalVariable(cp);
            ++i;
        }
        return new LocalVariableTable(cp.addUtf8("LocalVariableTable"), 2 + lv.length * 10, lv, cp.getConstantPool());
    }

    public LocalVariableTypeTable getLocalVariableTypeTable() {
        return this.localVariableTypeTable;
    }

    public LineNumberGen addLineNumber(InstructionHandle ih, int srcLine) {
        LineNumberGen l = new LineNumberGen(ih, srcLine);
        this.lineNumberList.add(l);
        return l;
    }

    public void removeLineNumber(LineNumberGen l) {
        this.lineNumberList.remove(l);
    }

    public void removeLineNumbers() {
        this.lineNumberList.clear();
    }

    public LineNumberGen[] getLineNumbers() {
        LineNumberGen[] lg = new LineNumberGen[this.lineNumberList.size()];
        this.lineNumberList.toArray(lg);
        return lg;
    }

    public LineNumberTable getLineNumberTable(ConstantPoolGen cp) {
        int size = this.lineNumberList.size();
        LineNumber[] ln = new LineNumber[size];
        int i = 0;
        while (i < size) {
            ln[i] = this.lineNumberList.get(i).getLineNumber();
            ++i;
        }
        return new LineNumberTable(cp.addUtf8("LineNumberTable"), 2 + ln.length * 4, ln, cp.getConstantPool());
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle start_pc, InstructionHandle end_pc, InstructionHandle handler_pc, ObjectType catch_type) {
        if (start_pc == null || end_pc == null || handler_pc == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen c = new CodeExceptionGen(start_pc, end_pc, handler_pc, catch_type);
        this.exceptionList.add(c);
        return c;
    }

    public void removeExceptionHandler(CodeExceptionGen c) {
        this.exceptionList.remove(c);
    }

    public void removeExceptionHandlers() {
        this.exceptionList.clear();
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        CodeExceptionGen[] cg = new CodeExceptionGen[this.exceptionList.size()];
        this.exceptionList.toArray(cg);
        return cg;
    }

    private CodeException[] getCodeExceptions() {
        int size = this.exceptionList.size();
        CodeException[] c_exc = new CodeException[size];
        int i = 0;
        while (i < size) {
            CodeExceptionGen c = this.exceptionList.get(i);
            c_exc[i] = c.getCodeException(super.getConstantPool());
            ++i;
        }
        return c_exc;
    }

    public void addException(String className) {
        this.throwsList.add(className);
    }

    public void removeException(String c) {
        this.throwsList.remove(c);
    }

    public void removeExceptions() {
        this.throwsList.clear();
    }

    public String[] getExceptions() {
        String[] e = new String[this.throwsList.size()];
        this.throwsList.toArray(e);
        return e;
    }

    private ExceptionTable getExceptionTable(ConstantPoolGen cp) {
        int size = this.throwsList.size();
        int[] ex = new int[size];
        int i = 0;
        while (i < size) {
            ex[i] = cp.addClass(this.throwsList.get(i));
            ++i;
        }
        return new ExceptionTable(cp.addUtf8("Exceptions"), 2 + 2 * size, ex, cp.getConstantPool());
    }

    public void addCodeAttribute(Attribute a) {
        this.codeAttrsList.add(a);
    }

    public void removeLocalVariableTypeTable() {
        this.localVariableTypeTable = null;
    }

    public void removeCodeAttribute(Attribute a) {
        this.codeAttrsList.remove(a);
    }

    public void removeCodeAttributes() {
        this.localVariableTypeTable = null;
        this.codeAttrsList.clear();
    }

    public Attribute[] getCodeAttributes() {
        Attribute[] attributes = new Attribute[this.codeAttrsList.size()];
        this.codeAttrsList.toArray(attributes);
        return attributes;
    }

    public void addAnnotationsAsAttribute(ConstantPoolGen cp) {
        Attribute[] attrs;
        Attribute[] attributeArray = attrs = AnnotationEntryGen.getAnnotationAttributes(cp, super.getAnnotationEntries());
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            this.addAttribute(attr);
            ++n2;
        }
    }

    public void addParameterAnnotationsAsAttribute(ConstantPoolGen cp) {
        if (!this.hasParameterAnnotations) {
            return;
        }
        Attribute[] attrs = AnnotationEntryGen.getParameterAnnotationAttributes(cp, this.paramAnnotations);
        if (attrs != null) {
            Attribute[] attributeArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attr = attributeArray[n2];
                this.addAttribute(attr);
                ++n2;
            }
        }
    }

    private Attribute[] addRuntimeAnnotationsAsAttribute(ConstantPoolGen cp) {
        Attribute[] attrs;
        Attribute[] attributeArray = attrs = AnnotationEntryGen.getAnnotationAttributes(cp, super.getAnnotationEntries());
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            this.addAttribute(attr);
            ++n2;
        }
        return attrs;
    }

    private Attribute[] addRuntimeParameterAnnotationsAsAttribute(ConstantPoolGen cp) {
        Attribute[] attrs;
        if (!this.hasParameterAnnotations) {
            return new Attribute[0];
        }
        Attribute[] attributeArray = attrs = AnnotationEntryGen.getParameterAnnotationAttributes(cp, this.paramAnnotations);
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            this.addAttribute(attr);
            ++n2;
        }
        return attrs;
    }

    public void removeRuntimeAttributes(Attribute[] attrs) {
        Attribute[] attributeArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            this.removeAttribute(attr);
            ++n2;
        }
    }

    public Method getMethod() {
        String signature = this.getSignature();
        ConstantPoolGen _cp = super.getConstantPool();
        int name_index = _cp.addUtf8(super.getName());
        int signature_index = _cp.addUtf8(signature);
        byte[] byte_code = null;
        if (this.il != null) {
            byte_code = this.il.getByteCode();
        }
        LineNumberTable lnt = null;
        LocalVariableTable lvt = null;
        if (this.variableList.size() > 0 && !this.stripAttributes) {
            this.updateLocalVariableTable(this.getLocalVariableTable(_cp));
            lvt = this.getLocalVariableTable(_cp);
            this.addCodeAttribute(lvt);
        }
        if (this.localVariableTypeTable != null) {
            if (lvt != null) {
                this.adjustLocalVariableTypeTable(lvt);
            }
            this.addCodeAttribute(this.localVariableTypeTable);
        }
        if (this.lineNumberList.size() > 0 && !this.stripAttributes) {
            lnt = this.getLineNumberTable(_cp);
            this.addCodeAttribute(lnt);
        }
        Attribute[] code_attrs = this.getCodeAttributes();
        int attrs_len = 0;
        Attribute[] attributeArray = code_attrs;
        int n = code_attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute code_attr = attributeArray[n2];
            attrs_len += code_attr.getLength() + 6;
            ++n2;
        }
        CodeException[] c_exc = this.getCodeExceptions();
        int exc_len = c_exc.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract() && !this.isNative()) {
            Attribute[] attributes;
            Attribute[] attributeArray2 = attributes = this.getAttributes();
            int n3 = attributes.length;
            int n4 = 0;
            while (n4 < n3) {
                Attribute a = attributeArray2[n4];
                if (a instanceof Code) {
                    this.removeAttribute(a);
                }
                ++n4;
            }
            code = new Code(_cp.addUtf8("Code"), 8 + byte_code.length + 2 + exc_len + 2 + attrs_len, this.maxStack, this.maxLocals, byte_code, c_exc, code_attrs, _cp.getConstantPool());
            this.addAttribute(code);
        }
        Attribute[] annotations = this.addRuntimeAnnotationsAsAttribute(_cp);
        Attribute[] parameterAnnotations = this.addRuntimeParameterAnnotationsAsAttribute(_cp);
        ExceptionTable et = null;
        if (this.throwsList.size() > 0) {
            et = this.getExceptionTable(_cp);
            this.addAttribute(et);
        }
        Method m = new Method(super.getAccessFlags(), name_index, signature_index, this.getAttributes(), _cp.getConstantPool());
        if (lvt != null) {
            this.removeCodeAttribute(lvt);
        }
        if (this.localVariableTypeTable != null) {
            this.removeCodeAttribute(this.localVariableTypeTable);
        }
        if (lnt != null) {
            this.removeCodeAttribute(lnt);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (et != null) {
            this.removeAttribute(et);
        }
        this.removeRuntimeAttributes(annotations);
        this.removeRuntimeAttributes(parameterAnnotations);
        return m;
    }

    private void updateLocalVariableTable(LocalVariableTable a) {
        LocalVariable[] lv = a.getLocalVariableTable();
        this.removeLocalVariables();
        LocalVariable[] localVariableArray = lv;
        int n = lv.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable l = localVariableArray[n2];
            InstructionHandle start = this.il.findHandle(l.getStartPC());
            InstructionHandle end = this.il.findHandle(l.getStartPC() + l.getLength());
            if (start == null) {
                start = this.il.getStart();
            }
            this.addLocalVariable(l.getName(), Type.getType(l.getSignature()), l.getIndex(), start, end, l.getOrigIndex());
            ++n2;
        }
    }

    private void adjustLocalVariableTypeTable(LocalVariableTable lvt) {
        LocalVariable[] lvg;
        LocalVariable[] lv = lvt.getLocalVariableTable();
        LocalVariable[] localVariableArray = lvg = this.localVariableTypeTable.getLocalVariableTypeTable();
        int n = lvg.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable element = localVariableArray[n2];
            LocalVariable[] localVariableArray2 = lv;
            int n3 = lv.length;
            int n4 = 0;
            while (n4 < n3) {
                LocalVariable l = localVariableArray2[n4];
                if (element.getName().equals(l.getName()) && element.getIndex() == l.getOrigIndex()) {
                    element.setLength(l.getLength());
                    element.setStartPC(l.getStartPC());
                    element.setIndex(l.getIndex());
                    break;
                }
                ++n4;
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void removeNOPs() {
        if (this.il != null) {
            ih = this.il.getStart();
            while (ih != null) {
                block7: {
                    next = ih.getNext();
                    if (next != null && ih.getInstruction() instanceof NOP) {
                        try {
                            this.il.delete(ih);
                            break block7;
                        }
                        catch (TargetLostException e) {
                            var7_7 = e.getTargets();
                            var6_6 = var7_7.length;
                            var5_5 = 0;
                            ** while (var5_5 < var6_6)
                        }
lbl-1000:
                        // 1 sources

                        {
                            target = var7_7[var5_5];
                            var11_11 = target.getTargeters();
                            var10_10 = var11_11.length;
                            var9_9 = 0;
                            while (var9_9 < var10_10) {
                                targeter = var11_11[var9_9];
                                targeter.updateTarget(target, next);
                                ++var9_9;
                            }
                            ++var5_5;
                            continue;
                        }
                    }
                }
                ih = next;
            }
        }
    }

    public void setMaxLocals(int m) {
        this.maxLocals = m;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxStack(int m) {
        this.maxStack = m;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String class_name) {
        this.className = class_name;
    }

    public void setReturnType(Type return_type) {
        this.setType(return_type);
    }

    public Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(Type[] arg_types) {
        this.argTypes = arg_types;
    }

    public Type[] getArgumentTypes() {
        return (Type[])this.argTypes.clone();
    }

    public void setArgumentType(int i, Type type) {
        this.argTypes[i] = type;
    }

    public Type getArgumentType(int i) {
        return this.argTypes[i];
    }

    public void setArgumentNames(String[] arg_names) {
        this.argNames = arg_names;
    }

    public String[] getArgumentNames() {
        return (String[])this.argNames.clone();
    }

    public void setArgumentName(int i, String name) {
        this.argNames[i] = name;
    }

    public String getArgumentName(int i) {
        return this.argNames[i];
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(InstructionList il) {
        this.il = il;
    }

    @Override
    public String getSignature() {
        return Type.getMethodSignature(super.getType(), this.argTypes);
    }

    public void setMaxStack() {
        this.maxStack = this.il != null ? MethodGen.getMaxStack(super.getConstantPool(), this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int max;
            int n = max = this.isStatic() ? 0 : 1;
            if (this.argTypes != null) {
                Type[] typeArray = this.argTypes;
                int n2 = this.argTypes.length;
                int n3 = 0;
                while (n3 < n2) {
                    Type arg_type = typeArray[n3];
                    max += arg_type.getSize();
                    ++n3;
                }
            }
            InstructionHandle ih = this.il.getStart();
            while (ih != null) {
                int index;
                Instruction ins = ih.getInstruction();
                if ((ins instanceof LocalVariableInstruction || ins instanceof RET || ins instanceof IINC) && (index = ((IndexedInstruction)((Object)ins)).getIndex() + ((TypedInstruction)((Object)ins)).getType(super.getConstantPool()).getSize()) > max) {
                    max = index;
                }
                ih = ih.getNext();
            }
            this.maxLocals = max;
        } else {
            this.maxLocals = 0;
        }
    }

    public void stripAttributes(boolean flag) {
        this.stripAttributes = flag;
    }

    public static int getMaxStack(ConstantPoolGen cp, InstructionList il, CodeExceptionGen[] et) {
        BranchStack branchTargets = new BranchStack();
        CodeExceptionGen[] codeExceptionGenArray = et;
        int n = et.length;
        int n2 = 0;
        while (n2 < n) {
            CodeExceptionGen element = codeExceptionGenArray[n2];
            InstructionHandle handler_pc = element.getHandlerPC();
            if (handler_pc != null) {
                branchTargets.push(handler_pc, 1);
            }
            ++n2;
        }
        int stackDepth = 0;
        int maxStackDepth = 0;
        InstructionHandle ih = il.getStart();
        while (ih != null) {
            BranchTarget bt;
            Instruction instruction = ih.getInstruction();
            short opcode = instruction.getOpcode();
            int delta = instruction.produceStack(cp) - instruction.consumeStack(cp);
            if ((stackDepth += delta) > maxStackDepth) {
                maxStackDepth = stackDepth;
            }
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branch = (BranchInstruction)instruction;
                if (instruction instanceof Select) {
                    InstructionHandle[] targets;
                    Select select = (Select)branch;
                    InstructionHandle[] instructionHandleArray = targets = select.getTargets();
                    int n3 = targets.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        InstructionHandle target = instructionHandleArray[n4];
                        branchTargets.push(target, stackDepth);
                        ++n4;
                    }
                    ih = null;
                } else if (!(branch instanceof IfInstruction)) {
                    if (opcode == 168 || opcode == 201) {
                        branchTargets.push(ih.getNext(), stackDepth - 1);
                    }
                    ih = null;
                }
                branchTargets.push(branch.getTarget(), stackDepth);
            } else if (opcode == 191 || opcode == 169 || opcode >= 172 && opcode <= 177) {
                ih = null;
            }
            if (ih != null) {
                ih = ih.getNext();
            }
            if (ih != null || (bt = branchTargets.pop()) == null) continue;
            ih = bt.target;
            stackDepth = bt.stackDepth;
        }
        return maxStackDepth;
    }

    public void addObserver(MethodObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList<MethodObserver>();
        }
        this.observers.add(o);
    }

    public void removeObserver(MethodObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (MethodObserver observer : this.observers) {
                observer.notify(this);
            }
        }
    }

    public final String toString() {
        String access = Utility.accessToString(super.getAccessFlags());
        String signature = Type.getMethodSignature(super.getType(), this.argTypes);
        signature = Utility.methodSignatureToString(signature, super.getName(), access, true, this.getLocalVariableTable(super.getConstantPool()));
        StringBuilder buf = new StringBuilder(signature);
        Attribute[] attributeArray = this.getAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute a = attributeArray[n2];
            if (!(a instanceof Code) && !(a instanceof ExceptionTable)) {
                buf.append(" [").append(a).append("]");
            }
            ++n2;
        }
        if (this.throwsList.size() > 0) {
            for (String throwsDescriptor : this.throwsList) {
                buf.append("\n\t\tthrows ").append(throwsDescriptor);
            }
        }
        return buf.toString();
    }

    public MethodGen copy(String className, ConstantPoolGen cp) {
        Method m = ((MethodGen)this.clone()).getMethod();
        MethodGen mg = new MethodGen(m, className, super.getConstantPool());
        if (super.getConstantPool() != cp) {
            mg.setConstantPool(cp);
            mg.getInstructionList().replaceConstantPool(super.getConstantPool(), cp);
        }
        return mg;
    }

    public List<AnnotationEntryGen> getAnnotationsOnParameter(int i) {
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations || i > this.argTypes.length) {
            return null;
        }
        return this.paramAnnotations[i];
    }

    private void ensureExistingParameterAnnotationsUnpacked() {
        if (this.haveUnpackedParameterAnnotations) {
            return;
        }
        Attribute[] attrs = this.getAttributes();
        ParameterAnnotations paramAnnVisAttr = null;
        ParameterAnnotations paramAnnInvisAttr = null;
        Attribute[] attributeArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof ParameterAnnotations) {
                if (!this.hasParameterAnnotations) {
                    List[] parmList = new List[this.argTypes.length];
                    this.paramAnnotations = parmList;
                    int j = 0;
                    while (j < this.argTypes.length) {
                        this.paramAnnotations[j] = new ArrayList<AnnotationEntryGen>();
                        ++j;
                    }
                }
                this.hasParameterAnnotations = true;
                ParameterAnnotations rpa = (ParameterAnnotations)attribute;
                if (rpa instanceof RuntimeVisibleParameterAnnotations) {
                    paramAnnVisAttr = rpa;
                } else {
                    paramAnnInvisAttr = rpa;
                }
                ParameterAnnotationEntry[] parameterAnnotationEntries = rpa.getParameterAnnotationEntries();
                int j = 0;
                while (j < parameterAnnotationEntries.length) {
                    ParameterAnnotationEntry immutableArray = rpa.getParameterAnnotationEntries()[j];
                    List<AnnotationEntryGen> mutable = this.makeMutableVersion(immutableArray.getAnnotationEntries());
                    this.paramAnnotations[j].addAll(mutable);
                    ++j;
                }
            }
            ++n2;
        }
        if (paramAnnVisAttr != null) {
            this.removeAttribute(paramAnnVisAttr);
        }
        if (paramAnnInvisAttr != null) {
            this.removeAttribute(paramAnnInvisAttr);
        }
        this.haveUnpackedParameterAnnotations = true;
    }

    private List<AnnotationEntryGen> makeMutableVersion(AnnotationEntry[] mutableArray) {
        ArrayList<AnnotationEntryGen> result = new ArrayList<AnnotationEntryGen>();
        AnnotationEntry[] annotationEntryArray = mutableArray;
        int n = mutableArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationEntry element = annotationEntryArray[n2];
            result.add(new AnnotationEntryGen(element, this.getConstantPool(), false));
            ++n2;
        }
        return result;
    }

    public void addParameterAnnotation(int parameterIndex, AnnotationEntryGen annotation) {
        List<AnnotationEntryGen> existingAnnotations;
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations) {
            List[] parmList = new List[this.argTypes.length];
            this.paramAnnotations = parmList;
            this.hasParameterAnnotations = true;
        }
        if ((existingAnnotations = this.paramAnnotations[parameterIndex]) != null) {
            existingAnnotations.add(annotation);
        } else {
            ArrayList<AnnotationEntryGen> l = new ArrayList<AnnotationEntryGen>();
            l.add(annotation);
            this.paramAnnotations[parameterIndex] = l;
        }
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator comparator) {
        bcelComparator = comparator;
    }

    public boolean equals(Object obj) {
        return bcelComparator.equals(this, obj);
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }

    static final class BranchStack {
        private final Stack<BranchTarget> branchTargets = new Stack();
        private final Hashtable<InstructionHandle, BranchTarget> visitedTargets = new Hashtable();

        BranchStack() {
        }

        public void push(InstructionHandle target, int stackDepth) {
            if (this.visited(target)) {
                return;
            }
            this.branchTargets.push(this.visit(target, stackDepth));
        }

        public BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget bt = this.branchTargets.pop();
                return bt;
            }
            return null;
        }

        private BranchTarget visit(InstructionHandle target, int stackDepth) {
            BranchTarget bt = new BranchTarget(target, stackDepth);
            this.visitedTargets.put(target, bt);
            return bt;
        }

        private boolean visited(InstructionHandle target) {
            return this.visitedTargets.get(target) != null;
        }
    }

    static final class BranchTarget {
        final InstructionHandle target;
        final int stackDepth;

        BranchTarget(InstructionHandle target, int stackDepth) {
            this.target = target;
            this.stackDepth = stackDepth;
        }
    }
}

