/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TABLESWITCH;

public final class SWITCH
implements CompoundInstruction {
    private int[] match;
    private InstructionHandle[] targets;
    private Select instruction;
    private int matchLength;

    public SWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target, int max_gap) {
        this.match = (int[])match.clone();
        this.targets = (InstructionHandle[])targets.clone();
        this.matchLength = match.length;
        if (this.matchLength < 2) {
            this.instruction = new TABLESWITCH(match, targets, target);
        } else {
            this.sort(0, this.matchLength - 1);
            if (this.matchIsOrdered(max_gap)) {
                this.fillup(max_gap, target);
                this.instruction = new TABLESWITCH(this.match, this.targets, target);
            } else {
                this.instruction = new LOOKUPSWITCH(this.match, this.targets, target);
            }
        }
    }

    public SWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target) {
        this(match, targets, target, 1);
    }

    private void fillup(int max_gap, InstructionHandle target) {
        int max_size = this.matchLength + this.matchLength * max_gap;
        int[] m_vec = new int[max_size];
        InstructionHandle[] t_vec = new InstructionHandle[max_size];
        int count = 1;
        m_vec[0] = this.match[0];
        t_vec[0] = this.targets[0];
        int i = 1;
        while (i < this.matchLength) {
            int prev = this.match[i - 1];
            int gap = this.match[i] - prev;
            int j = 1;
            while (j < gap) {
                m_vec[count] = prev + j;
                t_vec[count] = target;
                ++count;
                ++j;
            }
            m_vec[count] = this.match[i];
            t_vec[count] = this.targets[i];
            ++count;
            ++i;
        }
        this.match = new int[count];
        this.targets = new InstructionHandle[count];
        System.arraycopy(m_vec, 0, this.match, 0, count);
        System.arraycopy(t_vec, 0, this.targets, 0, count);
    }

    private void sort(int l, int r) {
        int i = l;
        int j = r;
        int m = this.match[l + r >>> 1];
        while (true) {
            if (this.match[i] < m) {
                ++i;
                continue;
            }
            while (m < this.match[j]) {
                --j;
            }
            if (i <= j) {
                int h = this.match[i];
                this.match[i] = this.match[j];
                this.match[j] = h;
                InstructionHandle h2 = this.targets[i];
                this.targets[i] = this.targets[j];
                this.targets[j] = h2;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            this.sort(l, j);
        }
        if (i < r) {
            this.sort(i, r);
        }
    }

    private boolean matchIsOrdered(int max_gap) {
        int i = 1;
        while (i < this.matchLength) {
            if (this.match[i] - this.match[i - 1] > max_gap) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }
}

