/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;

abstract class AbstractClassPathRepository
implements Repository {
    private final ClassPath _path;

    AbstractClassPathRepository(ClassPath classPath) {
        this._path = classPath;
    }

    @Override
    public abstract void storeClass(JavaClass var1);

    @Override
    public abstract void removeClass(JavaClass var1);

    @Override
    public abstract JavaClass findClass(String var1);

    @Override
    public abstract void clear();

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        if (className == null || className.isEmpty()) {
            throw new IllegalArgumentException("Invalid class name " + className);
        }
        JavaClass clazz = this.findClass(className = className.replace('/', '.'));
        if (clazz != null) {
            return clazz;
        }
        try {
            return this.loadClass(this._path.getInputStream(className), className);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
    }

    @Override
    public JavaClass loadClass(Class<?> clazz) throws ClassNotFoundException {
        String className = clazz.getName();
        JavaClass repositoryClass = this.findClass(className);
        if (repositoryClass != null) {
            return repositoryClass;
        }
        String name = className;
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (InputStream clsStream = clazz.getResourceAsStream(String.valueOf(name) + ".class");){
                return this.loadClass(clsStream, className);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JavaClass loadClass(InputStream inputStream, String className) throws ClassNotFoundException {
        block10: {
            JavaClass javaClass;
            try {
                if (inputStream == null) break block10;
                ClassParser parser = new ClassParser(inputStream, className);
                JavaClass clazz = parser.parse();
                this.storeClass(clazz);
                javaClass = clazz;
                if (inputStream == null) return javaClass;
            }
            catch (IOException e) {
                try {
                    throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
                }
                catch (Throwable throwable) {
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                inputStream.close();
                return javaClass;
            }
            catch (IOException iOException) {}
            return javaClass;
        }
        if (inputStream == null) throw new ClassNotFoundException("ClassRepository could not load " + className);
        try {
            inputStream.close();
            throw new ClassNotFoundException("ClassRepository could not load " + className);
        }
        catch (IOException iOException) {}
        throw new ClassNotFoundException("ClassRepository could not load " + className);
    }

    @Override
    public ClassPath getClassPath() {
        return this._path;
    }
}

