/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.Class2HTML;

final class ConstantHTML {
    private final String className;
    private final String classPackage;
    private final ConstantPool constantPool;
    private final PrintWriter file;
    private final String[] constantRef;
    private final Constant[] constants;
    private final Method[] methods;

    ConstantHTML(String dir, String class_name, String class_package, Method[] methods, ConstantPool constant_pool) throws IOException {
        this.className = class_name;
        this.classPackage = class_package;
        this.constantPool = constant_pool;
        this.methods = methods;
        this.constants = constant_pool.getConstantPool();
        this.file = new PrintWriter(new FileOutputStream(String.valueOf(dir) + class_name + "_cp.html"));
        this.constantRef = new String[this.constants.length];
        this.constantRef[0] = "&lt;unknown&gt;";
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
        int i = 1;
        while (i < this.constants.length) {
            if (i % 2 == 0) {
                this.file.print("<TR BGCOLOR=\"#C0C0C0\"><TD>");
            } else {
                this.file.print("<TR BGCOLOR=\"#A0A0A0\"><TD>");
            }
            if (this.constants[i] != null) {
                this.writeConstant(i);
            }
            this.file.print("</TD></TR>\n");
            ++i;
        }
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    String referenceConstant(int index) {
        return this.constantRef[index];
    }

    private void writeConstant(int index) {
        byte tag = this.constants[index].getTag();
        this.file.println("<H4> <A NAME=cp" + index + ">" + index + "</A> " + Const.getConstantName(tag) + "</H4>");
        switch (tag) {
            case 10: 
            case 11: {
                int name_index;
                int class_index;
                if (tag == 10) {
                    ConstantMethodref c = (ConstantMethodref)this.constantPool.getConstant(index, (byte)10);
                    class_index = c.getClassIndex();
                    name_index = c.getNameAndTypeIndex();
                } else {
                    ConstantInterfaceMethodref c1 = (ConstantInterfaceMethodref)this.constantPool.getConstant(index, (byte)11);
                    class_index = c1.getClassIndex();
                    name_index = c1.getNameAndTypeIndex();
                }
                String method_name = this.constantPool.constantToString(name_index, (byte)12);
                String html_method_name = Class2HTML.toHTML(method_name);
                String method_class = this.constantPool.constantToString(class_index, (byte)7);
                String short_method_class = Utility.compactClassName(method_class);
                short_method_class = Utility.compactClassName(short_method_class, String.valueOf(this.classPackage) + ".", true);
                ConstantNameAndType c2 = (ConstantNameAndType)this.constantPool.getConstant(name_index, (byte)12);
                String signature = this.constantPool.constantToString(c2.getSignatureIndex(), (byte)1);
                String[] args = Utility.methodSignatureArgumentTypes(signature, false);
                String type = Utility.methodSignatureReturnType(signature, false);
                String ret_type = Class2HTML.referenceType(type);
                StringBuilder buf = new StringBuilder("(");
                int i = 0;
                while (i < args.length) {
                    buf.append(Class2HTML.referenceType(args[i]));
                    if (i < args.length - 1) {
                        buf.append(",&nbsp;");
                    }
                    ++i;
                }
                buf.append(")");
                String arg_types = buf.toString();
                String ref = method_class.equals(this.className) ? "<A HREF=\"" + this.className + "_code.html#method" + this.getMethodNumber(String.valueOf(method_name) + signature) + "\" TARGET=Code>" + html_method_name + "</A>" : "<A HREF=\"" + method_class + ".html" + "\" TARGET=_top>" + short_method_class + "</A>." + html_method_name;
                this.constantRef[index] = String.valueOf(ret_type) + "&nbsp;<A HREF=\"" + this.className + "_cp.html#cp" + class_index + "\" TARGET=Constants>" + short_method_class + "</A>.<A HREF=\"" + this.className + "_cp.html#cp" + index + "\" TARGET=ConstantPool>" + html_method_name + "</A>&nbsp;" + arg_types;
                this.file.println("<P><TT>" + ret_type + "&nbsp;" + ref + arg_types + "&nbsp;</TT>\n<UL>" + "<LI><A HREF=\"#cp" + class_index + "\">Class index(" + class_index + ")</A>\n" + "<LI><A HREF=\"#cp" + name_index + "\">NameAndType index(" + name_index + ")</A></UL>");
                break;
            }
            case 9: {
                ConstantFieldref c3 = (ConstantFieldref)this.constantPool.getConstant(index, (byte)9);
                int class_index = c3.getClassIndex();
                int name_index = c3.getNameAndTypeIndex();
                String field_class = this.constantPool.constantToString(class_index, (byte)7);
                String short_field_class = Utility.compactClassName(field_class);
                short_field_class = Utility.compactClassName(short_field_class, String.valueOf(this.classPackage) + ".", true);
                String field_name = this.constantPool.constantToString(name_index, (byte)12);
                String ref = field_class.equals(this.className) ? "<A HREF=\"" + field_class + "_methods.html#field" + field_name + "\" TARGET=Methods>" + field_name + "</A>" : "<A HREF=\"" + field_class + ".html\" TARGET=_top>" + short_field_class + "</A>." + field_name + "\n";
                this.constantRef[index] = "<A HREF=\"" + this.className + "_cp.html#cp" + class_index + "\" TARGET=Constants>" + short_field_class + "</A>.<A HREF=\"" + this.className + "_cp.html#cp" + index + "\" TARGET=ConstantPool>" + field_name + "</A>";
                this.file.println("<P><TT>" + ref + "</TT><BR>\n" + "<UL>" + "<LI><A HREF=\"#cp" + class_index + "\">Class(" + class_index + ")</A><BR>\n" + "<LI><A HREF=\"#cp" + name_index + "\">NameAndType(" + name_index + ")</A></UL>");
                break;
            }
            case 7: {
                ConstantClass c4 = (ConstantClass)this.constantPool.getConstant(index, (byte)7);
                int name_index = c4.getNameIndex();
                String class_name2 = this.constantPool.constantToString(index, tag);
                String short_class_name = Utility.compactClassName(class_name2);
                short_class_name = Utility.compactClassName(short_class_name, String.valueOf(this.classPackage) + ".", true);
                String ref = "<A HREF=\"" + class_name2 + ".html\" TARGET=_top>" + short_class_name + "</A>";
                this.constantRef[index] = "<A HREF=\"" + this.className + "_cp.html#cp" + index + "\" TARGET=ConstantPool>" + short_class_name + "</A>";
                this.file.println("<P><TT>" + ref + "</TT><UL>" + "<LI><A HREF=\"#cp" + name_index + "\">Name index(" + name_index + ")</A></UL>\n");
                break;
            }
            case 8: {
                ConstantString c5 = (ConstantString)this.constantPool.getConstant(index, (byte)8);
                int name_index = c5.getStringIndex();
                String str = Class2HTML.toHTML(this.constantPool.constantToString(index, tag));
                this.file.println("<P><TT>" + str + "</TT><UL>" + "<LI><A HREF=\"#cp" + name_index + "\">Name index(" + name_index + ")</A></UL>\n");
                break;
            }
            case 12: {
                ConstantNameAndType c6 = (ConstantNameAndType)this.constantPool.getConstant(index, (byte)12);
                int name_index = c6.getNameIndex();
                int signature_index = c6.getSignatureIndex();
                this.file.println("<P><TT>" + Class2HTML.toHTML(this.constantPool.constantToString(index, tag)) + "</TT><UL>" + "<LI><A HREF=\"#cp" + name_index + "\">Name index(" + name_index + ")</A>\n" + "<LI><A HREF=\"#cp" + signature_index + "\">Signature index(" + signature_index + ")</A></UL>\n");
                break;
            }
            default: {
                this.file.println("<P><TT>" + Class2HTML.toHTML(this.constantPool.constantToString(index, tag)) + "</TT>\n");
            }
        }
    }

    private int getMethodNumber(String str) {
        int i = 0;
        while (i < this.methods.length) {
            String cmp = String.valueOf(this.methods[i].getName()) + this.methods[i].getSignature();
            if (cmp.equals(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

